/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup;

import jetbrains.charisma.service.BeansKt;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.markup.MarkupRender;
import jetbrains.youtrack.api.markup.MarkupRenderFactory;
import jetbrains.youtrack.api.markup.MentionedEntities;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.markup.MarkdownProcessor;
import jetbrains.youtrack.markup.WikiProcessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.commonmark.node.Node;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="markupRenderFactory")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/markup/MarkupProcessorFactoryImpl;", "Ljetbrains/youtrack/api/markup/MarkupRenderFactory;", "()V", "markdownRender", "Ljetbrains/youtrack/markup/MarkdownProcessor;", "wikiRender", "Ljetbrains/youtrack/markup/WikiProcessor;", "createBuilder", "Ljetbrains/youtrack/api/markup/MarkupRender;", "Builder", "youtrack-application"})
public final class MarkupProcessorFactoryImpl
implements MarkupRenderFactory {
    private final WikiProcessor wikiRender = new WikiProcessor();
    private final MarkdownProcessor markdownRender = new MarkdownProcessor();

    @NotNull
    public MarkupRender createBuilder() {
        return new Builder();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016J\u0012\u0010\u0005\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J$\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u000e\b\u0004\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0082\b\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0001H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/markup/MarkupProcessorFactoryImpl$Builder;", "Ljetbrains/youtrack/api/markup/MarkupRender;", "(Ljetbrains/youtrack/markup/MarkupProcessorFactoryImpl;)V", "absoluteLinks", "", "contextIssue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "expandStacktraces", "markdown", "noCSS", "noJs", "issue", "expand", "getMentionedEntities", "Ljetbrains/youtrack/api/markup/MentionedEntities;", "rawText", "", "useMarkdown", "parse", "Lorg/commonmark/node/Node;", "removeMarkup", "render", "smartTransactional", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "useSettingFromCurrentUserProfile", "youtrack-application"})
    public final class Builder
    implements MarkupRender {
        private boolean noJs;
        private boolean noCSS;
        private boolean absoluteLinks;
        private boolean markdown;
        private boolean expandStacktraces;
        private XdIssue contextIssue;

        @NotNull
        public MarkupRender noJs() {
            this.noJs = true;
            return this;
        }

        @NotNull
        public MarkupRender noCSS() {
            this.noCSS = true;
            return this;
        }

        @NotNull
        public MarkupRender absoluteLinks() {
            this.absoluteLinks = true;
            return this;
        }

        @NotNull
        public MarkupRender markdown(boolean useMarkdown2) {
            this.markdown = useMarkdown2;
            return this;
        }

        @NotNull
        public MarkupRender contextIssue(@Nullable XdIssue issue2) {
            this.contextIssue = issue2;
            return this;
        }

        @NotNull
        public MarkupRender expandStacktraces(boolean expand) {
            this.expandStacktraces = expand;
            return this;
        }

        @NotNull
        public MarkupRender useSettingFromCurrentUserProfile() {
            XdUser xdUser = jetbrains.youtrack.core.security.BeansKt.getXdLoggedInUserOrNull();
            if (xdUser == null) {
                Entity entity2 = jetbrains.youtrack.core.security.BeansKt.getSecurity().getGuest();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"security.guest");
                xdUser = (XdUser)XdExtensionsKt.toXd((Entity)entity2);
            }
            XdUser user2 = xdUser;
            this.expandStacktraces = BeansKt.getUserProfileService().getDisplayUserProfile(user2).isExceptionsExpanded();
            return this;
        }

        @NotNull
        public Node parse(@NotNull String rawText) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)rawText, (String)"rawText");
            Builder this_$iv = this;
            boolean $i$f$smartTransactional = false;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) {
                object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Node>(this, rawText){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ String $rawText$inlined;
                    {
                        this.this$0 = builder;
                        this.$rawText$inlined = string;
                        super(1);
                    }

                    public final Node invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        if (!Builder.access$getMarkdown$p(this.this$0)) {
                            throw (Throwable)new IllegalStateException("Wiki doesn't support parsing");
                        }
                        return MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).parse(this.$rawText$inlined, Builder.access$getContextIssue$p(this.this$0));
                    }
                }));
            } else {
                boolean bl = false;
                if (this.markdown) {
                    object = MarkupProcessorFactoryImpl.this.markdownRender.parse(rawText, this.contextIssue);
                } else {
                    throw (Throwable)new IllegalStateException("Wiki doesn't support parsing");
                }
            }
            return (Node)object;
        }

        @NotNull
        public String render(@Nullable String rawText) {
            Object object;
            if (rawText == null) {
                return "";
            }
            Builder this_$iv = this;
            boolean $i$f$smartTransactional = false;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) {
                object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(this, rawText){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ String $rawText$inlined;
                    {
                        this.this$0 = builder;
                        this.$rawText$inlined = string;
                        super(1);
                    }

                    public final String invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        return Builder.access$getMarkdown$p(this.this$0) ? MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).render(this.$rawText$inlined, Builder.access$getContextIssue$p(this.this$0), Builder.access$getAbsoluteLinks$p(this.this$0), Builder.access$getNoJs$p(this.this$0), Builder.access$getNoCSS$p(this.this$0), Builder.access$getExpandStacktraces$p(this.this$0)) : MarkupProcessorFactoryImpl.access$getWikiRender$p(this.this$0.MarkupProcessorFactoryImpl.this).render(this.$rawText$inlined, Builder.access$getContextIssue$p(this.this$0), Builder.access$getAbsoluteLinks$p(this.this$0), Builder.access$getNoJs$p(this.this$0), Builder.access$getExpandStacktraces$p(this.this$0));
                    }
                }));
            } else {
                boolean bl = false;
                object = this.markdown ? MarkupProcessorFactoryImpl.this.markdownRender.render(rawText, this.contextIssue, this.absoluteLinks, this.noJs, this.noCSS, this.expandStacktraces) : MarkupProcessorFactoryImpl.this.wikiRender.render(rawText, this.contextIssue, this.absoluteLinks, this.noJs, this.expandStacktraces);
            }
            return (String)object;
        }

        @NotNull
        public String render(@NotNull XdIssue issue2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Builder this_$iv = this;
            boolean $i$f$smartTransactional = false;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) {
                object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(this, issue2){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ XdIssue $issue$inlined;
                    {
                        this.this$0 = builder;
                        this.$issue$inlined = xdIssue;
                        super(1);
                    }

                    public final String invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        return Builder.access$getMarkdown$p(this.this$0) ? MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).render(this.$issue$inlined, Builder.access$getAbsoluteLinks$p(this.this$0), Builder.access$getNoJs$p(this.this$0), Builder.access$getNoCSS$p(this.this$0), Builder.access$getExpandStacktraces$p(this.this$0)) : this.this$0.render(this.$issue$inlined.getDescription());
                    }
                }));
            } else {
                boolean bl = false;
                object = this.markdown ? MarkupProcessorFactoryImpl.this.markdownRender.render(issue2, this.absoluteLinks, this.noJs, this.noCSS, this.expandStacktraces) : this.render(issue2.getDescription());
            }
            return (String)object;
        }

        @NotNull
        public String removeMarkup(@Nullable String rawText) {
            Object object;
            if (rawText == null) {
                return "";
            }
            Builder this_$iv = this;
            boolean $i$f$smartTransactional = false;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) {
                object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(this, rawText){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ String $rawText$inlined;
                    {
                        this.this$0 = builder;
                        this.$rawText$inlined = string;
                        super(1);
                    }

                    public final String invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        return Builder.access$getMarkdown$p(this.this$0) ? MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).removeMarkup(this.$rawText$inlined) : MarkupProcessorFactoryImpl.access$getWikiRender$p(this.this$0.MarkupProcessorFactoryImpl.this).removeMarkup(this.$rawText$inlined);
                    }
                }));
            } else {
                boolean bl = false;
                object = this.markdown ? MarkupProcessorFactoryImpl.this.markdownRender.removeMarkup(rawText) : MarkupProcessorFactoryImpl.this.wikiRender.removeMarkup(rawText);
            }
            return (String)object;
        }

        @NotNull
        public String removeMarkup(@NotNull XdIssue issue2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
            Builder this_$iv = this;
            boolean $i$f$smartTransactional = false;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession == null) {
                object = LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(this, issue2){
                    final /* synthetic */ Builder this$0;
                    final /* synthetic */ XdIssue $issue$inlined;
                    {
                        this.this$0 = builder;
                        this.$issue$inlined = xdIssue;
                        super(1);
                    }

                    public final String invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        return Builder.access$getMarkdown$p(this.this$0) ? MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).removeMarkup(this.$issue$inlined) : this.this$0.removeMarkup(this.$issue$inlined.getDescription());
                    }
                }));
            } else {
                boolean bl = false;
                object = this.markdown ? MarkupProcessorFactoryImpl.this.markdownRender.removeMarkup(issue2) : this.removeMarkup(issue2.getDescription());
            }
            return (String)object;
        }

        @NotNull
        public MentionedEntities getMentionedEntities(@Nullable String rawText) {
            block3: {
                block2: {
                    if (rawText == null) break block2;
                    CharSequence charSequence = rawText;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) break block3;
                }
                return new MentionedEntities((Iterable)CollectionsKt.emptyList(), (Iterable)CollectionsKt.emptyList(), (Iterable)CollectionsKt.emptyList());
            }
            return (MentionedEntities)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, MentionedEntities>(this, rawText){
                final /* synthetic */ Builder this$0;
                final /* synthetic */ String $rawText;

                @NotNull
                public final MentionedEntities invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Builder.access$getMarkdown$p(this.this$0) ? MarkupProcessorFactoryImpl.access$getMarkdownRender$p(this.this$0.MarkupProcessorFactoryImpl.this).getMentionedEntities(this.$rawText) : MarkupProcessorFactoryImpl.access$getWikiRender$p(this.this$0.MarkupProcessorFactoryImpl.this).getMentionedEntities(this.$rawText);
                }
                {
                    this.this$0 = builder;
                    this.$rawText = string;
                    super(1);
                }
            }));
        }

        private final <R> R smartTransactional(Function0<? extends R> block) {
            int $i$f$smartTransactional = 0;
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            return (R)(transientStoreSession == null ? LegacySupportKt.transactional((Function1)new Function1<TransientStoreSession, R>(block){
                final /* synthetic */ Function0 $block;

                public final R invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return (R)this.$block.invoke();
                }
                {
                    this.$block = function0;
                    super(1);
                }
            }) : block.invoke());
        }

        public static final /* synthetic */ void access$setMarkdown$p(Builder $this, boolean bl) {
            $this.markdown = bl;
        }

        public static final /* synthetic */ void access$setContextIssue$p(Builder $this, XdIssue xdIssue) {
            $this.contextIssue = xdIssue;
        }

        public static final /* synthetic */ void access$setAbsoluteLinks$p(Builder $this, boolean bl) {
            $this.absoluteLinks = bl;
        }

        public static final /* synthetic */ void access$setNoJs$p(Builder $this, boolean bl) {
            $this.noJs = bl;
        }

        public static final /* synthetic */ void access$setNoCSS$p(Builder $this, boolean bl) {
            $this.noCSS = bl;
        }

        public static final /* synthetic */ void access$setExpandStacktraces$p(Builder $this, boolean bl) {
            $this.expandStacktraces = bl;
        }
    }
}

