/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup;

import jetbrains.charisma.service.BeansKt;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiJsDocIgnore;
import jetbrains.youtrack.core.annotations.ApiJsOptional;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiSince;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0007\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00012\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"wikify", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "text", "usingMarkdown", "", "youtrack-application"})
public final class WorkflowExtensionsKt {
    @ApiJsDocIgnore
    @ApiMethod(scopes={})
    @NotNull
    public static final String wikify(@NotNull XdIssue $this$wikify, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)$this$wikify, (String)"$this$wikify");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return WorkflowExtensionsKt.wikify($this$wikify, text, $this$wikify.getUsesMarkdown());
    }

    @ApiDoc(value="Converts text with Markdown or YouTrack Wiki markup to HTML. Use this method to send \"pretty\" notifications.\n@example\nissue.Assignee.notify('Comment added:', issue.wikify(comment.text, comment.isUsingMarkdown));")
    @ApiDocReturns(value="The wikified string.")
    @ApiMethod(scopes={})
    @NotNull
    public static final String wikify(@NotNull XdIssue $this$wikify, @ApiDoc(value="The string of text to convert to HTML.") @NotNull String text, @ApiJsOptional @ApiSince(value="2018.1.40100") @ApiDoc(value="If `true`, the markup is parsed as Markdown. If `false`, the markup is parsed as YouTrack Wiki. If omitted, issue.isUsingMarkdown is used implicitly.") boolean usingMarkdown) {
        Intrinsics.checkParameterIsNotNull((Object)$this$wikify, (String)"$this$wikify");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return BeansKt.getMarkupRenderFactory().createBuilder().noJs().absoluteLinks().markdown(usingMarkdown).contextIssue($this$wikify).render(text);
    }
}

