/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.youtrack.core.persistent.article.XdArticle;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.markup.cache.FieldValueEncoder;
import jetbrains.youtrack.markup.cache.NodeSerializers;
import jetbrains.youtrack.markup.extensions.ArticleLink;
import jetbrains.youtrack.markup.extensions.CheckboxListNode;
import jetbrains.youtrack.markup.extensions.CheckboxNode;
import jetbrains.youtrack.markup.extensions.CommitLink;
import jetbrains.youtrack.markup.extensions.ExceptionFilePath;
import jetbrains.youtrack.markup.extensions.ExceptionLinePrefix;
import jetbrains.youtrack.markup.extensions.GoogleDocumentNode;
import jetbrains.youtrack.markup.extensions.IssueLink;
import jetbrains.youtrack.markup.extensions.StacktraceNode;
import jetbrains.youtrack.markup.extensions.UserLink;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.util.IdsKt;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.image.attributes.ImageAttributes;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u001c\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J&\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\b\"\b\b\u0000\u0010\r*\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0005\u001a2\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0006j\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers;", "", "()V", "fieldEncoder", "Ljetbrains/youtrack/markup/cache/FieldValueEncoder;", "serializers", "Ljava/util/HashMap;", "", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Node;", "Lkotlin/collections/HashMap;", "get", "key", "T", "cls", "Lkotlin/reflect/KClass;", "ArticleLinkSerializer", "BulletListSerializer", "CheckboxListNodeSerializer", "CheckboxNodeSerializer", "CodeSerializer", "CommitLinkSerializer", "EmphasisSerializer", "ExceptionFilePathSerializer", "ExceptionLinePrefixSerializer", "FencedCodeBlockSerializer", "GoogleDocumentNodeSerializer", "HeadingSerializer", "HtmlBlockSerializer", "HtmlInlineSerializer", "ImageAttributesSerializer", "ImageSerializer", "IndentedCodeBlockSerializer", "IssueLinkSerializer", "LinkReferenceDefinitionSerializer", "LinkSerializer", "NodeSerializer", "OrderedListSerializer", "StacktraceNodeSerializer", "StrongEmphasisSerializer", "TableCellSerializer", "TextSerializer", "TrivialNodeSerializer", "UserLinkSerializer", "youtrack-application"})
public final class NodeSerializers {
    private static final FieldValueEncoder fieldEncoder;
    private static final HashMap<String, NodeSerializer<? extends Node>> serializers;
    public static final NodeSerializers INSTANCE;

    @Nullable
    public final NodeSerializer<?> get(@NotNull String key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return serializers.get(key2);
    }

    @Nullable
    public final <T extends Node> NodeSerializer<T> get(@NotNull KClass<T> cls) {
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        return serializers.get(cls.getSimpleName());
    }

    private NodeSerializers() {
    }

    static {
        NodeSerializers nodeSerializers;
        INSTANCE = nodeSerializers = new NodeSerializers();
        fieldEncoder = new FieldValueEncoder();
        serializers = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BlockQuote.class).getSimpleName(), new TrivialNodeSerializer(serializers.1.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(BulletList.class).getSimpleName(), (Object)new BulletListSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Code.class).getSimpleName(), (Object)new CodeSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Document.class).getSimpleName(), new TrivialNodeSerializer(serializers.2.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Emphasis.class).getSimpleName(), (Object)new EmphasisSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(FencedCodeBlock.class).getSimpleName(), (Object)new FencedCodeBlockSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HardLineBreak.class).getSimpleName(), new TrivialNodeSerializer(serializers.3.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Heading.class).getSimpleName(), (Object)new HeadingSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HtmlBlock.class).getSimpleName(), (Object)new HtmlBlockSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(HtmlInline.class).getSimpleName(), (Object)new HtmlInlineSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Image.class).getSimpleName(), (Object)new ImageSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ImageAttributes.class).getSimpleName(), (Object)new ImageAttributesSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(IndentedCodeBlock.class).getSimpleName(), (Object)new IndentedCodeBlockSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Link.class).getSimpleName(), (Object)new LinkSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(LinkReferenceDefinition.class).getSimpleName(), (Object)new LinkReferenceDefinitionSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ListItem.class).getSimpleName(), new TrivialNodeSerializer(serializers.4.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(OrderedList.class).getSimpleName(), (Object)new OrderedListSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Paragraph.class).getSimpleName(), new TrivialNodeSerializer(serializers.5.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(SoftLineBreak.class).getSimpleName(), new TrivialNodeSerializer(serializers.6.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Strikethrough.class).getSimpleName(), new TrivialNodeSerializer(serializers.7.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(StrongEmphasis.class).getSimpleName(), (Object)new StrongEmphasisSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(TableBlock.class).getSimpleName(), new TrivialNodeSerializer(serializers.8.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(TableBody.class).getSimpleName(), new TrivialNodeSerializer(serializers.9.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(TableCell.class).getSimpleName(), (Object)new TableCellSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(TableHead.class).getSimpleName(), new TrivialNodeSerializer(serializers.10.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(TableRow.class).getSimpleName(), new TrivialNodeSerializer(serializers.11.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ThematicBreak.class).getSimpleName(), new TrivialNodeSerializer(serializers.12.INSTANCE)), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(Text.class).getSimpleName(), (Object)new TextSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ArticleLink.class).getSimpleName(), (Object)new ArticleLinkSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(CheckboxListNode.class).getSimpleName(), (Object)new CheckboxListNodeSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(CheckboxNode.class).getSimpleName(), (Object)new CheckboxNodeSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(CommitLink.class).getSimpleName(), (Object)new CommitLinkSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ExceptionFilePath.class).getSimpleName(), (Object)new ExceptionFilePathSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(ExceptionLinePrefix.class).getSimpleName(), (Object)new ExceptionLinePrefixSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(GoogleDocumentNode.class).getSimpleName(), (Object)new GoogleDocumentNodeSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(IssueLink.class).getSimpleName(), (Object)new IssueLinkSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(StacktraceNode.class).getSimpleName(), (Object)new StacktraceNodeSerializer()), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(UserLink.class).getSimpleName(), (Object)new UserLinkSerializer())});
    }

    public static final /* synthetic */ FieldValueEncoder access$getFieldEncoder$p(NodeSerializers $this) {
        NodeSerializers nodeSerializers = $this;
        return fieldEncoder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "T", "Lorg/commonmark/node/Node;", "", "deserialize", "source", "", "(Ljava/lang/String;)Lorg/commonmark/node/Node;", "serialize", "node", "(Lorg/commonmark/node/Node;)Ljava/lang/String;", "youtrack-application"})
    public static interface NodeSerializer<T extends Node> {
        @NotNull
        public String serialize(@NotNull T var1);

        @NotNull
        public T deserialize(@NotNull String var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static <T extends Node> String serialize(NodeSerializer<T> $this, @NotNull T node2) {
                Intrinsics.checkParameterIsNotNull(node2, (String)"node");
                return "";
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$TrivialNodeSerializer;", "T", "Lorg/commonmark/node/Node;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "init", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "getInit", "()Lkotlin/jvm/functions/Function0;", "deserialize", "source", "", "(Ljava/lang/String;)Lorg/commonmark/node/Node;", "youtrack-application"})
    private static final class TrivialNodeSerializer<T extends Node>
    implements NodeSerializer<T> {
        @NotNull
        private final Function0<T> init;

        @Override
        @NotNull
        public T deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return (T)((Node)this.init.invoke());
        }

        @NotNull
        public final Function0<T> getInit() {
            return this.init;
        }

        public TrivialNodeSerializer(@NotNull Function0<? extends T> init2) {
            Intrinsics.checkParameterIsNotNull(init2, (String)"init");
            this.init = init2;
        }

        @Override
        @NotNull
        public String serialize(@NotNull T node2) {
            Intrinsics.checkParameterIsNotNull(node2, (String)"node");
            return NodeSerializer.DefaultImpls.serialize(this, node2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$BulletListSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/BulletList;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class BulletListSerializer
    implements NodeSerializer<BulletList> {
        @Override
        @NotNull
        public String serialize(@NotNull BulletList node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(Character.valueOf(node2.getBulletMarker()), node2.isTight());
        }

        @Override
        @NotNull
        public BulletList deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            BulletList bulletList = new BulletList();
            boolean bl = false;
            boolean bl2 = false;
            BulletList it = bulletList;
            boolean bl3 = false;
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            String string = (String)fields2.next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Bullet marker is expected");
            }
            it.setBulletMarker(StringsKt.first((CharSequence)string));
            String string2 = (String)fields2.next();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("Bullet list should be either tight or loose");
            }
            String string3 = string2;
            BulletList bulletList2 = it;
            boolean bl4 = false;
            boolean bl5 = Boolean.parseBoolean(string3);
            bulletList2.setTight(bl5);
            return bulletList;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$CodeSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Code;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class CodeSerializer
    implements NodeSerializer<Code> {
        @Override
        @NotNull
        public String serialize(@NotNull Code node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral());
        }

        @Override
        @NotNull
        public Code deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new Code((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$EmphasisSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Emphasis;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class EmphasisSerializer
    implements NodeSerializer<Emphasis> {
        @Override
        @NotNull
        public String serialize(@NotNull Emphasis node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getClosingDelimiter());
        }

        @Override
        @NotNull
        public Emphasis deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new Emphasis((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$FencedCodeBlockSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/FencedCodeBlock;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class FencedCodeBlockSerializer
    implements NodeSerializer<FencedCodeBlock> {
        @Override
        @NotNull
        public String serialize(@NotNull FencedCodeBlock node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getInfo(), node2.getLiteral(), Character.valueOf(node2.getFenceChar()), node2.getFenceIndent(), node2.getFenceLength());
        }

        @Override
        @NotNull
        public FencedCodeBlock deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            FencedCodeBlock fencedCodeBlock = new FencedCodeBlock();
            boolean bl = false;
            boolean bl2 = false;
            FencedCodeBlock it = fencedCodeBlock;
            boolean bl3 = false;
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            it.setInfo((String)fields2.next());
            it.setLiteral((String)fields2.next());
            String string = (String)fields2.next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Fence char is expected");
            }
            it.setFenceChar(StringsKt.first((CharSequence)string));
            String string2 = (String)fields2.next();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("Fence indent is expected");
            }
            String string3 = string2;
            FencedCodeBlock fencedCodeBlock2 = it;
            boolean bl4 = false;
            int n = Integer.parseInt(string3);
            fencedCodeBlock2.setFenceIndent(n);
            String string4 = (String)fields2.next();
            if (string4 == null) {
                throw (Throwable)new IllegalArgumentException("Fence length is expected");
            }
            string3 = string4;
            fencedCodeBlock2 = it;
            bl4 = false;
            n = Integer.parseInt(string3);
            fencedCodeBlock2.setFenceLength(n);
            return fencedCodeBlock;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$HeadingSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Heading;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class HeadingSerializer
    implements NodeSerializer<Heading> {
        @Override
        @NotNull
        public String serialize(@NotNull Heading node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLevel());
        }

        @Override
        @NotNull
        public Heading deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Heading heading = new Heading();
            boolean bl = false;
            boolean bl2 = false;
            Heading it = heading;
            boolean bl3 = false;
            String string = (String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Heading level is expected");
            }
            String string2 = string;
            Heading heading2 = it;
            boolean bl4 = false;
            int n = Integer.parseInt(string2);
            heading2.setLevel(n);
            return heading;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$HtmlBlockSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/HtmlBlock;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class HtmlBlockSerializer
    implements NodeSerializer<HtmlBlock> {
        @Override
        @NotNull
        public String serialize(@NotNull HtmlBlock node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral());
        }

        @Override
        @NotNull
        public HtmlBlock deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            HtmlBlock htmlBlock = new HtmlBlock();
            boolean bl = false;
            boolean bl2 = false;
            HtmlBlock it = htmlBlock;
            boolean bl3 = false;
            it.setLiteral((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
            return htmlBlock;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$HtmlInlineSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/HtmlInline;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class HtmlInlineSerializer
    implements NodeSerializer<HtmlInline> {
        @Override
        @NotNull
        public String serialize(@NotNull HtmlInline node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral());
        }

        @Override
        @NotNull
        public HtmlInline deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            HtmlInline htmlInline = new HtmlInline();
            boolean bl = false;
            boolean bl2 = false;
            HtmlInline it = htmlInline;
            boolean bl3 = false;
            it.setLiteral((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
            return htmlInline;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$ImageSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Image;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class ImageSerializer
    implements NodeSerializer<Image> {
        @Override
        @NotNull
        public String serialize(@NotNull Image node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getDestination(), node2.getTitle());
        }

        @Override
        @NotNull
        public Image deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            return new Image((String)fields2.next(), (String)fields2.next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$ImageAttributesSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/ext/image/attributes/ImageAttributes;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class ImageAttributesSerializer
    implements NodeSerializer<ImageAttributes> {
        @Override
        @NotNull
        public String serialize(@NotNull ImageAttributes node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getAttributes().get("height"), node2.getAttributes().get("width"));
        }

        @Override
        @NotNull
        public ImageAttributes deserialize(@NotNull String source) {
            Map map2;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            Map $this$filterValues$iv = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"height", fields2.next()), TuplesKt.to((Object)"width", fields2.next())});
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map map3 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : map3.entrySet()) {
                String it = (String)entry$iv.getValue();
                boolean bl2 = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map4 = map2 = (Map)result$iv;
            return new ImageAttributes(map4);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$IndentedCodeBlockSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/IndentedCodeBlock;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class IndentedCodeBlockSerializer
    implements NodeSerializer<IndentedCodeBlock> {
        @Override
        @NotNull
        public String serialize(@NotNull IndentedCodeBlock node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral());
        }

        @Override
        @NotNull
        public IndentedCodeBlock deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            IndentedCodeBlock indentedCodeBlock = new IndentedCodeBlock();
            boolean bl = false;
            boolean bl2 = false;
            IndentedCodeBlock it = indentedCodeBlock;
            boolean bl3 = false;
            it.setLiteral((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
            return indentedCodeBlock;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$LinkSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Link;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class LinkSerializer
    implements NodeSerializer<Link> {
        @Override
        @NotNull
        public String serialize(@NotNull Link node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getDestination(), node2.getTitle());
        }

        @Override
        @NotNull
        public Link deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            return new Link((String)fields2.next(), (String)fields2.next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$LinkReferenceDefinitionSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/LinkReferenceDefinition;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class LinkReferenceDefinitionSerializer
    implements NodeSerializer<LinkReferenceDefinition> {
        @Override
        @NotNull
        public String serialize(@NotNull LinkReferenceDefinition node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLabel(), node2.getDestination(), node2.getTitle());
        }

        @Override
        @NotNull
        public LinkReferenceDefinition deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            return new LinkReferenceDefinition((String)fields2.next(), (String)fields2.next(), (String)fields2.next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$OrderedListSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/OrderedList;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class OrderedListSerializer
    implements NodeSerializer<OrderedList> {
        @Override
        @NotNull
        public String serialize(@NotNull OrderedList node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(Character.valueOf(node2.getDelimiter()), node2.getStartNumber(), node2.isTight());
        }

        @Override
        @NotNull
        public OrderedList deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            OrderedList orderedList = new OrderedList();
            boolean bl = false;
            boolean bl2 = false;
            OrderedList it = orderedList;
            boolean bl3 = false;
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            String string = (String)fields2.next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("List marker is expected");
            }
            it.setDelimiter(StringsKt.first((CharSequence)string));
            String string2 = (String)fields2.next();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("List start number is expected");
            }
            String string3 = string2;
            OrderedList orderedList2 = it;
            boolean bl4 = false;
            int bl5 = Integer.parseInt(string3);
            orderedList2.setStartNumber(bl5);
            String string4 = (String)fields2.next();
            if (string4 == null) {
                throw (Throwable)new IllegalArgumentException("Ordered list should be either tight or loose");
            }
            string3 = string4;
            orderedList2 = it;
            bl4 = false;
            boolean bl6 = Boolean.parseBoolean(string3);
            orderedList2.setTight(bl6);
            return orderedList;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$StrongEmphasisSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/StrongEmphasis;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class StrongEmphasisSerializer
    implements NodeSerializer<StrongEmphasis> {
        @Override
        @NotNull
        public String serialize(@NotNull StrongEmphasis node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getClosingDelimiter());
        }

        @Override
        @NotNull
        public StrongEmphasis deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new StrongEmphasis((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$TableCellSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/ext/gfm/tables/TableCell;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class TableCellSerializer
    implements NodeSerializer<TableCell> {
        @Override
        @NotNull
        public String serialize(@NotNull TableCell node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.isHeader(), node2.getAlignment());
        }

        @Override
        @NotNull
        public TableCell deserialize(@NotNull String source) {
            TableCell tableCell;
            block2: {
                boolean bl;
                boolean bl2;
                String string;
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                tableCell = new TableCell();
                boolean bl3 = false;
                boolean bl4 = false;
                TableCell cell = tableCell;
                boolean bl5 = false;
                Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
                TableCell tableCell2 = cell;
                String string2 = (String)fields2.next();
                if (string2 != null) {
                    string = string2;
                    TableCell tableCell3 = tableCell2;
                    bl2 = false;
                    boolean bl6 = Boolean.parseBoolean(string);
                    tableCell2 = tableCell3;
                    bl = bl6;
                } else {
                    bl = false;
                }
                tableCell2.setHeader(bl);
                String string3 = (String)fields2.next();
                if (string3 == null) break block2;
                string = string3;
                bl2 = false;
                boolean bl7 = false;
                String it = string;
                boolean bl8 = false;
                cell.setAlignment(TableCell.Alignment.valueOf((String)it));
            }
            return tableCell;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$TextSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Lorg/commonmark/node/Text;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class TextSerializer
    implements NodeSerializer<Text> {
        @Override
        @NotNull
        public String serialize(@NotNull Text node2) {
            Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral());
        }

        @Override
        @NotNull
        public Text deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new Text((String)NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next());
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$CommitLinkSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/CommitLink;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class CommitLinkSerializer
    implements NodeSerializer<CommitLink> {
        @Override
        @NotNull
        public String serialize(@NotNull CommitLink node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getSha());
        }

        @Override
        @NotNull
        public CommitLink deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new CommitLink((String)e);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$ExceptionFilePathSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/ExceptionFilePath;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class ExceptionFilePathSerializer
    implements NodeSerializer<ExceptionFilePath> {
        @Override
        @NotNull
        public String serialize(@NotNull ExceptionFilePath node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getPackageName(), node2.getFullPrefix(), node2.getLineNumber(), node2.getFileName(), node2.getExtension());
        }

        @Override
        @NotNull
        public ExceptionFilePath deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator iterator2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            Object e = iterator2.next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)e;
            Object e2 = iterator2.next();
            if (e2 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = (String)e2;
            Object e3 = iterator2.next();
            if (e3 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = (String)e3;
            Object e4 = iterator2.next();
            if (e4 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = (String)e4;
            Object e5 = iterator2.next();
            if (e5 == null) {
                Intrinsics.throwNpe();
            }
            return new ExceptionFilePath(string, string2, string3, string4, (String)e5);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$ArticleLinkSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/ArticleLink;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class ArticleLinkSerializer
    implements NodeSerializer<ArticleLink> {
        @Override
        @NotNull
        public String serialize(@NotNull ArticleLink node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(((XdArticle)node2.getEntity()).getXdId());
        }

        @Override
        @NotNull
        public ArticleLink deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            XdEntityType xdEntityType = (XdEntityType)XdArticle.Companion;
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new ArticleLink((XdArticle)IdsKt.findById((XdEntityType)xdEntityType, (String)((String)e)));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$CheckboxListNodeSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/CheckboxListNode;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class CheckboxListNodeSerializer
    implements NodeSerializer<CheckboxListNode> {
        @Override
        @NotNull
        public String serialize(@NotNull CheckboxListNode node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(Character.valueOf(node2.getBulletMarker()), node2.isTight());
        }

        @Override
        @NotNull
        public CheckboxListNode deserialize(@NotNull String source) {
            BulletList bulletList;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            BulletList bulletList2 = new BulletList();
            boolean bl = false;
            boolean bl2 = false;
            BulletList it = bulletList2;
            boolean bl3 = false;
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            String string = (String)fields2.next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Bullet marker is expected");
            }
            it.setBulletMarker(StringsKt.first((CharSequence)string));
            String string2 = (String)fields2.next();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("Bullet list should be either tight or loose");
            }
            String string3 = string2;
            BulletList bulletList3 = it;
            boolean bl4 = false;
            boolean bl5 = Boolean.parseBoolean(string3);
            bulletList3.setTight(bl5);
            BulletList bulletList4 = bulletList = bulletList2;
            return new CheckboxListNode(bulletList4);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$CheckboxNodeSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/CheckboxNode;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class CheckboxNodeSerializer
    implements NodeSerializer<CheckboxNode> {
        @Override
        @NotNull
        public String serialize(@NotNull CheckboxNode node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getLiteral(), node2.getPosition(), node2.getChecked(), node2.getLabelText());
        }

        @Override
        @NotNull
        public CheckboxNode deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Iterator fields2 = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator();
            String string = (String)fields2.next();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("Literal is expected");
            }
            String literal = string;
            String string2 = (String)fields2.next();
            if (string2 == null) {
                throw (Throwable)new IllegalArgumentException("Position marker is expected");
            }
            String string3 = string2;
            boolean bl = false;
            int position = Integer.parseInt(string3);
            String string4 = (String)fields2.next();
            if (string4 == null) {
                throw (Throwable)new IllegalArgumentException("Checked value is missing");
            }
            String string5 = string4;
            boolean bl2 = false;
            boolean checked = Boolean.parseBoolean(string5);
            return new CheckboxNode(literal, position, checked, fields2.hasNext() ? (String)fields2.next() : null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$ExceptionLinePrefixSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/ExceptionLinePrefix;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class ExceptionLinePrefixSerializer
    implements NodeSerializer<ExceptionLinePrefix> {
        @Override
        @NotNull
        public String serialize(@NotNull ExceptionLinePrefix node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getText());
        }

        @Override
        @NotNull
        public ExceptionLinePrefix deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new ExceptionLinePrefix((String)e);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$GoogleDocumentNodeSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/GoogleDocumentNode;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class GoogleDocumentNodeSerializer
    implements NodeSerializer<GoogleDocumentNode> {
        @Override
        @NotNull
        public String serialize(@NotNull GoogleDocumentNode node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getDestination());
        }

        @Override
        @NotNull
        public GoogleDocumentNode deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new GoogleDocumentNode((String)e);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$IssueLinkSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/IssueLink;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class IssueLinkSerializer
    implements NodeSerializer<IssueLink> {
        @Override
        @NotNull
        public String serialize(@NotNull IssueLink node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(((XdIssue)node2.getEntity()).getXdId());
        }

        @Override
        @NotNull
        public IssueLink deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            XdEntityType xdEntityType = (XdEntityType)XdIssue.Companion;
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new IssueLink((XdIssue)IdsKt.findById((XdEntityType)xdEntityType, (String)((String)e)));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$StacktraceNodeSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/StacktraceNode;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class StacktraceNodeSerializer
    implements NodeSerializer<StacktraceNode> {
        @Override
        @NotNull
        public String serialize(@NotNull StacktraceNode node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(node2.getStacktrace());
        }

        @Override
        @NotNull
        public StacktraceNode deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new StacktraceNode((String)e);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/markup/cache/NodeSerializers$UserLinkSerializer;", "Ljetbrains/youtrack/markup/cache/NodeSerializers$NodeSerializer;", "Ljetbrains/youtrack/markup/extensions/UserLink;", "()V", "deserialize", "source", "", "serialize", "node", "youtrack-application"})
    private static final class UserLinkSerializer
    implements NodeSerializer<UserLink> {
        @Override
        @NotNull
        public String serialize(@NotNull UserLink node2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)node2), (String)"node");
            return NodeSerializers.access$getFieldEncoder$p(INSTANCE).encodeValues(((XdUser)node2.getEntity()).getXdId());
        }

        @Override
        @NotNull
        public UserLink deserialize(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            XdEntityType xdEntityType = (XdEntityType)XdUser.Companion;
            Object e = NodeSerializers.access$getFieldEncoder$p(INSTANCE).decodeValues(source).iterator().next();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            return new UserLink((XdUser)IdsKt.findById((XdEntityType)xdEntityType, (String)((String)e)));
        }
    }
}

