/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.extensions;

import java.util.regex.Pattern;
import jetbrains.charisma.service.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.markup.extensions.AbstractPostProcessor;
import jetbrains.youtrack.markup.extensions.RegexpExtractionResult;
import jetbrains.youtrack.markup.extensions.RegexpExtractor;
import jetbrains.youtrack.markup.extensions.RegexpLinkPostProcessor;
import jetbrains.youtrack.markup.extensions.UserLink;
import jetbrains.youtrack.markup.extensions.UserLinkExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;
import org.commonmark.renderer.html.HtmlNodeRendererFactory;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension;", "Lorg/commonmark/parser/Parser$ParserExtension;", "Lorg/commonmark/renderer/html/HtmlRenderer$HtmlRendererExtension;", "()V", "extend", "", "parserBuilder", "Lorg/commonmark/parser/Parser$Builder;", "rendererBuilder", "Lorg/commonmark/renderer/html/HtmlRenderer$Builder;", "UserLinkPostProcessor", "youtrack-application"})
public final class UserLinkExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension {
    public void extend(@NotNull Parser.Builder parserBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)parserBuilder, (String)"parserBuilder");
        parserBuilder.postProcessor((PostProcessor)new UserLinkPostProcessor());
    }

    public void extend(@NotNull HtmlRenderer.Builder rendererBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)rendererBuilder, (String)"rendererBuilder");
        rendererBuilder.nodeRendererFactory((HtmlNodeRendererFactory)extend.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00060\fR\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension$UserLinkPostProcessor;", "Ljetbrains/youtrack/markup/extensions/RegexpLinkPostProcessor;", "()V", "extractor", "Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "getExtractor", "()Ljetbrains/youtrack/markup/extensions/RegexpExtractor;", "createUserNode", "Lorg/commonmark/node/Node;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "replacementOf", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor$ReplacementResult;", "Ljetbrains/youtrack/markup/extensions/AbstractPostProcessor;", "result", "Ljetbrains/youtrack/markup/extensions/RegexpExtractionResult;", "visit", "", "text", "Lorg/commonmark/node/Text;", "Companion", "youtrack-application"})
    public static final class UserLinkPostProcessor
    extends RegexpLinkPostProcessor {
        @NotNull
        private final RegexpExtractor extractor;
        private static final Pattern pattern;
        public static final Companion Companion;

        public void visit(@NotNull Text text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (!(text.getParent() instanceof Link)) {
                this.linkify(text);
            }
        }

        @Override
        @NotNull
        public RegexpExtractor getExtractor() {
            return this.extractor;
        }

        @Override
        @NotNull
        public AbstractPostProcessor.ReplacementResult replacementOf(@NotNull RegexpExtractionResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            String login = result2.getExtracted();
            Entity entity2 = BeansKt.getUserFilterService().searchGreedyByLogin(login);
            XdUser referencedUser = entity2 != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity2) : null;
            Node linkNode = null;
            int last = 0;
            if (referencedUser != null) {
                linkNode = this.createUserNode(referencedUser);
                last = result2.getEnd() - (login.length() - referencedUser.getLogin().length());
            } else {
                linkNode = (Node)new Text('@' + login);
                last = result2.getEnd();
            }
            return new AbstractPostProcessor.ReplacementResult(last, linkNode);
        }

        private final Node createUserNode(XdUser user2) {
            UserLink userLink = new UserLink(user2);
            boolean bl = false;
            boolean bl2 = false;
            UserLink $this$apply = userLink;
            boolean bl3 = false;
            $this$apply.appendChild((Node)new Text('@' + user2.getFullName()));
            return (Node)userLink;
        }

        public UserLinkPostProcessor() {
            Pattern pattern2 = pattern;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"pattern");
            this.extractor = new RegexpExtractor(pattern2, 2){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected boolean isApplicableMatchPosition(int start2, int end, @NotNull String inputText) {
                    Intrinsics.checkParameterIsNotNull((Object)inputText, (String)"inputText");
                    if (start2 == 0) {
                        return true;
                    }
                    Character prevChar = this.symbolAtPosition(start2 - 1, inputText);
                    if (prevChar == null) return true;
                    char c = prevChar.charValue();
                    boolean bl = false;
                    if (Character.isLetterOrDigit(c)) return false;
                    if (prevChar.charValue() == '*') return false;
                    return true;
                }

                private final Character symbolAtPosition(int symbolPosition, String text) {
                    return symbolPosition >= text.length() ? null : Character.valueOf(text.charAt(symbolPosition));
                }
            };
        }

        static {
            Companion = new Companion(null);
            pattern = Pattern.compile("([@])(([\\p{IsAlphabetic}0-9]|[+.|\\-=@_]){2,40})");
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/markup/extensions/UserLinkExtension$UserLinkPostProcessor$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "youtrack-application"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

