/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.charisma.smartui.panel.attachment.AttachmentThumbnailImpl;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.markup.BeansKt;
import jetbrains.youtrack.markup.extensions.VideoNode;
import jetbrains.youtrack.markup.renderer.AttachmentNodeRenderer;
import jetbrains.youtrack.markup.renderer.VideoNodeRenderer;
import jetbrains.youtrack.persistent.XdBaseIssueComment;
import jetbrains.youtrack.persistent.XdDraftComment;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.security.IssueAttachmentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Image;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0014\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/markup/renderer/AttachmentNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "kotlin.jvm.PlatformType", "videoRenderer", "Ljetbrains/youtrack/markup/renderer/VideoNodeRenderer;", "getAttributesMap", "", "", "node", "Lorg/commonmark/node/Image;", "attrs", "getNodeTypes", "", "Ljava/lang/Class;", "imageAwareUrl", "attachment", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "render", "", "Lorg/commonmark/node/Node;", "tryCurrentIssueAttachments", "destination", "AltTextVisitor", "youtrack-application"})
public final class AttachmentNodeRenderer
implements NodeRenderer {
    private final HtmlWriter html;
    private final VideoNodeRenderer videoRenderer;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<Image>> getNodeTypes() {
        return SetsKt.setOf(Image.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Image image = (Image)node2;
        String string = image.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"image.destination");
        if (VideoNode.Companion.looksLikeVideo(string)) {
            String string2 = image.getDestination();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"image.destination");
            VideoNode videoNode = new VideoNode(string2, image.getTitle());
            VideoNodeRenderer videoNodeRenderer = this.videoRenderer;
            boolean bl = false;
            boolean bl2 = false;
            VideoNode videoNode2 = videoNode;
            boolean bl3 = false;
            Node node3 = image.getFirstChild();
            if (node3 != null) {
                Node node4 = node3;
                boolean bl4 = false;
                boolean bl5 = false;
                Node imageAttributes = node4;
                boolean bl6 = false;
                videoNode2.appendChild(imageAttributes);
            }
            VideoNode videoNode3 = videoNode;
            videoNodeRenderer.render((Node)videoNode3);
        } else {
            String string3 = image.getDestination();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"image.destination");
            XdIssueAttachment issueAttachment = this.tryCurrentIssueAttachments(string3);
            String url2 = this.context.encodeUrl(issueAttachment != null ? this.imageAwareUrl(issueAttachment) : image.getDestination());
            AltTextVisitor altTextVisitor = new AltTextVisitor();
            image.accept((Visitor)altTextVisitor);
            String altText = altTextVisitor.getAltText$youtrack_application();
            Map attrs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"src", (Object)url2), TuplesKt.to((Object)"alt", (Object)altText)});
            if (image.getTitle() != null) {
                attrs.put("title", image.getTitle());
            }
            if (issueAttachment != null) {
                attrs.put("data-attachment-id", issueAttachment.getXdId());
            }
            this.html.tag("img", this.getAttributesMap((Image)node2, attrs), true);
        }
    }

    private final Map<String, String> getAttributesMap(Image node2, Map<String, String> attrs) {
        Map map2 = this.context.extendAttributes((Node)node2, "img", attrs);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"context.extendAttributes(node, \"img\", attrs)");
        Map sourceMap = MapsKt.toMutableMap((Map)map2);
        String style = "";
        String height = (String)sourceMap.get("height");
        String width = (String)sourceMap.get("width");
        String string = height;
        if (string != null) {
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"%", (boolean)false, (int)2, null)) {
                style = style + "height: " + height + ';';
            }
        }
        String string2 = width;
        if (string2 != null) {
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"%", (boolean)false, (int)2, null)) {
                style = style + "width: " + width + ';';
            }
        }
        CharSequence charSequence = style;
        boolean bl = false;
        if (charSequence.length() > 0) {
            sourceMap.put("style", style);
        }
        return sourceMap;
    }

    private final XdIssueAttachment tryCurrentIssueAttachments(String destination) {
        XdIssueAttachment it;
        Object element$iv;
        Iterator iterator2;
        boolean $i$f$firstOrNull;
        Object $this$firstOrNull$iv;
        boolean bl;
        boolean bl2;
        Object object;
        if (StringsKt.startsWith$default((String)destination, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)destination, (String)"https://", (boolean)false, (int)2, null)) {
            return null;
        }
        XdIssue xdIssue = BeansKt.getMarkdownProcessingContext().getIssue();
        if (xdIssue != null) {
            XdIssueAttachment attachment2;
            Object v1;
            block6: {
                object = xdIssue;
                bl2 = false;
                bl = false;
                XdIssue issue2 = object;
                boolean bl3 = false;
                $this$firstOrNull$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)XdIssueExtKt.getAttachments(issue2)), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, XdSearchingNode>(destination){
                    final /* synthetic */ String $destination$inlined;
                    {
                        this.$destination$inlined = string;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueAttachment it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                    }
                })));
                $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (XdIssueAttachment)element$iv;
                    boolean bl4 = false;
                    if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService(), (XdEntity)it, null, null, null, null, 30, null)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            XdIssueAttachment xdIssueAttachment = attachment2 = (XdIssueAttachment)v1;
            if (xdIssueAttachment != null) {
                $this$firstOrNull$iv = xdIssueAttachment;
                $i$f$firstOrNull = false;
                boolean bl5 = false;
                Object it2 = $this$firstOrNull$iv;
                boolean bl6 = false;
                return it2;
            }
        }
        XdDraftComment xdDraftComment = (XdDraftComment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdDraftComment.Companion.all(), (Function2)tryCurrentIssueAttachments.2.INSTANCE), (Function2)tryCurrentIssueAttachments.3.INSTANCE));
        if (xdDraftComment != null) {
            Object v4;
            block7: {
                object = xdDraftComment;
                bl2 = false;
                bl = false;
                Object draft = object;
                boolean bl7 = false;
                $this$firstOrNull$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)((XdBaseIssueComment)((Object)draft)).getAttachments()), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, XdSearchingNode>(destination){
                    final /* synthetic */ String $destination$inlined;
                    {
                        this.$destination$inlined = string;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueAttachment it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                    }
                })));
                $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it = (XdIssueAttachment)element$iv;
                    boolean bl8 = false;
                    if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService(), (XdEntity)it, null, null, null, null, 30, null)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            return v4;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String imageAwareUrl(XdIssueAttachment attachment2) {
        String string;
        block5: {
            String string2;
            List list;
            block7: {
                block6: {
                    if (!attachment2.isImage()) break block5;
                    list = AttachmentThumbnailImpl.formatsToConvertToPNG;
                    string2 = attachment2.getMimeType();
                    if (string2 == null) break block6;
                    String string3 = string2;
                    List list2 = list;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                    String string6 = string5;
                    list = list2;
                    string2 = string6;
                    if (string2 != null) break block7;
                }
                string2 = "";
            }
            if (list.contains(string2)) {
                string = GapUrlUtilsKt.fileUrl(attachment2, 500, 500, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls());
                return string;
            }
        }
        string = GapUrlUtilsKt.fileUrl$default(attachment2, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
        return string;
    }

    public AttachmentNodeRenderer(@NotNull HtmlNodeRendererContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.html = this.context.getWriter();
        this.videoRenderer = new VideoNodeRenderer(this.context);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/markup/renderer/AttachmentNodeRenderer$AltTextVisitor;", "Lorg/commonmark/node/AbstractVisitor;", "()V", "altText", "", "getAltText$youtrack_application", "()Ljava/lang/String;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "visit", "", "hardLineBreak", "Lorg/commonmark/node/HardLineBreak;", "softLineBreak", "Lorg/commonmark/node/SoftLineBreak;", "text", "Lorg/commonmark/node/Text;", "youtrack-application"})
    private static final class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        @NotNull
        public final String getAltText$youtrack_application() {
            String string = this.sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        public void visit(@NotNull Text text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.sb.append(text.getLiteral());
        }

        public void visit(@NotNull SoftLineBreak softLineBreak) {
            Intrinsics.checkParameterIsNotNull((Object)softLineBreak, (String)"softLineBreak");
            this.sb.append('\n');
        }

        public void visit(@NotNull HardLineBreak hardLineBreak) {
            Intrinsics.checkParameterIsNotNull((Object)hardLineBreak, (String)"hardLineBreak");
            this.sb.append('\n');
        }
    }
}

