/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.youtrack.markup.BeansKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.commonmark.node.Block;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00170\u0016H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/markup/renderer/CodeBlockNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "codeHighlighterLimit", "", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "language", "", "Lorg/commonmark/node/Node;", "getLanguage", "(Lorg/commonmark/node/Node;)Ljava/lang/String;", "needsHighlighting", "", "getNeedsHighlighting", "(Lorg/commonmark/node/Node;)Z", "getLanguageAttributeMap", "", "node", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Block;", "getStyles", "code", "render", "", "renderCodeBlock", "Companion", "youtrack-application"})
public final class CodeBlockNodeRenderer
implements NodeRenderer {
    private final int codeHighlighterLimit = 102400;
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;
    private static final Map<String, String> LANGUAGE_ALIASES;
    public static final Companion Companion;

    @NotNull
    public Set<Class<? extends Block>> getNodeTypes() {
        return SetsKt.setOf((Object[])new Class[]{FencedCodeBlock.class, IndentedCodeBlock.class});
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        this.html.line();
        this.renderCodeBlock(node2);
        this.html.line();
    }

    private final void renderCodeBlock(Node node2) {
        String string;
        Object object = node2;
        if (object instanceof IndentedCodeBlock) {
            string = ((IndentedCodeBlock)node2).getLiteral();
        } else if (object instanceof FencedCodeBlock) {
            string = ((FencedCodeBlock)node2).getLiteral();
        } else {
            throw (Throwable)new IllegalStateException("Don't know how to handle node type: " + node2.getClass());
        }
        String code2 = string;
        if (BeansKt.getMarkdownProcessingContext().getNoCss()) {
            this.html.tag("pre");
        } else {
            if (this.getNeedsHighlighting(node2)) {
                object = this.getLanguage(node2);
                boolean bl = false;
                boolean bl2 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                    String string2 = this.getLanguage(node2);
                    if (string2 != null) {
                        object = string2;
                        bl = false;
                        bl2 = false;
                        Object language2 = object;
                        boolean bl3 = false;
                        this.html.tag("span", this.context.extendAttributes(node2, "pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)"markdown-language-tag"))));
                        String string3 = LANGUAGE_ALIASES.get(language2);
                        if (string3 == null) {
                            string3 = language2;
                        }
                        this.html.text(string3);
                        this.html.tag("/span");
                    }
                }
            }
            String string4 = code2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"code");
            this.html.tag("pre", this.context.extendAttributes(node2, "pre", MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)this.getStyles(string4, node2)))));
        }
        this.html.tag("code", this.context.extendAttributes(node2, "code", this.getLanguageAttributeMap(node2)));
        this.html.text(code2);
        this.html.tag("/code");
        this.html.tag("/pre");
        if (!BeansKt.getMarkdownProcessingContext().getNoJs() && !BeansKt.getMarkdownProcessingContext().getNoCss()) {
            this.html.tag("script");
            this.html.text("prettyPrint();");
            this.html.tag("/script");
        }
    }

    private final String getStyles(String code2, Node node2) {
        List css = CollectionsKt.mutableListOf((Object[])new String[]{"wikicode"});
        if (this.getNeedsHighlighting(node2)) {
            if (code2.length() < this.codeHighlighterLimit) {
                css.add("prettyprint");
            }
            CharSequence charSequence = this.getLanguage(node2);
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                css.add("linenums");
            }
        }
        return CollectionsKt.joinToString$default((Iterable)css, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final Map<String, String> getLanguageAttributeMap(Node node2) {
        Map map2;
        String string;
        boolean bl;
        CharSequence charSequence;
        String string2 = this.getLanguage(node2);
        if (string2 != null) {
            charSequence = string2;
            bl = false;
            String string3 = charSequence;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        String language2 = string;
        charSequence = language2;
        bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            boolean bl3 = false;
            map2 = MapsKt.emptyMap();
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("language-");
            String string5 = LANGUAGE_ALIASES.get(language2);
            if (string5 == null) {
                string5 = language2;
            }
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"class", (Object)stringBuilder.append(string5).toString()));
        }
        return map2;
    }

    private final String getLanguage(@NotNull Node $this$language) {
        Object object;
        Node node2 = $this$language;
        return node2 instanceof FencedCodeBlock ? ((object = ((FencedCodeBlock)$this$language).getInfo()) != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) != null ? (String)object.get(0) : null) : null;
    }

    private final boolean getNeedsHighlighting(@NotNull Node $this$needsHighlighting) {
        return !StringsKt.equals((String)"text", (String)this.getLanguage($this$needsHighlighting), (boolean)true);
    }

    public CodeBlockNodeRenderer(@NotNull HtmlNodeRendererContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.codeHighlighterLimit = 102400;
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }

    static {
        Companion = new Companion(null);
        LANGUAGE_ALIASES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"fsharp", (Object)"fs"), TuplesKt.to((Object)"kts", (Object)"kt"), TuplesKt.to((Object)"kotlin", (Object)"kt"), TuplesKt.to((Object)"octave", (Object)"matlab"), TuplesKt.to((Object)"latex", (Object)"tex"), TuplesKt.to((Object)"vb.net", (Object)"vb"), TuplesKt.to((Object)"vbnet", (Object)"vb"), TuplesKt.to((Object)"yml", (Object)"yaml")});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/youtrack/markup/renderer/CodeBlockNodeRenderer$Companion;", "", "()V", "LANGUAGE_ALIASES", "", "", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

