/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.markup.BeansKt;
import jetbrains.youtrack.markup.renderer.LinkNodeRenderer;
import jetbrains.youtrack.persistent.XdBaseIssueComment;
import jetbrains.youtrack.persistent.XdDraftComment;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.security.IssueAttachmentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/markup/renderer/LinkNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Link;", "render", "", "node", "Lorg/commonmark/node/Node;", "sanitizeHref", "", "href", "tryCurrentIssueAttachments", "destination", "visitChildren", "parent", "youtrack-application"})
public final class LinkNodeRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<Link>> getNodeTypes() {
        return SetsKt.setOf(Link.class);
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        Link link = (Link)node2;
        String string = link.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"link.destination");
        String string2 = this.context.encodeUrl(this.tryCurrentIssueAttachments(string));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.encodeUrl(tryCur\u2026hments(link.destination))");
        String url2 = this.sanitizeHref(string2);
        Map attrs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"href", (Object)url2)});
        if (!BeansKt.getMarkdownProcessingContext().getNoCss()) {
            attrs.put("target", "_blank");
            attrs.put("rel", "noopener noreferrer");
        }
        if (link.getTitle() != null) {
            String string3 = link.getTitle();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"link.title");
            attrs.put("title", string3);
        }
        this.context.getWriter().tag("a", this.context.extendAttributes((Node)link, "a", attrs));
        this.visitChildren((Node)link);
        this.context.getWriter().tag("/a");
    }

    private final String tryCurrentIssueAttachments(String destination) {
        block8: {
            Object v4;
            Object it;
            XdIssueAttachment attachment2;
            block7: {
                XdIssueAttachment it2;
                Object element$iv;
                Iterator iterator2;
                boolean $i$f$firstOrNull;
                Object $this$firstOrNull$iv;
                boolean bl;
                boolean bl2;
                Object object;
                if (StringsKt.startsWith$default((String)destination, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)destination, (String)"https://", (boolean)false, (int)2, null)) {
                    return destination;
                }
                XdIssue xdIssue = BeansKt.getMarkdownProcessingContext().getIssue();
                if (xdIssue != null) {
                    Object v1;
                    block6: {
                        object = xdIssue;
                        bl2 = false;
                        bl = false;
                        XdIssue issue2 = object;
                        boolean bl3 = false;
                        $this$firstOrNull$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)XdIssueExtKt.getAttachments(issue2)), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, XdSearchingNode>(destination){
                            final /* synthetic */ String $destination$inlined;
                            {
                                this.$destination$inlined = string;
                                super(2);
                            }

                            @NotNull
                            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueAttachment it) {
                                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                            }
                        })));
                        $i$f$firstOrNull = false;
                        iterator2 = $this$firstOrNull$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            it2 = (XdIssueAttachment)element$iv;
                            boolean bl4 = false;
                            if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService(), (XdEntity)it2, null, null, null, null, 30, null)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    XdIssueAttachment xdIssueAttachment = attachment2 = (XdIssueAttachment)v1;
                    if (xdIssueAttachment != null) {
                        $this$firstOrNull$iv = xdIssueAttachment;
                        $i$f$firstOrNull = false;
                        boolean bl5 = false;
                        it = $this$firstOrNull$iv;
                        boolean bl6 = false;
                        return GapUrlUtilsKt.fileUrl$default(attachment2, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
                    }
                }
                XdDraftComment xdDraftComment = (XdDraftComment)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdDraftComment.Companion.all(), (Function2)tryCurrentIssueAttachments.2.INSTANCE), (Function2)tryCurrentIssueAttachments.3.INSTANCE));
                if (xdDraftComment == null) break block8;
                object = xdDraftComment;
                bl2 = false;
                bl = false;
                Object draft = object;
                boolean bl7 = false;
                $this$firstOrNull$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)((XdBaseIssueComment)((Object)draft)).getAttachments()), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, XdSearchingNode>(destination){
                    final /* synthetic */ String $destination$inlined;
                    {
                        this.$destination$inlined = string;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueAttachment it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                    }
                })));
                $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it2 = (XdIssueAttachment)element$iv;
                    boolean bl8 = false;
                    if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService(), (XdEntity)it2, null, null, null, null, 30, null)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            XdIssueAttachment xdIssueAttachment = attachment2 = (XdIssueAttachment)v4;
            if (xdIssueAttachment != null) {
                XdIssueAttachment xdIssueAttachment2 = xdIssueAttachment;
                boolean bl = false;
                boolean bl9 = false;
                it = xdIssueAttachment2;
                boolean bl10 = false;
                return GapUrlUtilsKt.fileUrl$default(attachment2, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
            }
        }
        return destination;
    }

    private final String sanitizeHref(String href) {
        String string = href;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.startsWith$default((String)string4, (String)"javascript:", (boolean)false, (int)2, null) ? "" : href;
    }

    private final void visitChildren(Node parent2) {
        Node node2 = parent2.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNext();
            this.context.render(node2);
            node2 = next;
        }
    }

    public LinkNodeRenderer(@NotNull HtmlNodeRendererContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

