/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.youtrack.markup.renderer.SanitizingHtmlRenderer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CharIterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\r*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/markup/renderer/SanitizingHtmlRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "getNodeTypes", "", "Ljava/lang/Class;", "Lorg/commonmark/node/Node;", "render", "", "node", "prettifyTrailingText", "", "block", "", "sanitize", "sanitizeToken", "JsoupAllowedlist", "youtrack-application"})
public final class SanitizingHtmlRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<? extends Node>> getNodeTypes() {
        return SetsKt.setOf((Object[])new Class[]{HtmlInline.class, HtmlBlock.class});
    }

    public void render(@NotNull Node node2) {
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        HtmlWriter htmlWriter = this.context.getWriter();
        boolean bl = false;
        boolean bl2 = false;
        HtmlWriter $this$with = htmlWriter;
        boolean bl3 = false;
        Node node3 = node2;
        if (node3 instanceof HtmlInline) {
            String string = ((HtmlInline)node2).getLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.literal");
            $this$with.raw(this.sanitize(string, false));
        } else if (node3 instanceof HtmlBlock) {
            $this$with.line();
            String string = ((HtmlBlock)node2).getLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.literal");
            $this$with.raw(this.sanitize(string, true));
            $this$with.line();
        } else {
            throw (Throwable)new IllegalArgumentException("Don't know how to render " + node2);
        }
    }

    private final String sanitize(@NotNull String $this$sanitize, boolean block) {
        CharIterator iterator2 = StringsKt.iterator((CharSequence)$this$sanitize);
        boolean bl = false;
        List tokens = new ArrayList();
        boolean inTag = false;
        StringBuilder tokenBuilder = new StringBuilder();
        while (iterator2.hasNext()) {
            char symbol = iterator2.nextChar();
            if (symbol == '<' && !inTag) {
                inTag = true;
                String string = tokenBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenBuilder.toString()");
                tokens.add(string);
                tokenBuilder = new StringBuilder();
                tokenBuilder.append(symbol);
                continue;
            }
            if (symbol == '>' && inTag) {
                tokenBuilder.append(symbol);
                inTag = false;
                String string = tokenBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenBuilder.toString()");
                tokens.add(this.sanitizeToken(string));
                tokenBuilder = new StringBuilder();
                continue;
            }
            tokenBuilder.append(symbol);
        }
        String string = tokenBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenBuilder.toString()");
        String leftovers = string;
        tokens.add(inTag ? this.sanitizeToken(leftovers) : this.prettifyTrailingText(leftovers, block));
        return CollectionsKt.joinToString$default((Iterable)tokens, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    private final String prettifyTrailingText(@NotNull String $this$prettifyTrailingText, boolean block) {
        CharSequence charSequence = $this$prettifyTrailingText;
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)charSequence) && block ? "<p>" + $this$prettifyTrailingText + "</p>" : $this$prettifyTrailingText;
    }

    private final String sanitizeToken(@NotNull String $this$sanitizeToken) {
        String string;
        if (StringsKt.startsWith$default((String)$this$sanitizeToken, (String)"</", (boolean)false, (int)2, null)) {
            string = $this$sanitizeToken;
        } else if (StringsKt.startsWith$default((String)$this$sanitizeToken, (String)"<!--", (boolean)false, (int)2, null)) {
            string = $this$sanitizeToken;
        } else {
            Document document;
            Document document2 = document = Jsoup.parse((String)$this$sanitizeToken, (String)"", (Parser)Parser.xmlParser());
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            string = JsoupAllowedlist.INSTANCE.cleanup((Element)document2);
        }
        return string;
    }

    public SanitizingHtmlRenderer(@NotNull HtmlNodeRendererContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/markup/renderer/SanitizingHtmlRenderer$JsoupAllowedlist;", "Lorg/jsoup/safety/Whitelist;", "()V", "allowedTags", "", "", "cleanup", "source", "Lorg/jsoup/nodes/Element;", "cleanupElement", "youtrack-application"})
    public static final class JsoupAllowedlist
    extends Whitelist {
        private static final Set<String> allowedTags;
        public static final JsoupAllowedlist INSTANCE;

        @NotNull
        public final String cleanup(@NotNull Element source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Elements elements = source.children();
            Intrinsics.checkExpressionValueIsNotNull((Object)elements, (String)"source.children()");
            return CollectionsKt.joinToString$default((Iterable)((Iterable)elements), (CharSequence)"", null, null, (int)0, null, (Function1)cleanup.1.INSTANCE, (int)30, null);
        }

        private final String cleanupElement(Element source) {
            String string;
            if (this.isSafeTag(source.tagName())) {
                String sourceTag = source.tagName();
                Attributes destAttrs = new Attributes();
                Element dest = new Element(Tag.valueOf((String)sourceTag), source.baseUri(), destAttrs);
                Attributes sourceAttrs = source.attributes();
                for (Attribute sourceAttr : sourceAttrs) {
                    String string2;
                    String string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceAttr.getKey(), (String)"sourceAttr.key");
                    Element element = source;
                    String string4 = sourceTag;
                    JsoupAllowedlist jsoupAllowedlist = this;
                    boolean bl = false;
                    String string5 = string3;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    String string6 = string2;
                    String string7 = sourceAttr.getValue();
                    if (!jsoupAllowedlist.isSafeAttribute(string4, element, new Attribute(string6, string7))) continue;
                    destAttrs.put(sourceAttr);
                }
                String string8 = dest.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"dest.toString()");
                string = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string8, (String[])new String[]{"</"}, (boolean)false, (int)0, (int)6, null));
            } else {
                string = "";
            }
            return string;
        }

        private JsoupAllowedlist() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            String[] stringArray;
            void $this$toTypedArray$iv;
            JsoupAllowedlist jsoupAllowedlist;
            INSTANCE = jsoupAllowedlist = new JsoupAllowedlist();
            allowedTags = SetsKt.setOf((Object[])new String[]{"a", "b", "bar", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "details", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "kbd", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "summary", "sup", "style", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul"});
            Collection collection = allowedTags;
            JsoupAllowedlist jsoupAllowedlist2 = jsoupAllowedlist;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray = stringArray2;
            jsoupAllowedlist2.addTags(Arrays.copyOf(stringArray3, stringArray3.length));
            jsoupAllowedlist.addAttributes(":all", new String[]{"class"});
            jsoupAllowedlist.addAttributes(":all", new String[]{"style"});
            jsoupAllowedlist.addAttributes("a", new String[]{"href", "title", "name", "id"});
            jsoupAllowedlist.addAttributes("blockquote", new String[]{"cite"});
            jsoupAllowedlist.addAttributes("col", new String[]{"span", "width"});
            jsoupAllowedlist.addAttributes("colgroup", new String[]{"span", "width"});
            jsoupAllowedlist.addAttributes("font", new String[]{"color", "size", "face"});
            jsoupAllowedlist.addAttributes("img", new String[]{"align", "alt", "height", "src", "title", "width"});
            jsoupAllowedlist.addAttributes("ol", new String[]{"start", "type"});
            jsoupAllowedlist.addAttributes("q", new String[]{"cite"});
            jsoupAllowedlist.addAttributes("table", new String[]{"summary", "width", "border", "cellspacing", "cellpadding", "background"});
            jsoupAllowedlist.addAttributes("style", new String[]{"type"});
            jsoupAllowedlist.addAttributes("td", new String[]{"abbr", "axis", "colspan", "rowspan", "width"});
            jsoupAllowedlist.addAttributes("th", new String[]{"abbr", "axis", "colspan", "rowspan", "scope", "width"});
            jsoupAllowedlist.addAttributes("ul", new String[]{"type"});
            jsoupAllowedlist.addProtocols("a", "href", new String[]{"ftp", "http", "https", "mailto"});
            jsoupAllowedlist.addProtocols("blockquote", "cite", new String[]{"http", "https"});
            jsoupAllowedlist.addProtocols("cite", "cite", new String[]{"http", "https"});
            jsoupAllowedlist.addProtocols("img", "src", new String[]{"http", "https"});
            jsoupAllowedlist.addProtocols("q", "cite", new String[]{"http", "https"});
        }

        public static final /* synthetic */ String access$cleanupElement(JsoupAllowedlist $this, Element source) {
            return $this.cleanupElement(source);
        }
    }
}

