/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.markup.renderer;

import java.util.Map;
import java.util.Set;
import jetbrains.charisma.main.GapUrlUtilsKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.markup.BeansKt;
import jetbrains.youtrack.markup.extensions.VideoNode;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.security.IssueAttachmentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.commonmark.ext.image.attributes.ImageAttributes;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J$\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/markup/renderer/VideoNodeRenderer;", "Lorg/commonmark/renderer/NodeRenderer;", "context", "Lorg/commonmark/renderer/html/HtmlNodeRendererContext;", "(Lorg/commonmark/renderer/html/HtmlNodeRendererContext;)V", "html", "Lorg/commonmark/renderer/html/HtmlWriter;", "dimensions", "Lkotlin/Pair;", "", "Lorg/commonmark/node/Node;", "getDimensions", "(Lorg/commonmark/node/Node;)Lkotlin/Pair;", "getNodeTypes", "", "Ljava/lang/Class;", "Ljetbrains/youtrack/markup/extensions/VideoNode;", "render", "", "node", "renderLink", "video", "renderVideo", "width", "height", "renderYouTubeVideo", "tryCurrentIssueAttachments", "destination", "youtrack-application"})
public final class VideoNodeRenderer
implements NodeRenderer {
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;

    @NotNull
    public Set<Class<VideoNode>> getNodeTypes() {
        return SetsKt.setOf(VideoNode.class);
    }

    /*
     * WARNING - void declaration
     */
    public void render(@NotNull Node node2) {
        void width;
        Intrinsics.checkParameterIsNotNull((Object)node2, (String)"node");
        VideoNode video = (VideoNode)node2;
        Pair<String, String> pair = this.getDimensions(node2);
        String string = (String)pair.component1();
        String height = (String)pair.component2();
        if (BeansKt.getMarkdownProcessingContext().getAbsoluteUrls()) {
            this.renderLink(video);
        } else if (video.isYouTubeVideo()) {
            String string2;
            String string3 = width;
            if (string3 == null) {
                string3 = "560";
            }
            if ((string2 = height) == null) {
                string2 = "315";
            }
            this.renderYouTubeVideo(video, string3, string2);
        } else {
            this.renderVideo(video, (String)width, height);
        }
    }

    private final void renderLink(VideoNode video) {
        String string = video.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"video.destination");
        String href = this.tryCurrentIssueAttachments(string);
        this.html.tag("a", MapsKt.mapOf((Pair)TuplesKt.to((Object)"href", (Object)this.context.encodeUrl(href))));
        this.html.text(video.getTitle());
        this.html.tag("/a");
    }

    private final void renderVideo(VideoNode video, String width, String height) {
        String it;
        boolean bl;
        boolean bl2;
        String string;
        Map map2 = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"controls", (Object)"true"), TuplesKt.to((Object)"allowfullscreen", (Object)"true")});
        String string2 = "video";
        HtmlWriter htmlWriter = this.html;
        boolean bl3 = false;
        boolean bl4 = false;
        Map map3 = map2;
        boolean bl5 = false;
        String string3 = width;
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            map3.put("width", width);
        }
        String string4 = height;
        if (string4 != null) {
            string = string4;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl7 = false;
            map3.put("height", height);
        }
        Map map4 = map2;
        htmlWriter.tag(string2, map4);
        Pair[] pairArray = new Pair[2];
        String string5 = video.getDestination();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"video.destination");
        pairArray[0] = TuplesKt.to((Object)"src", (Object)this.context.encodeUrl(this.tryCurrentIssueAttachments(string5)));
        pairArray[1] = TuplesKt.to((Object)"type", (Object)video.getMime());
        this.html.tag("source", MapsKt.mapOf((Pair[])pairArray));
        this.html.tag("/video");
    }

    private final void renderYouTubeVideo(VideoNode video, String width, String height) {
        this.html.tag("iframe", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"src", (Object)this.context.encodeUrl("https://youtube.com/embed/" + video.getYouTubeVideoId())), TuplesKt.to((Object)"allowfullscreen", (Object)"true"), TuplesKt.to((Object)"frameborder", (Object)"0"), TuplesKt.to((Object)"width", (Object)width), TuplesKt.to((Object)"height", (Object)height)}));
        this.html.tag("/iframe");
    }

    private final String tryCurrentIssueAttachments(String destination) {
        block3: {
            Object v1;
            block2: {
                XdIssue xdIssue = BeansKt.getMarkdownProcessingContext().getIssue();
                if (xdIssue == null) break block3;
                XdIssue xdIssue2 = xdIssue;
                boolean bl = false;
                boolean bl2 = false;
                XdIssue issue2 = xdIssue2;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)XdIssueExtKt.getAttachments(issue2)), (Function2)((Function2)new Function2<FilteringContext, XdIssueAttachment, XdSearchingNode>(destination){
                    final /* synthetic */ String $destination$inlined;
                    {
                        this.$destination$inlined = string;
                        super(2);
                    }

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueAttachment it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$destination$inlined));
                    }
                })));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XdIssueAttachment it = (XdIssueAttachment)element$iv;
                    boolean bl4 = false;
                    if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(IssueAttachmentSecurityServiceImplKt.getIssueAttachmentSecurityService(), (XdEntity)it, null, null, null, null, 30, null)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            XdIssueAttachment xdIssueAttachment = v1;
            if (xdIssueAttachment != null) {
                XdIssueAttachment xdIssueAttachment2 = xdIssueAttachment;
                boolean bl = false;
                boolean bl5 = false;
                XdIssueAttachment it = xdIssueAttachment2;
                boolean bl6 = false;
                return GapUrlUtilsKt.fileUrl$default(it, null, null, !BeansKt.getMarkdownProcessingContext().getAbsoluteUrls(), 3, null);
            }
        }
        return destination;
    }

    private final Pair<String, String> getDimensions(@NotNull Node $this$dimensions) {
        Pair pair;
        Object object;
        Node node2 = $this$dimensions.getFirstChild();
        if (!(node2 instanceof ImageAttributes)) {
            node2 = null;
        }
        if ((object = (ImageAttributes)node2) != null && (object = object.getAttributes()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            pair = new Pair(it.get("width"), it.get("height"));
        } else {
            pair = new Pair(null, null);
        }
        return pair;
    }

    public VideoNodeRenderer(@NotNull HtmlNodeRendererContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        HtmlWriter htmlWriter = this.context.getWriter();
        Intrinsics.checkExpressionValueIsNotNull((Object)htmlWriter, (String)"context.writer");
        this.html = htmlWriter;
    }
}

