/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.persistent.DatabaseUtils;
import jetbrains.charisma.service.WatchFolderService;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.reports.DataExportWriter;
import jetbrains.youtrack.api.reports.ExportDataSource;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.misc.CustomFieldsExporter;
import jetbrains.youtrack.misc.CustomFieldsExporterKt;
import jetbrains.youtrack.misc.IssueListExportDataSource;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.XdIssueTag;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.XdQuery;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/misc/IssueListExportDataSource;", "Ljetbrains/youtrack/api/reports/ExportDataSource;", "issues", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "(Ljava/lang/Iterable;)V", "fieldsExporter", "Ljetbrains/youtrack/misc/CustomFieldsExporter;", "", "visibleTags", "Ljetbrains/exodus/entitystore/iterate/EntityIdSet;", "beforeEnd", "", "context", "Ljetbrains/youtrack/api/reports/DataExportWriter;", "beforeStart", "formatTags", "", "i", "getFileName", "hasNextDataRow", "", "writer", "writeDataRow", "writeHeader", "Companion", "youtrack-application"})
public final class IssueListExportDataSource
implements ExportDataSource {
    private final Iterator<XdIssue> issues;
    private final EntityIdSet visibleTags;
    private final CustomFieldsExporter fieldsExporter;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFileName() {
        return "issues";
    }

    public boolean hasNextDataRow(@NotNull DataExportWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        return this.issues.hasNext();
    }

    public void writeHeader(@NotNull DataExportWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Issue_Id", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Project", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Tags", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Summary", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("youtrack.role.reporter", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Created", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Updated", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("youtrack.states.resolved", new Object[0]));
        this.fieldsExporter.writeHeader(writer);
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Description", new Object[0]));
        writer.writeString(BeansKt.getLocalizer().localizedMsg("CSVExport.Votes", new Object[0]));
    }

    public void writeDataRow(@NotNull DataExportWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        XdIssue issue2 = this.issues.next();
        try {
            writer.writeString(issue2.getIdReadable());
            writer.writeString(issue2.getProject().getName());
            writer.writeString(this.formatTags(issue2));
            writer.writeString(issue2.getSummary());
            writer.writeString(issue2.getReporter().getVisibleName());
            writer.writeDate(Long.valueOf(issue2.getCreated()));
            writer.writeDate(Long.valueOf(issue2.getUpdated()));
            writer.writeDate(issue2.getResolved());
            this.fieldsExporter.writeValues(issue2, writer);
            writer.writeString(issue2.getDescription());
            writer.writeInteger(Integer.valueOf(issue2.getVotes()));
        }
        catch (Exception e) {
            Companion.getLogger().error("Issue " + issue2.getIdReadable() + " can't be exported", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String formatTags(XdIssue i) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = HelpersKt.asIterable((XdQuery)((XdQuery)XdIssueExtKt.getTags(i)));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XdIssueTag it = (XdIssueTag)((Object)element$iv$iv);
            boolean bl = false;
            if (!this.visibleTags.contains(it.getEntityId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, (Function1)formatTags.2.INSTANCE, (int)30, null);
    }

    public void beforeEnd(@NotNull DataExportWriter context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    public void beforeStart(@NotNull DataExportWriter context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    public IssueListExportDataSource(@NotNull Iterable<XdIssue> issues2) {
        Intrinsics.checkParameterIsNotNull(issues2, (String)"issues");
        this.issues = SequencesKt.take((Sequence)CollectionsKt.asSequence(issues2), (int)jetbrains.charisma.persistent.BeansKt.getXdApplicationMetaData().getMaxExportItems()).iterator();
        EntityIdSet entityIdSet = DatabaseUtils.toIdSet((Iterable)WatchFolderService.applyTagPermissions$default(jetbrains.charisma.service.BeansKt.getWatchFolderService(), XdIssueTag.Companion.all(), null, 2, null).getEntityIterable());
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIdSet, (String)"DatabaseUtils.toIdSet(wa\u2026ag.all()).entityIterable)");
        this.visibleTags = entityIdSet;
        this.fieldsExporter = CustomFieldsExporterKt.getCustomFieldsExporterFactory().createExporter(issues2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/misc/IssueListExportDataSource$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

