/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent.comment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.core.annotations.ApiJsOptional;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt$getComments$1;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt$getComments$issueComments$1;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt$getEditedComments$1$1;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt$getEditedComments$1$2;
import jetbrains.youtrack.persistent.comment.IssueCommentServiceKt$updateCommentsCount$;
import jetbrains.youtrack.persistent.security.BasicSecurityCache;
import jetbrains.youtrack.persistent.security.BasicSecurityCacheKt;
import jetbrains.youtrack.persistent.security.IssueCommentSecurityServiceImpl;
import jetbrains.youtrack.persistent.security.IssueCommentSecurityServiceImplKt;
import jetbrains.youtrack.persistent.security.SecurityCache;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\b\b\u0003\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u0002\u001a\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u0002H\u0002\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\n*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\r\u001a%\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014*\u00020\u0002H\u0007\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0002\u00a8\u0006\u0017"}, d2={"addComment", "Ljetbrains/youtrack/persistent/XdIssueComment;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "text", "", "author", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "findAccessibleComments", "Lkotlin/sequences/Sequence;", "getAccessibleComments", "Lkotlinx/dnq/query/XdQuery;", "getComments", "excludeDeleted", "", "getCommentsCount", "", "user", "cachedCanReadComments", "(Ljetbrains/youtrack/core/persistent/issue/XdIssue;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljava/lang/Boolean;)I", "getEditedComments", "", "updateCommentsCount", "", "youtrack-application"})
public final class IssueCommentServiceKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="\nAdds a comment to the issue.\nMakes `issue.comments.isChanged` return `true` for the current transaction.\n")
    @ApiDocReturns(value="A newly created comment.")
    @ApiJsAcceptsJson
    @NotNull
    public static final XdIssueComment addComment(@NotNull XdIssue $this$addComment, @ApiDoc(value="The text to add to the issue as a comment.") @NotNull String text, @ApiDoc(value="The author of the comment.") @ApiJsOptional @NotNull XdUser author) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addComment, (String)"$this$addComment");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        return XdIssueComment.Companion.new$default(XdIssueComment.Companion, text, $this$addComment, author, null, 8, null);
    }

    public static /* synthetic */ XdIssueComment addComment$default(XdIssue xdIssue, String string, XdUser xdUser, int n, Object object) {
        if ((n & 2) != 0) {
            xdUser = BeansKt.getXdLoggedInUser();
        }
        return IssueCommentServiceKt.addComment(xdIssue, string, xdUser);
    }

    /*
     * WARNING - void declaration
     */
    public static final int getCommentsCount(@NotNull XdIssue $this$getCommentsCount, @NotNull XdUser user2, @Nullable Boolean cachedCanReadComments) {
        void $this$filterTo$iv$iv;
        int c;
        Intrinsics.checkParameterIsNotNull((Object)$this$getCommentsCount, (String)"$this$getCommentsCount");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Boolean bl = cachedCanReadComments;
        if ((bl != null ? bl.booleanValue() : user2.hasPermissionInProject(Permission.READ_COMMENT, new XdProject[]{$this$getCommentsCount.getProject()})) && (c = $this$getCommentsCount.getCommentsCount()) >= 0) {
            return c;
        }
        IssueCommentSecurityServiceImpl security = IssueCommentSecurityServiceImplKt.getIssueCommentSecurityService();
        Iterable $this$filter$iv = XdQueryKt.asIterable((XdQuery)((XdQuery)XdIssueExtKt.getComments($this$getCommentsCount)));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XdIssueComment it = (XdIssueComment)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!XdEntitySecurityService.DefaultImpls.isAccessible$default(security, it, null, Operation.READ, user2, null, 18, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public static /* synthetic */ int getCommentsCount$default(XdIssue xdIssue, XdUser xdUser, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            xdUser = BeansKt.getXdLoggedInUser();
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return IssueCommentServiceKt.getCommentsCount(xdIssue, xdUser, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XdQuery<XdIssueComment> getComments(@NotNull XdIssue $this$getComments, boolean excludeDeleted) {
        void value$iv;
        KProperty1 $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getComments, (String)"$this$getComments");
        KProperty1 kProperty1 = (KProperty1)IssueCommentServiceKt$getComments$issueComments$1.INSTANCE;
        XdEntityType xdEntityType = (XdEntityType)XdIssueComment.Companion;
        NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdIssueComment.class), (XdEntity)((XdEntity)$this$getComments));
        XdQuery issueComments2 = XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase);
        if (!excludeDeleted) {
            return issueComments2;
        }
        $receiver$iv = (KProperty1)IssueCommentServiceKt$getComments$1.INSTANCE;
        Comparable $i$f$eq = Boolean.valueOf(true);
        xdEntityType = issueComments2;
        nodeBase = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdIssueComment.class)), (Comparable)value$iv);
        return XdQueryKt.query((XdQuery)xdEntityType, (NodeBase)nodeBase);
    }

    public static /* synthetic */ XdQuery getComments$default(XdIssue xdIssue, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return IssueCommentServiceKt.getComments(xdIssue, bl);
    }

    /*
     * WARNING - void declaration
     */
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="\nThe set of comments that are edited in the current transaction.\nComments that are added and removed are not considered to be edited.\nInstead, these are represented by the `issue.comments.added` and `issue.comments.removed` properties.\n")
    @NotNull
    public static final Iterable<XdIssueComment> getEditedComments(@NotNull XdIssue $this$getEditedComments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getEditedComments, (String)"$this$getEditedComments");
        Iterable $this$filter$iv = XdQueryKt.asIterable(IssueCommentServiceKt.getAccessibleComments($this$getEditedComments));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XdIssueComment it = (XdIssueComment)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!it.isNew() && (PersitenceExtensionsKt.hasChangesExcept((XdEntity)it, CollectionsKt.listOf((Object)IssueCommentServiceKt$getEditedComments$1$1.INSTANCE)) || ReflectionUtilKt.hasChanges((XdEntity)it, (KProperty1)((KProperty1)IssueCommentServiceKt$getEditedComments$1$2.INSTANCE)) && !it.getDeleted()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final XdQuery<XdIssueComment> getAccessibleComments(@NotNull XdIssue $this$getAccessibleComments) {
        XdUser user2 = BeansKt.getXdLoggedInUser();
        boolean canReadComments = user2.hasPermissionInProject(Permission.READ_COMMENT, new XdProject[]{$this$getAccessibleComments.getProject()});
        boolean canReadHiddenStuff = user2.hasPermissionInProject(Permission.READ_HIDDEN_STUFF, new XdProject[]{$this$getAccessibleComments.getProject()});
        return XdQueryKt.asQuery((Iterable)BeansKt.getPermissions().apply(user2.getEntity(), canReadComments, canReadHiddenStuff, IssueCommentServiceKt.getComments($this$getAccessibleComments, false).getEntityIterable()), (XdEntityType)((XdEntityType)XdIssueComment.Companion));
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateCommentsCount(@NotNull XdIssue $this$updateCommentsCount) {
        void containsSecured;
        Intrinsics.checkParameterIsNotNull((Object)$this$updateCommentsCount, (String)"$this$updateCommentsCount");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Iterable $this$filterLazy$iv = XdQueryKt.asIterable((XdQuery)((XdQuery)XdIssueExtKt.getComments($this$updateCommentsCount)));
        boolean $i$f$filterLazy = false;
        int result2 = CollectionUtilKt.getSize(new Iterable<XdIssueComment>($this$filterLazy$iv, (Ref.BooleanRef)containsSecured){
            final /* synthetic */ Iterable $this_filterLazy;
            final /* synthetic */ Ref.BooleanRef $containsSecured$inlined;
            {
                this.$this_filterLazy = $receiver;
                this.$containsSecured$inlined = booleanRef;
            }

            @NotNull
            public Iterator<XdIssueComment> iterator() {
                return new Iterator<XdIssueComment>(this){
                    private final Iterator<XdIssueComment> itr;
                    private XdIssueComment nextElement;
                    final /* synthetic */ updateCommentsCount$$inlined$filterLazy$1 this$0;
                    {
                        this.this$0 = $outer;
                        this.itr = this.this$0.$this_filterLazy.iterator();
                        this.nextElement = this.advance();
                    }

                    public XdIssueComment next() {
                        XdIssueComment xdIssueComment = this.nextElement;
                        if (xdIssueComment == null) {
                            throw (Throwable)new NoSuchElementException();
                        }
                        XdIssueComment xdIssueComment2 = xdIssueComment;
                        boolean bl = false;
                        boolean bl2 = false;
                        XdIssueComment it = xdIssueComment2;
                        boolean bl3 = false;
                        this.nextElement = this.advance();
                        return xdIssueComment2;
                    }

                    public boolean hasNext() {
                        return this.nextElement != null;
                    }

                    private final XdIssueComment advance() {
                        while (this.itr.hasNext()) {
                            XdIssueComment next;
                            XdIssueComment it = next = this.itr.next();
                            boolean bl = false;
                            if (it.isSecured()) {
                                this.this$0.$containsSecured$inlined.element = true;
                            }
                            if (!(!it.getDeleted())) continue;
                            return next;
                        }
                        return null;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        });
        $this$updateCommentsCount.setCommentsCount(containsSecured.element ? -1 : result2);
        $this$updateCommentsCount.setLiveCommentsCount(result2);
    }

    @NotNull
    public static final Sequence<XdIssueComment> findAccessibleComments(@NotNull XdIssue $this$findAccessibleComments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$findAccessibleComments, (String)"$this$findAccessibleComments");
        XdUser xdUser = BeansKt.getXdLoggedInUser();
        boolean bl = false;
        boolean bl2 = false;
        XdUser currentUser = xdUser;
        boolean bl3 = false;
        BasicSecurityCache securityCache = BasicSecurityCacheKt.getBasicSecurityCache();
        return !currentUser.isSystem() && !IssueCommentSecurityServiceImplKt.canReadComments(currentUser, $this$findAccessibleComments.getProject(), securityCache) ? SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)XdIssueExtKt.getComments($this$findAccessibleComments))), (Function1)((Function1)new Function1<XdIssueComment, Boolean>(currentUser){
            final /* synthetic */ XdUser $currentUser;

            public final boolean invoke(@NotNull XdIssueComment it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return Intrinsics.areEqual((Object)it.getAuthor(), (Object)this.$currentUser);
            }
            {
                this.$currentUser = xdUser;
                super(1);
            }
        })) : XdQueryKt.asSequence(IssueCommentSecurityServiceImplKt.getIssueCommentSecurityService().filterAccessible((XdQuery<XdIssueComment>)((XdQuery)XdIssueExtKt.getComments($this$findAccessibleComments)), $this$findAccessibleComments.getProject(), Operation.READ, currentUser, (SecurityCache)securityCache));
    }
}

