/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent.security;

import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.SecurityCompatible;
import jetbrains.youtrack.persistent.XdBaseAttachment;
import jetbrains.youtrack.persistent.security.AttachmentSecurityService;
import jetbrains.youtrack.persistent.security.SecurityCache;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J>\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J7\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/persistent/security/AttachmentSecurityService;", "T", "Ljetbrains/youtrack/persistent/XdBaseAttachment;", "Ljetbrains/youtrack/persistent/security/XdEntitySecurityService;", "()V", "containerReadPermission", "Ljetbrains/youtrack/core/security/Permission;", "getContainerReadPermission", "()Ljetbrains/youtrack/core/security/Permission;", "filterAccessible", "Lkotlinx/dnq/query/XdQuery;", "xdEntities", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "securityCache", "Ljetbrains/youtrack/persistent/security/SecurityCache;", "hasHiddenStuffReadAccess", "", "isAccessible", "xdEntity", "(Ljetbrains/youtrack/persistent/XdBaseAttachment;Ljetbrains/youtrack/core/persistent/issue/XdProject;Ljetbrains/youtrack/core/security/Operation;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljetbrains/youtrack/persistent/security/SecurityCache;)Z", "isProhibitedByCommentReadAccess", "(Ljetbrains/youtrack/persistent/XdBaseAttachment;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljetbrains/youtrack/persistent/security/SecurityCache;)Z", "isProhibitedByContainerReadAccess", "isProhibitedInDeletedContainer", "(Ljetbrains/youtrack/persistent/XdBaseAttachment;Ljetbrains/youtrack/core/security/Operation;)Z", "isUpdateAllowed", "youtrack-application"})
public abstract class AttachmentSecurityService<T extends XdBaseAttachment>
implements XdEntitySecurityService<T> {
    @NotNull
    public abstract Permission getContainerReadPermission();

    public abstract boolean isProhibitedInDeletedContainer(@NotNull T var1, @NotNull Operation var2);

    public abstract boolean isProhibitedByCommentReadAccess(@NotNull T var1, @NotNull XdUser var2, @NotNull SecurityCache var3);

    public abstract boolean isProhibitedByContainerReadAccess(@NotNull T var1, @NotNull XdUser var2, @NotNull SecurityCache var3);

    @Override
    public boolean isAccessible(@NotNull T xdEntity, @Nullable XdProject project2, @NotNull Operation operation, @NotNull XdUser user2, @NotNull SecurityCache securityCache) {
        XdProject attachmentProject;
        Intrinsics.checkParameterIsNotNull(xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        if (user2.getBanned()) {
            return false;
        }
        if (user2.isSystem() || user2.isService()) {
            return true;
        }
        if (this.isProhibitedInDeletedContainer(xdEntity, operation)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)user2, (Object)xdEntity.getPermittedOwner())) {
            return true;
        }
        if (this.isProhibitedByCommentReadAccess(xdEntity, user2, securityCache)) {
            return false;
        }
        if (this.isProhibitedByContainerReadAccess(xdEntity, user2, securityCache)) {
            return false;
        }
        XdProject xdProject = project2;
        if (xdProject == null) {
            xdProject = attachmentProject = this.getProjectSafe((XdEntity)xdEntity);
        }
        if (!this.isSecuredReadAccessible((SecurityCompatible)xdEntity, user2, attachmentProject, securityCache)) {
            return false;
        }
        return operation == Operation.READ || this.isUpdateAllowed(securityCache, operation, attachmentProject, user2);
    }

    public abstract boolean isUpdateAllowed(@NotNull SecurityCache var1, @NotNull Operation var2, @Nullable XdProject var3, @NotNull XdUser var4);

    @Override
    public boolean hasHiddenStuffReadAccess(@NotNull XdUser user2, @NotNull XdProject project2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return securityCache.hasPermissionInProject(Permission.READ_HIDDEN_STUFF, project2, user2) && securityCache.hasPermissionInProject(this.getContainerReadPermission(), project2, user2);
    }

    @Override
    @NotNull
    public XdQuery<T> filterAccessible(@NotNull XdQuery<? extends T> xdEntities, @Nullable XdProject project2, @NotNull Operation operation, @NotNull XdUser user2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull(xdEntities, (String)"xdEntities");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return user2.getBanned() ? XdQueryKt.emptyQuery(this.getXdEntityType()) : (user2.isSystem() ? xdEntities : XdQueryKt.asQuery((Iterable)SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(xdEntities), (Function1)new Function1<T, Boolean>(this, project2, operation, user2, securityCache){
            final /* synthetic */ AttachmentSecurityService this$0;
            final /* synthetic */ XdProject $project;
            final /* synthetic */ Operation $operation;
            final /* synthetic */ XdUser $user;
            final /* synthetic */ SecurityCache $securityCache;

            public final boolean invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.isAccessible(it, this.$project, this.$operation, this.$user, this.$securityCache);
            }
            {
                this.this$0 = attachmentSecurityService;
                this.$project = xdProject;
                this.$operation = operation;
                this.$user = xdUser;
                this.$securityCache = securityCache;
                super(1);
            }
        }), (Function1)filterAccessible.2.INSTANCE)), this.getXdEntityType()));
    }

    @Override
    public boolean isSecuredReadAccessible(@NotNull SecurityCompatible xdEntity, @NotNull XdUser user2, @Nullable XdProject project2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return XdEntitySecurityService.DefaultImpls.isSecuredReadAccessible(this, xdEntity, user2, project2, securityCache);
    }

    @Override
    @Nullable
    public Permission getCreatePermission() {
        return XdEntitySecurityService.DefaultImpls.getCreatePermission(this);
    }
}

