/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent.security;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.security.SecurityCache;
import jetbrains.youtrack.persistent.security.SecurityServiceKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/persistent/security/BasicSecurityCache;", "Ljetbrains/youtrack/persistent/security/SecurityCache;", "()V", "hasPermission", "", "entityType", "", "operation", "Ljetbrains/youtrack/core/security/Operation;", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "hasPermissionInProject", "permission", "Ljetbrains/youtrack/core/security/Permission;", "isAccessible", "xdEntity", "Lkotlinx/dnq/XdEntity;", "isUserInGroups", "groups", "", "Ljetbrains/exodus/entitystore/Entity;", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "youtrack-application"})
public final class BasicSecurityCache
implements SecurityCache {
    @Override
    public boolean hasPermissionInProject(@NotNull Permission permission, @NotNull XdProject project2, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return BeansKt.getSecurity().hasPermission(user2.getEntity(), permission, project2.getEntity());
    }

    @Override
    public boolean hasPermission(@NotNull String entityType2, @NotNull Operation operation, @NotNull XdProject project2, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)entityType2, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return user2.hasPermission(entityType2, operation, project2);
    }

    @Override
    public boolean isUserInGroups(@NotNull XdQuery<XdUserGroup> groups, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.intersect(groups, (XdQuery)((XdQuery)user2.getGroups())));
    }

    @Override
    public boolean isUserInGroups(@NotNull Iterable<? extends Entity> groups, @NotNull XdUser user2) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            Set userGroups2 = CollectionsKt.toSet((Iterable)user2.getGroups().getEntityIterable());
            Iterable<? extends Entity> $this$any$iv = groups;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends Entity> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Entity element$iv;
                    Entity group = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!userGroups2.contains(group)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isAccessible(@NotNull XdEntity xdEntity, @NotNull Operation operation, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return SecurityServiceKt.getSecurityService().isAccessible(xdEntity, null, operation, user2, this);
    }
}

