/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.persistent.security;

import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.SecurityCompatible;
import jetbrains.youtrack.persistent.XdComment;
import jetbrains.youtrack.persistent.security.CommentSecurityService;
import jetbrains.youtrack.persistent.security.SecurityCache;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J7\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00028\u00002\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H$\u00a8\u0006\u0019"}, d2={"Ljetbrains/youtrack/persistent/security/CommentSecurityService;", "C", "Ljetbrains/youtrack/persistent/XdComment;", "Ljetbrains/youtrack/persistent/security/XdEntitySecurityService;", "()V", "filterAccessible", "Lkotlinx/dnq/query/XdQuery;", "xdEntities", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "securityCache", "Ljetbrains/youtrack/persistent/security/SecurityCache;", "hasHiddenStuffReadAccess", "", "isAccessible", "xdEntity", "(Ljetbrains/youtrack/persistent/XdComment;Ljetbrains/youtrack/core/persistent/issue/XdProject;Ljetbrains/youtrack/core/security/Operation;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljetbrains/youtrack/persistent/security/SecurityCache;)Z", "normalizeOperation", "own", "Lkotlin/Lazy;", "Companion", "youtrack-application"})
public abstract class CommentSecurityService<C extends XdComment>
implements XdEntitySecurityService<C> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public XdQuery<C> filterAccessible(@NotNull XdQuery<? extends C> xdEntities, @Nullable XdProject project2, @NotNull Operation operation, @NotNull XdUser user2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull(xdEntities, (String)"xdEntities");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return user2.getBanned() ? XdQueryKt.emptyQuery(this.getXdEntityType()) : (user2.isSystem() ? xdEntities : XdQueryKt.asQuery((Iterable)SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(xdEntities), (Function1)new Function1<C, Boolean>(this, project2, operation, user2, securityCache){
            final /* synthetic */ CommentSecurityService this$0;
            final /* synthetic */ XdProject $project;
            final /* synthetic */ Operation $operation;
            final /* synthetic */ XdUser $user;
            final /* synthetic */ SecurityCache $securityCache;

            public final boolean invoke(@NotNull C it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.isAccessible(it, this.$project, this.$operation, this.$user, this.$securityCache);
            }
            {
                this.this$0 = commentSecurityService;
                this.$project = xdProject;
                this.$operation = operation;
                this.$user = xdUser;
                this.$securityCache = securityCache;
                super(1);
            }
        }), (Function1)filterAccessible.2.INSTANCE)), this.getXdEntityType()));
    }

    @Override
    public boolean isAccessible(@NotNull C xdEntity, @Nullable XdProject project2, @NotNull Operation operation, @NotNull XdUser user2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull(xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        if (user2.isRemoved()) {
            return false;
        }
        if (user2.isSystem() || user2.isService()) {
            return true;
        }
        XdProject xdProject = project2;
        if (xdProject == null) {
            XdProject xdProject2;
            try {
                xdProject2 = this.getProjectSafe((XdEntity)xdEntity);
            }
            catch (EntityRemovedInDatabaseException e) {
                return false;
            }
            xdProject = xdProject2;
        }
        XdProject commentProject = xdProject;
        Lazy own2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(xdEntity, user2){
            final /* synthetic */ XdComment $xdEntity;
            final /* synthetic */ XdUser $user;

            public final boolean invoke() {
                return Intrinsics.areEqual((Object)this.$xdEntity.getPermittedOwner(), (Object)this.$user);
            }
            {
                this.$xdEntity = xdComment;
                this.$user = xdUser;
                super(0);
            }
        }));
        Operation refinedOperation = this.normalizeOperation(operation, (Lazy<Boolean>)own2);
        return operation == Operation.READ && !this.isSecuredReadAccessible((SecurityCompatible)xdEntity, user2, commentProject, securityCache) ? (Boolean)own2.getValue() : (commentProject != null ? securityCache.hasPermission(this.getXdEntityType().getEntityType(), refinedOperation, commentProject, user2) || operation == Operation.READ && ((Boolean)own2.getValue()).booleanValue() : (Boolean)own2.getValue());
    }

    @NotNull
    protected abstract Operation normalizeOperation(@NotNull Operation var1, @NotNull Lazy<Boolean> var2);

    @Override
    public boolean hasHiddenStuffReadAccess(@NotNull XdUser user2, @NotNull XdProject project2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return securityCache.hasPermissionInProject(Permission.READ_HIDDEN_STUFF, project2, user2) && securityCache.hasPermissionInProject(Permission.READ_COMMENT, project2, user2);
    }

    @Override
    public boolean isSecuredReadAccessible(@NotNull SecurityCompatible xdEntity, @NotNull XdUser user2, @Nullable XdProject project2, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return XdEntitySecurityService.DefaultImpls.isSecuredReadAccessible(this, xdEntity, user2, project2, securityCache);
    }

    @Override
    @Nullable
    public Permission getCreatePermission() {
        return XdEntitySecurityService.DefaultImpls.getCreatePermission(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/persistent/security/CommentSecurityService$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

