/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.refactoring;

import java.util.ArrayList;
import java.util.List;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.XdSearchRequest;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.refactoring.RefactoringCleanUpSearchRequests;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.refactoring.XdRefactoringKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.RequiredPropertyUndefinedException;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/refactoring/RefactoringCleanUpSearchRequests;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "apply", "", "requireTnx", "", "Companion", "youtrack-application"})
public final class RefactoringCleanUpSearchRequests
extends XdRefactoring {
    @NotNull
    public static final String HEADER = "Clean up of search requests";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean requireTnx() {
        return false;
    }

    @Override
    public void apply() {
        List abandonedRequests = new ArrayList();
        List lostRequests = new ArrayList();
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(lostRequests, abandonedRequests){
            final /* synthetic */ List $lostRequests;
            final /* synthetic */ List $abandonedRequests;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdRefactoringKt.processInBatches(XdSearchRequest.Companion.all(), "Clean up of search requests: Revised %d search requests", 1000, (Function1)new Function1<XdSearchRequest, Unit>(this){
                    final /* synthetic */ apply.1 this$0;

                    public final void invoke(@NotNull XdSearchRequest it) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        try {
                            XdUser owner2 = it.getOwner();
                            XdSearchRequest ownerActualRequest = XdUserExtKt.getSearchRequest(owner2);
                            if (ownerActualRequest == null) {
                                this.this$0.$lostRequests.add(it);
                            } else if (Intrinsics.areEqual((Object)((Object)ownerActualRequest), (Object)((Object)it)) ^ true) {
                                this.this$0.$abandonedRequests.add(it);
                            }
                        }
                        catch (RequiredPropertyUndefinedException e) {
                            this.this$0.$abandonedRequests.add(it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$lostRequests = list;
                this.$abandonedRequests = list2;
                super(1);
            }
        }));
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(lostRequests){
            final /* synthetic */ List $lostRequests;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable $this$forEach$iv = this.$lostRequests;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    XdSearchRequest it2 = (XdSearchRequest)((Object)element$iv);
                    boolean bl = false;
                    XdUserExtKt.setSearchRequest(it2.getOwner(), it2);
                }
            }
            {
                this.$lostRequests = list;
                super(1);
            }
        }));
        Companion.getLogger().info("Clean up of search requests: Corrected " + lostRequests.size() + " lost search requests: owner doesn't refer to any search request");
        Iterable $this$forEach$iv = abandonedRequests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdSearchRequest it = (XdSearchRequest)((Object)element$iv);
            boolean bl = false;
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(it){
                final /* synthetic */ XdSearchRequest $it;

                public final void invoke(@NotNull TransientStoreSession txn) {
                    Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                    this.$it.delete();
                }
                {
                    this.$it = xdSearchRequest;
                    super(1);
                }
            }));
        }
        Companion.getLogger().info("Clean up of search requests: Removed " + abandonedRequests.size() + " abandoned search requests: owner refers ot the different search request");
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
            final /* synthetic */ RefactoringCleanUpSearchRequests this$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.markApplied();
            }
            {
                this.this$0 = refactoringCleanUpSearchRequests;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/refactoring/RefactoringCleanUpSearchRequests$Companion;", "Lmu/KLogging;", "()V", "HEADER", "", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

