/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.refactoring.RefactoringUtil;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.youtrack.api.application.ApplicationState;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.BeansKt;
import jetbrains.youtrack.persistent.XdRefactoringDescriptor;
import jetbrains.youtrack.refactoring.AbstractRefactoringList;
import jetbrains.youtrack.refactoring.RefactoringContainer;
import jetbrains.youtrack.refactoring.XdRefactoringKt$sam$jetbrains_mps_baseLanguage_closures_runtime__FunctionTypes__return_P1_E0$0;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0014J.\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/refactoring/XdRefactoring;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "apply", "", "doUnit", "message", "unit", "Lkotlin/Function1;", "", "total", "isRefactoringApplied", "", "markApplied", "requireTnx", "shouldApply", "Companion", "youtrack-application"})
public class XdRefactoring {
    @NotNull
    private final String name;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean requireTnx() {
        return true;
    }

    public boolean shouldApply() {
        return !ConfigurationUtil.isTestMode() && !this.isRefactoringApplied(this.getName());
    }

    public void apply() {
    }

    protected void doUnit(@Nullable String message, @NotNull Function1<? super Integer, Integer> unit) {
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        Function1<? super Integer, Integer> function1 = unit;
        RefactoringUtil.doUnit((String)message, (_FunctionTypes._return_P1_E0)new XdRefactoringKt$sam$jetbrains_mps_baseLanguage_closures_runtime__FunctionTypes__return_P1_E0$0(function1), (String)this.getName());
    }

    protected void doUnit(@Nullable String message, int total, @NotNull Function1<? super Integer, Integer> unit) {
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        Function1<? super Integer, Integer> function1 = unit;
        RefactoringUtil.doUnit((String)message, (int)total, (_FunctionTypes._return_P1_E0)new XdRefactoringKt$sam$jetbrains_mps_baseLanguage_closures_runtime__FunctionTypes__return_P1_E0$0(function1), (String)this.getName());
    }

    public final void markApplied() {
        if (!this.isRefactoringApplied(this.getName())) {
            XdRefactoringDescriptor.Companion.new((Function1)new Function1<XdRefactoringDescriptor, Unit>(this){
                final /* synthetic */ XdRefactoring this$0;

                public final void invoke(@NotNull XdRefactoringDescriptor $this$new) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)$this$new), (String)"$receiver");
                    $this$new.setUid(this.this$0.getName());
                }
                {
                    this.this$0 = xdRefactoring;
                    super(1);
                }
            });
        }
    }

    public final boolean isRefactoringApplied(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return XdQueryKt.isNotEmpty((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdRefactoringDescriptor.Companion), (Function2)((Function2)new Function2<FilteringContext, XdRefactoringDescriptor, XdSearchingNode>(name2){
            final /* synthetic */ String $name;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdRefactoringDescriptor it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getUid()), (Comparable)((Object)this.$name));
            }
            {
                this.$name = string;
                super(2);
            }
        })));
    }

    public XdRefactoring() {
        String string = this.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this::class.java.name");
        this.name = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/refactoring/XdRefactoring$Companion;", "Lmu/KLogging;", "()V", "applyAll", "", "container", "Ljetbrains/youtrack/refactoring/RefactoringContainer;", "applyRefactoring", "refactoring", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "setCachingDisabled", "disabled", "", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void applyAll(@NotNull RefactoringContainer container) {
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            long start2 = System.currentTimeMillis();
            this.getLogger().info("Starting " + container.getName() + "...");
            PersistentEntityStoreImpl store = BeansKt.getPersistentEntityStore();
            Environment environment = store.getEnvironment();
            Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"store.environment");
            Environment env = environment;
            env.suspendGC();
            try {
                PersistentEntityStoreConfig persistentEntityStoreConfig = store.getConfig();
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreConfig, (String)"store.config");
                boolean cachingWasDisabled = persistentEntityStoreConfig.isCachingDisabled();
                this.setCachingDisabled(true);
                try {
                    jetbrains.youtrack.api.application.BeansKt.getRuleEngine().addIgnoreThread();
                    try {
                        Object it;
                        ArrayList allRefactorings = new ArrayList();
                        Iterable $this$forEach$iv = container.getRefactoringLists();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (AbstractRefactoringList)element$iv;
                            boolean bl = false;
                            allRefactorings.addAll(((AbstractRefactoringList)it).getRefactorings());
                        }
                        $this$forEach$iv = allRefactorings;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (XdRefactoring)element$iv;
                            boolean bl = false;
                            Companion.applyRefactoring((XdRefactoring)it);
                        }
                    }
                    finally {
                        jetbrains.youtrack.api.application.BeansKt.getRuleEngine().removeIgnoreThread();
                    }
                }
                finally {
                    this.setCachingDisabled(cachingWasDisabled);
                }
            }
            finally {
                env.resumeGC();
            }
            int seconds = MathKt.roundToInt((float)((float)(System.currentTimeMillis() - start2) / (float)1000));
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Completed %s in %d min %d sec";
            Object[] objectArray = new Object[]{container.getName(), seconds / 60, seconds % 60};
            KLogger kLogger = this.getLogger();
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            kLogger.info(string3);
        }

        private final void applyRefactoring(XdRefactoring refactoring) {
            boolean shouldApply2 = (Boolean)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Boolean>(refactoring){
                final /* synthetic */ XdRefactoring $refactoring;

                public final boolean invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$refactoring.shouldApply();
                }
                {
                    this.$refactoring = xdRefactoring;
                    super(1);
                }
            }));
            if (shouldApply2) {
                this.getLogger().info("Apply refactoring: " + refactoring.getName());
                if (refactoring.requireTnx()) {
                    LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(refactoring){
                        final /* synthetic */ XdRefactoring $refactoring;

                        public final void invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            this.$refactoring.apply();
                        }
                        {
                            this.$refactoring = xdRefactoring;
                            super(1);
                        }
                    }));
                } else {
                    refactoring.apply();
                }
            }
        }

        private final void setCachingDisabled(boolean disabled) {
            if (jetbrains.youtrack.config.BeansKt.getApplicationStateHolder().get() == ApplicationState.REFACTORINGS_STARTED) {
                PersistentEntityStoreConfig persistentEntityStoreConfig = BeansKt.getPersistentEntityStore().getConfig();
                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreConfig, (String)"persistentEntityStore.config");
                PersistentEntityStoreConfig config = persistentEntityStoreConfig;
                if (disabled != config.isCachingDisabled()) {
                    config.setCachingDisabled(disabled);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

