/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.event.Event;
import jetbrains.jetpass.dao.api.Listener;
import jetbrains.jetpass.dao.api.ServiceDAO;
import jetbrains.youtrack.api.application.AppLifecycleListenerAdapter;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@LocalScoped
@Component(value="hubServiceAllowedOriginsProvider")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/rest/HubServiceAllowedOriginsProvider;", "Ljetbrains/youtrack/api/application/AppLifecycleListenerAdapter;", "()V", "serviceListener", "Ljetbrains/jetpass/dao/api/Listener;", "Ljetbrains/jetpass/api/Service;", "<set-?>", "", "", "trustedHubServiceOrigins", "getTrustedHubServiceOrigins", "()Ljava/util/Set;", "calculateHubServiceOrigins", "", "getOrigin", "homeUrl", "start", "stop", "Companion", "youtrack-application"})
public final class HubServiceAllowedOriginsProvider
extends AppLifecycleListenerAdapter {
    @NotNull
    private volatile Set<String> trustedHubServiceOrigins = new HashSet();
    private final Listener<Service> serviceListener = (Listener)new Listener<Service>(this){
        final /* synthetic */ HubServiceAllowedOriginsProvider this$0;

        public void added(@NotNull Event event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            HubServiceAllowedOriginsProvider.access$calculateHubServiceOrigins(this.this$0);
        }

        public void removed(@NotNull Event event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            HubServiceAllowedOriginsProvider.access$calculateHubServiceOrigins(this.this$0);
        }

        public void updated(@NotNull Event event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            HubServiceAllowedOriginsProvider.access$calculateHubServiceOrigins(this.this$0);
        }
        {
            this.this$0 = $outer;
        }
    };
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<String> getTrustedHubServiceOrigins() {
        return this.trustedHubServiceOrigins;
    }

    public void start() {
        try {
            this.calculateHubServiceOrigins();
            if (BeansKt.getRingConfig().isEnabled() && !BeansKt.getRingConfig().hasEmbeddedHub()) {
                jetbrains.charisma.persistent.security.BeansKt.getRingApi().getServiceDAO().addListener(this.serviceListener);
            }
        }
        catch (Exception e) {
            Companion.getLogger().warn("", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        if (BeansKt.getRingConfig().isEnabled() && !BeansKt.getRingConfig().hasEmbeddedHub()) {
            jetbrains.charisma.persistent.security.BeansKt.getRingApi().getServiceDAO().removeListener(this.serviceListener);
        }
    }

    private final synchronized void calculateHubServiceOrigins() {
        HashSet<String> serviceOrigins = new HashSet<String>();
        try {
            if (BeansKt.getRingConfig().isEnabled() && !BeansKt.getRingConfig().hasEmbeddedHub()) {
                ServiceDAO serviceDAO = jetbrains.charisma.persistent.security.BeansKt.getRingApi().getServiceDAO();
                Intrinsics.checkExpressionValueIsNotNull((Object)serviceDAO, (String)"ringApi.serviceDAO");
                Iterator iterator2 = serviceDAO.getAllItems().iterator();
                while (iterator2.hasNext()) {
                    Service service;
                    Service service2 = service = (Service)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)service2, (String)"service");
                    Boolean bl = service2.isTrusted();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"service.isTrusted");
                    if (!bl.booleanValue()) continue;
                    if (service.getHomeUrl() != null) {
                        String string = service.getHomeUrl();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.homeUrl");
                        serviceOrigins.add(this.getOrigin(string));
                    }
                    for (String redirectUri : service.getRedirectUris()) {
                        if (redirectUri == null || !StringsKt.startsWith$default((String)redirectUri, (String)"http", (boolean)false, (int)2, null)) continue;
                        serviceOrigins.add(this.getOrigin(redirectUri));
                    }
                }
            }
            this.trustedHubServiceOrigins = serviceOrigins;
        }
        catch (Exception e) {
            Companion.getLogger().warn("Can't calculate allowed origins from Hub service data", (Throwable)e);
        }
    }

    private final String getOrigin(String homeUrl) {
        String string;
        try {
            String string2 = new URL(homeUrl).getAuthority();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URL(homeUrl).authority");
            string = string2;
        }
        catch (MalformedURLException ex) {
            string = homeUrl;
        }
        return string;
    }

    public static final /* synthetic */ void access$calculateHubServiceOrigins(HubServiceAllowedOriginsProvider $this) {
        $this.calculateHubServiceOrigins();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/rest/HubServiceAllowedOriginsProvider$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

