/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest;

import eu.medsea.mimeutil.MimeUtil2;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import jetbrains.charisma.persistence.attachments.BeansKt;
import jetbrains.charisma.persistence.attachments.ImageIOExtKt;
import jetbrains.charisma.persistent.Attachment;
import jetbrains.charisma.smartui.panel.attachment.AttachmentThumbnailImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.gaprest.RestInternal;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.persistent.XdAttachmentThumbnail;
import jetbrains.youtrack.persistent.XdBaseAttachment;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.rest.CacheControlKt;
import jetbrains.youtrack.rest.RestParametersExtractor;
import jetbrains.youtrack.security.EntitySigningService;
import jetbrains.youtrack.security.MalformedSignatureException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import mu.KLogging;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@RestInternal
@AuthIgnored
@Path(value="/files")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002#$B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010 \u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\"\u001a\u00020\f*\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/rest/PersistentFilesResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/charisma/persistent/Attachment;", "Ljetbrains/youtrack/rest/RestParametersExtractor;", "entitySigningService", "Ljetbrains/youtrack/security/EntitySigningService;", "(Ljetbrains/youtrack/security/EntitySigningService;)V", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "getFile", "", "id", "", "sign", "forceDownload", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)V", "getFileStream", "Ljetbrains/youtrack/rest/PersistentFilesResource$IndexedInputStream;", "persistentFile", "Ljetbrains/youtrack/core/persistent/XdPersistentFile;", "fileMeta", "Ljetbrains/teamsys/dnq/runtime/files/FileMeta;", "getURIEncodedFileName", "Ljava/net/URI;", "fileName", "isContentDispositionAttachment", "mimeType", "processFile", "file", "redirectToErrorPage", "writeFileResponse", "setContentDispositionHeader", "Companion", "IndexedInputStream", "youtrack-application"})
public class PersistentFilesResource
implements Resource<Attachment>,
RestParametersExtractor {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    private final EntitySigningService entitySigningService;
    @NotNull
    private static final Set<String> UNSAFE_MIMES;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @AuthIgnored
    @Path(value="/{id}")
    public final void getFile(@PathParam(value="id") @NotNull String id, @QueryParam(value="sign") @Nullable String sign, @QueryParam(value="forceDownload") @Nullable Boolean forceDownload) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        try {
            if (Intrinsics.areEqual((Object)sign, (Object)"unsigned")) {
                this.redirectToErrorPage();
                return;
            }
            XdPersistentFile xdPersistentFile = (XdPersistentFile)PersitenceExtensionsKt.tryFindById((XdEntityType)XdPersistentFile.Companion, id);
            if (xdPersistentFile == null) {
                throw (Throwable)new NotFoundException("File with id " + id + " not found");
            }
            XdPersistentFile file = xdPersistentFile;
            if (sign == null) {
                throw (Throwable)new BadRequestException("No sign provided");
            }
            EntitySigningService.EntitySignInfo info = EntitySigningService.parseSign$default(this.entitySigningService, sign, (XdEntityType)XdPersistentFile.Companion, false, 4, null);
            if (Intrinsics.areEqual((Object)((XdPersistentFile)info.getEntity()), (Object)file) ^ true) {
                throw (Throwable)new NotFoundException("File with id " + id + " not found");
            }
            if (info.getEntity() instanceof XdIssueAttachment && ((XdIssueAttachment)info.getEntity()).getRemoved()) {
                throw (Throwable)new NotFoundException("File with id " + id + " not found");
            }
            if (info.getUser().getBanned()) {
                throw (Throwable)new NotFoundException("File with id " + id + " not found");
            }
            XdUser user$iv = info.getUser();
            boolean $i$f$runAs = false;
            Entity user$iv$iv = user$iv.getEntity();
            boolean $i$f$runAs2 = false;
            PrincipalManager _principalManager$iv$iv = jetbrains.youtrack.core.security.BeansKt.getPrincipalManager();
            try {
                _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
                boolean bl = false;
                Boolean bl2 = forceDownload;
                this.processFile(file, id, bl2 != null ? bl2 : false);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                _principalManager$iv$iv.unsetTemporaryServerPrincipal();
            }
        }
        catch (MalformedSignatureException e) {
            Companion.getLogger().warn("Malformed persistent file signature detected: " + e.getMessage());
            Companion.getLogger().debug("", (Throwable)e);
            this.redirectToErrorPage();
        }
    }

    private final void redirectToErrorPage() {
        HttpServletResponse httpServletResponse = this.response;
        if (httpServletResponse == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"response");
        }
        httpServletResponse.setStatus(301);
        HttpServletResponse httpServletResponse2 = this.response;
        if (httpServletResponse2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"response");
        }
        httpServletResponse2.setHeader("Location", "/issue/attachment");
        HttpServletResponse httpServletResponse3 = this.response;
        if (httpServletResponse3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"response");
        }
        httpServletResponse3.flushBuffer();
    }

    private final void processFile(XdPersistentFile file, String id, boolean forceDownload) {
        HttpServletResponse httpServletResponse;
        boolean isAccessible2;
        boolean bl;
        XdPersistentFile xdPersistentFile = file;
        if (xdPersistentFile instanceof XdBaseAttachment) {
            bl = XdBaseAttachment.isAccessible$default((XdBaseAttachment)file, null, null, 3, null);
        } else if (xdPersistentFile instanceof XdAttachmentThumbnail) {
            XdPersistentFile xdPersistentFile2 = ((XdAttachmentThumbnail)file).getImageFile();
            boolean bl2 = false;
            boolean bl3 = false;
            XdPersistentFile it = xdPersistentFile2;
            boolean bl4 = false;
            bl = it instanceof XdBaseAttachment && XdBaseAttachment.isAccessible$default((XdBaseAttachment)it, null, null, 3, null);
        } else {
            bl = isAccessible2 = false;
        }
        if (isAccessible2) {
            this.writeFileResponse(file, forceDownload);
            httpServletResponse = this.response;
            if (httpServletResponse == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
        } else {
            throw (Throwable)new NotFoundException("Attachment with id " + id + " not found");
        }
        httpServletResponse.flushBuffer();
    }

    static /* synthetic */ void processFile$default(PersistentFilesResource persistentFilesResource, XdPersistentFile xdPersistentFile, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processFile");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        persistentFilesResource.processFile(xdPersistentFile, string, bl);
    }

    private final void writeFileResponse(XdPersistentFile file, boolean forceDownload) {
        String rangeHeader;
        FileMeta fileMeta = new FileMeta(file.getEntity());
        IndexedInputStream fileStream = this.getFileStream(file, fileMeta);
        if (!fileStream.getHasContent()) {
            String message = "No content found for persistent file " + file.getName() + " [" + file.getXdId() + ']';
            Companion.getLogger().warn(message);
            throw (Throwable)new NotFoundException(message);
        }
        HttpServletRequest httpServletRequest = this.request;
        if (httpServletRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
        }
        if ((rangeHeader = httpServletRequest.getHeader("Range")) == null) {
            HttpServletResponse httpServletResponse = this.response;
            if (httpServletResponse == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
            httpServletResponse.setHeader("Accept-Ranges", "bytes");
            HttpServletResponse httpServletResponse2 = this.response;
            if (httpServletResponse2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
            String string = fileMeta.getMimeType();
            String string2 = fileMeta.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileMeta.name");
            this.setContentDispositionHeader(httpServletResponse2, string, string2, forceDownload);
            HttpServletResponse httpServletResponse3 = this.response;
            if (httpServletResponse3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
            CacheControlKt.cacheForOneYear(httpServletResponse3);
            HttpServletResponse httpServletResponse4 = this.response;
            if (httpServletResponse4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
            httpServletResponse4.setContentLength(fileStream.getContentLength());
            InputStream inputStream = fileStream.getContent();
            HttpServletResponse httpServletResponse5 = this.response;
            if (httpServletResponse5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"response");
            }
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)((OutputStream)httpServletResponse5.getOutputStream()));
        } else {
            boolean bl;
            Companion.getLogger().debug("Range file request received: " + rangeHeader);
            String string = rangeHeader;
            int n = 0;
            string = ((Object)StringsKt.trim((CharSequence)string)).toString();
            n = "bytes=".length();
            boolean bl2 = false;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String rangeValue = string4;
            long fileLength = fileMeta.getSize();
            long start2 = 0L;
            long end = 0L;
            if (StringsKt.startsWith$default((String)rangeValue, (String)"-", (boolean)false, (int)2, null)) {
                String string5;
                end = fileLength - 1L;
                String string6 = rangeValue;
                int n2 = "-".length();
                long l = fileLength - 1L;
                bl = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                string6 = string5 = string8;
                n2 = 0;
                long l2 = Long.parseLong(string6);
                start2 = l - l2;
            } else {
                long l;
                List list;
                CharSequence charSequence = rangeValue;
                String string9 = "-";
                int n3 = 0;
                string9 = new Regex(string9);
                n3 = 0;
                boolean bl3 = false;
                List $this$dropLastWhile$iv = string9.split(charSequence, n3);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl4 = false;
                        CharSequence charSequence2 = it;
                        boolean bl5 = false;
                        if (charSequence2.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] range = stringArray;
                charSequence = range[0];
                bl = false;
                start2 = Long.parseLong((String)charSequence);
                if (range.length > 1) {
                    charSequence = range[1];
                    bl = false;
                    l = Long.parseLong((String)charSequence);
                } else {
                    l = fileLength - 1L;
                }
                end = l;
            }
            long range = fileLength - 1L;
            bl = false;
            end = Math.min(end, range);
            if (start2 <= end) {
                long contentLength = end - start2 + 1L;
                HttpServletResponse httpServletResponse = this.response;
                if (httpServletResponse == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                httpServletResponse.setStatus(206);
                HttpServletResponse httpServletResponse6 = this.response;
                if (httpServletResponse6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                httpServletResponse6.setContentType(fileMeta.getMimeType());
                HttpServletResponse httpServletResponse7 = this.response;
                if (httpServletResponse7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                httpServletResponse7.setContentLength((int)contentLength);
                HttpServletResponse httpServletResponse8 = this.response;
                if (httpServletResponse8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                httpServletResponse8.setHeader("Content-Range", "bytes " + start2 + '-' + end + '/' + fileLength);
                HttpServletResponse httpServletResponse9 = this.response;
                if (httpServletResponse9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                CacheControlKt.cacheForOneYear(httpServletResponse9);
                InputStream inputStream = fileStream.getContent();
                HttpServletResponse httpServletResponse10 = this.response;
                if (httpServletResponse10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)((OutputStream)httpServletResponse10.getOutputStream()), (long)start2, (long)contentLength);
            } else {
                HttpServletResponse httpServletResponse = this.response;
                if (httpServletResponse == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"response");
                }
                httpServletResponse.setStatus(416);
            }
        }
    }

    private final IndexedInputStream getFileStream(XdPersistentFile persistentFile, FileMeta fileMeta) {
        if (persistentFile instanceof XdBaseAttachment && persistentFile.getContent() != null) {
            boolean cropped;
            HttpServletRequest httpServletRequest = this.request;
            if (httpServletRequest == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            }
            Integer n = this.extractInt(httpServletRequest, "w");
            int width = n != null ? n : Integer.MAX_VALUE;
            HttpServletRequest httpServletRequest2 = this.request;
            if (httpServletRequest2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            }
            Integer n2 = this.extractInt(httpServletRequest2, "h");
            int height = n2 != null ? n2 : Integer.MAX_VALUE;
            HttpServletRequest httpServletRequest3 = this.request;
            if (httpServletRequest3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            }
            Boolean bl = this.extractBoolean(httpServletRequest3, "c");
            boolean bl2 = cropped = bl != null ? bl : true;
            if (width == Integer.MAX_VALUE && height == Integer.MAX_VALUE || width <= 0 || height <= 0 || !BeansKt.getImageSupport().canResize((XdBaseAttachment)persistentFile)) {
                return new IndexedInputStream(persistentFile.getContent(), fileMeta.getSize());
            }
            XdAttachmentThumbnail xdAttachmentThumbnail = BeansKt.getImageSupport().tryCreateThumbnail((XdBaseAttachment)persistentFile, width, height).getThumb();
            if (xdAttachmentThumbnail != null) {
                XdAttachmentThumbnail xdAttachmentThumbnail2 = xdAttachmentThumbnail;
                boolean bl3 = false;
                boolean bl4 = false;
                XdAttachmentThumbnail it = xdAttachmentThumbnail2;
                boolean bl5 = false;
                String string = fileMeta.getMimeType();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileMeta.mimeType");
                String string2 = string;
                List list = AttachmentThumbnailImpl.formatsToConvertToPNG;
                boolean bl6 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String string5 = string4;
                if (list.contains(string5)) {
                    fileMeta.forcePng();
                    fileMeta.setSize(it.getSize());
                }
                return new IndexedInputStream(it.getContent(), it.getSize());
            }
            InputStream stream2 = ImageIOExtKt.getThumbnail(persistentFile, width, height, cropped, fileMeta);
            return new IndexedInputStream(stream2, stream2.available());
        }
        return new IndexedInputStream(persistentFile.getContent(), fileMeta.getSize());
    }

    private final void setContentDispositionHeader(@NotNull HttpServletResponse $this$setContentDispositionHeader, String mimeType, String fileName, boolean forceDownload) {
        Object object = mimeType;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null)) == null || (object = (String)object.get(0)) == null) {
            object = MimeUtil2.UNKNOWN_MIME_TYPE.toString();
        }
        $this$setContentDispositionHeader.setContentType((String)object);
        StringBuilder contentDisposition = new StringBuilder(this.isContentDispositionAttachment($this$setContentDispositionHeader.getContentType()) || forceDownload ? "attachment; " : "");
        CharsetEncoder enc = StandardCharsets.US_ASCII.newEncoder();
        boolean canEncode = enc.canEncode(fileName);
        if (canEncode) {
            contentDisposition.append("fileName=").append('\"').append(fileName).append('\"');
        } else {
            URI uri = this.getURIEncodedFileName(fileName);
            if (uri != null) {
                String string = uri.toASCIIString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toASCIIString()");
                CharSequence charSequence = string;
                String string2 = ",";
                boolean bl = false;
                string2 = new Regex(string2);
                String string3 = "%2C";
                boolean bl2 = false;
                String asciiEncodedFileNameWithoutCommas = string2.replace(charSequence, string3);
                contentDisposition.append("filename*=UTF-8''").append(asciiEncodedFileNameWithoutCommas);
            }
        }
        $this$setContentDispositionHeader.setHeader("Content-Disposition", contentDisposition.toString());
    }

    private final boolean isContentDispositionAttachment(String mimeType) {
        boolean bl;
        block6: {
            String string = mimeType;
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                Iterable $this$any$iv = UNSAFE_MIMES;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl5 = false;
                        CharSequence charSequence = mimeType;
                        boolean bl6 = false;
                        String string3 = charSequence.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                        charSequence = string3;
                        String string4 = it2;
                        boolean bl7 = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                        string4 = string6;
                        bl7 = false;
                        string4 = new Regex(string4);
                        bl7 = false;
                        if (!string4.matches(charSequence)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final URI getURIEncodedFileName(String fileName) {
        URI uRI;
        try {
            uRI = new URI(null, null, fileName, null);
        }
        catch (URISyntaxException e) {
            uRI = null;
        }
        return uRI;
    }

    public PersistentFilesResource(@NotNull EntitySigningService entitySigningService) {
        Intrinsics.checkParameterIsNotNull((Object)entitySigningService, (String)"entitySigningService");
        this.entitySigningService = entitySigningService;
    }

    static {
        Companion = new Companion(null);
        UNSAFE_MIMES = SetsKt.setOf((Object[])new String[]{"text/.*", "application/xml", "application/xhtml\\+xml", "application/x-shockwave-flash", "application/vnd.adobe.flash.movie", "image/svg\\+xml"});
    }

    @Override
    @Nullable
    public Integer extractInt(@Nullable HttpServletRequest $this$extractInt, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractInt(this, $this$extractInt, paramName);
    }

    @Override
    @Nullable
    public Boolean extractBoolean(@Nullable HttpServletRequest $this$extractBoolean, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractBoolean(this, $this$extractBoolean, paramName);
    }

    @Override
    @Nullable
    public XdUser extractUser(@Nullable HttpServletRequest $this$extractUser, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUser(this, $this$extractUser, paramName);
    }

    @Override
    @NotNull
    public List<XdUser> extractUsers(@Nullable HttpServletRequest $this$extractUsers, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUsers(this, $this$extractUsers, paramName);
    }

    @Override
    @NotNull
    public List<XdUserGroup> extractUserGroups(@Nullable HttpServletRequest $this$extractUserGroups, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractUserGroups(this, $this$extractUserGroups, paramName);
    }

    @Override
    @Nullable
    public XdIssue extractIssue(@Nullable HttpServletRequest $this$extractIssue, @NotNull String paramName) {
        Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
        return RestParametersExtractor.DefaultImpls.extractIssue(this, $this$extractIssue, paramName);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/rest/PersistentFilesResource$IndexedInputStream;", "", "bytes", "Ljava/io/InputStream;", "size", "", "(Ljava/io/InputStream;J)V", "content", "getContent", "()Ljava/io/InputStream;", "contentLength", "", "getContentLength", "()I", "hasContent", "", "getHasContent", "()Z", "youtrack-application"})
    private static final class IndexedInputStream {
        private final boolean hasContent;
        @Nullable
        private final InputStream content;
        private final int contentLength;

        public final boolean getHasContent() {
            return this.hasContent;
        }

        @Nullable
        public final InputStream getContent() {
            return this.content;
        }

        public final int getContentLength() {
            return this.contentLength;
        }

        public IndexedInputStream(@Nullable InputStream bytes, long size) {
            this.hasContent = bytes != null;
            this.content = bytes;
            this.contentLength = (int)size;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/rest/PersistentFilesResource$Companion;", "Lmu/KLogging;", "()V", "UNSAFE_MIMES", "", "", "getUNSAFE_MIMES", "()Ljava/util/Set;", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Set<String> getUNSAFE_MIMES() {
            return UNSAFE_MIMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

