/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.persistent.XdUserGroupExtKt;
import jetbrains.youtrack.persistent.security.XdUserRole;
import jetbrains.youtrack.security.AbstractYouTrackSecurity$getProjectsWithRoles$1;
import jetbrains.youtrack.security.BaseSecurity;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016J*\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/security/AbstractYouTrackSecurity;", "Ljetbrains/youtrack/security/BaseSecurity;", "()V", "doGetPermissionToProjectInMemory", "", "Ljetbrains/youtrack/core/security/Permission;", "", "Ljetbrains/exodus/entitystore/Entity;", "user", "includeArchived", "", "getPermissionToProject", "getPermissionToProjectInMemory", "getProjects", "permission", "getProjectsUnordered", "", "getProjectsWithRoles", "group", "youtrack-application"})
public abstract class AbstractYouTrackSecurity
extends BaseSecurity {
    @NotNull
    public List<Entity> getProjects(@NotNull Entity user2, @NotNull Permission permission, boolean includeArchived) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Map<Permission, List<Entity>> permissionToProject = this.getPermissionToProjectInMemory(user2, includeArchived);
        List list = permissionToProject.get(permission);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Set<Entity> getProjectsUnordered(@Nullable Entity user2, @NotNull Permission permission, boolean includeArchived) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Entity entity2 = user2;
        if (entity2 == null) {
            Intrinsics.throwNpe();
        }
        return new HashSet(this.getProjects(entity2, permission, includeArchived));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Entity> getProjectsWithRoles(@NotNull Entity group) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        XdQuery xdQuery = (XdQuery)XdUserGroupExtKt.getGroupRoles((XdUserGroup)XdExtensionsKt.toXd((Entity)group));
        KProperty1 field$iv = AbstractYouTrackSecurity$getProjectsWithRoles$1.INSTANCE;
        return CollectionsKt.toSet((Iterable)XdQueryKt.flatMapDistinct((XdQuery)$receiver$iv, (String)ReflectionUtilKt.getDBName((KProperty1)field$iv, (XdEntityType)$receiver$iv.getEntityType()), (XdEntityType)ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdProject.class))).getEntityIterable());
    }

    @NotNull
    public Map<Permission, List<Entity>> getPermissionToProject(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getPermissionToProjectInMemory(user2, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Permission, List<Entity>> getPermissionToProjectInMemory(@NotNull Entity user2, boolean includeArchived) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        XdUser xdUser = (XdUser)XdExtensionsKt.toXd((Entity)user2);
        if (xdUser.isSystem() || xdUser.isService()) {
            void $this$associateTo$iv$iv;
            List projects2 = CollectionsKt.toList((Iterable)XdProject.Companion.all().getEntityIterable());
            Permission[] $this$associate$iv = Permission.values();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
            Permission[] permissionArray = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                void it = element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, (Object)projects2);
                boolean bl2 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = this.doGetPermissionToProjectInMemory(user2, includeArchived);
        }
        return map2;
    }

    private final Map<Permission, List<Entity>> doGetPermissionToProjectInMemory(Entity user2, boolean includeArchived) {
        if (user2 == null) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        HashMap permissionToProjects = new HashMap();
        Iterable<XdUserRole> $this$forEach$iv = XdUserExtKt.getUserRoles((XdUser)XdExtensionsKt.toXd((Entity)user2));
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            XdUserRole xdUserRole;
            XdUserRole ur = xdUserRole = iterator2.next();
            boolean bl = false;
            for (Permission perm : ur.getRole().getPermissions()) {
                Set projects2 = (Set)permissionToProjects.get((Object)perm);
                if (projects2 != null) {
                    Collection collection = projects2;
                    boolean bl2 = false;
                    if (!(!collection.isEmpty())) continue;
                }
                if (projects2 == null) {
                    projects2 = (Set)new jetbrains.exodus.core.dataStructures.hash.HashSet();
                    ((Map)permissionToProjects).put(perm, projects2);
                }
                Iterable projectsList = XdQueryKt.isEmpty((XdQuery)((XdQuery)ur.getProjects())) ? XdProject.Companion.all().getEntityIterable() : ur.getProjects().getEntityIterable();
                CollectionsKt.addAll((Collection)projects2, (Iterable)projectsList);
            }
        }
        HashMap result2 = new HashMap();
        Map map2 = (Map)permissionToProjects;
        boolean ur = false;
        iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry bl = entry = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            Permission permission = (Permission)bl.getKey();
            bl = entry;
            bl3 = false;
            Set value1 = (Set)bl.getValue();
            ArrayList<Entity> value = new ArrayList<Entity>();
            for (Entity project2 : value1) {
                XdProject xdProject = (XdProject)XdProject.Companion.wrap(project2);
                if (xdProject.isRemoved() || !includeArchived && xdProject.getArchived()) continue;
                value.add(project2);
            }
            Collections.sort((List)value, ProjectImpl.COMPARATOR);
            ((Map)result2).put(permission, value);
        }
        return (Map)result2;
    }

    protected AbstractYouTrackSecurity() {
    }
}

