/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.security;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import jetbrains.youtrack.core.persistent.SecretProviderEntity;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import jetbrains.youtrack.security.MalformedSignatureException;
import jetbrains.youtrack.security.SignatureDuration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import mu.KLogging;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bH\u0002J\"\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J/\u0010\u0017\u001a\u00020\t*\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001b\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/security/EntitySigningService;", "", "()V", "extractInfo", "Ljetbrains/youtrack/security/EntitySigningService$EntitySignInfo;", "T", "Lkotlinx/dnq/XdEntity;", "decoded", "", "", "type", "Lkotlinx/dnq/XdEntityType;", "newSign", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "entity", "duration", "Ljetbrains/youtrack/security/SignatureDuration;", "parseSign", "sign", "token", "tryPassword", "", "signature", "timestamp", "", "withPassword", "signature$youtrack_application", "Companion", "EntitySignInfo", "youtrack-application"})
public final class EntitySigningService {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String newSign(@NotNull XdUser user2, @Nullable XdEntity entity2, @NotNull SignatureDuration duration) {
        String token;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)((Object)duration), (String)"duration");
        DateTime dateTime = new DateTime(System.currentTimeMillis() + duration.getDuration(), DateTimeZone.UTC).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(System.currentT\u2026C).withTimeAtStartOfDay()");
        long timestamp = dateTime.getMillis();
        XdEntity xdEntity = entity2;
        String string = token = "" + timestamp + '|' + user2.getXdId() + '|' + (xdEntity != null ? xdEntity.getXdId() : null) + '|' + EntitySigningService.signature$youtrack_application$default(this, user2, entity2, timestamp, false, 4, null);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] tokenBytes = byArray;
        String string3 = new Base64(true).encodeAsString(tokenBytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"org.apache.commons.codec\u2026ncodeAsString(tokenBytes)");
        return string3;
    }

    public static /* synthetic */ String newSign$default(EntitySigningService entitySigningService, XdUser xdUser, XdEntity xdEntity, SignatureDuration signatureDuration, int n, Object object) {
        if ((n & 2) != 0) {
            xdEntity = null;
        }
        return entitySigningService.newSign(xdUser, xdEntity, signatureDuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends XdEntity> EntitySignInfo<T> parseSign(@NotNull String token, @NotNull XdEntityType<? extends T> type, boolean tryPassword) {
        void user2;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        List<String> decoded = this.parseSign(token);
        EntitySignInfo<T> info = this.extractInfo(decoded, type);
        Object object = info;
        XdUser xdUser = ((EntitySignInfo)object).component1();
        T entity2 = ((EntitySignInfo)object).component2();
        object = decoded.get(0);
        T t2 = entity2;
        void var12_10 = user2;
        EntitySigningService entitySigningService = this;
        String string = decoded.get(3);
        boolean bl = false;
        long l = Long.parseLong((String)object);
        if (Intrinsics.areEqual((Object)string, (Object)EntitySigningService.signature$youtrack_application$default(entitySigningService, (XdUser)var12_10, t2, l, false, 4, null)) ^ true) {
            if (tryPassword) {
                object = decoded.get(0);
                t2 = entity2;
                var12_10 = user2;
                entitySigningService = this;
                string = decoded.get(3);
                bl = false;
                l = Long.parseLong((String)object);
                if (Intrinsics.areEqual((Object)string, (Object)entitySigningService.signature$youtrack_application((XdUser)var12_10, (XdEntity)t2, l, true)) ^ true) {
                    throw (Throwable)new MalformedSignatureException("URL signature is invalid", null, 2, null);
                }
            } else {
                throw (Throwable)new MalformedSignatureException("URL signature is invalid", null, 2, null);
            }
        }
        object = decoded.get(0);
        long l2 = System.currentTimeMillis();
        bl = false;
        long l3 = Long.parseLong((String)object);
        if (l2 > l3) {
            throw (Throwable)new MalformedSignatureException("The link has expired", null, 2, null);
        }
        return info;
    }

    public static /* synthetic */ EntitySignInfo parseSign$default(EntitySigningService entitySigningService, String string, XdEntityType xdEntityType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return entitySigningService.parseSign(string, xdEntityType, bl);
    }

    @NotNull
    public final String signature$youtrack_application(@NotNull XdUser $this$signature, @Nullable XdEntity entity2, long timestamp, boolean withPassword) {
        Intrinsics.checkParameterIsNotNull((Object)$this$signature, (String)"$this$signature");
        String salt = withPassword ? $this$signature.getPassword() : (entity2 instanceof SecretProviderEntity ? $this$signature.getSecret() + ((SecretProviderEntity)entity2).getSecret() : $this$signature.getSecret());
        XdEntity xdEntity = entity2;
        String raw = "" + timestamp + '|' + $this$signature.getXdId() + '|' + (xdEntity != null ? xdEntity.getXdId() : null) + '|' + salt;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = raw;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        MessageDigest messageDigest2 = messageDigest;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] hash = messageDigest2.digest(byArray2);
        String string3 = new Base64(true).encodeAsString(hash);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"org.apache.commons.codec\u2026rue).encodeAsString(hash)");
        return string3;
    }

    public static /* synthetic */ String signature$youtrack_application$default(EntitySigningService entitySigningService, XdUser xdUser, XdEntity xdEntity, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            xdEntity = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return entitySigningService.signature$youtrack_application(xdUser, xdEntity, l, bl);
    }

    private final List<String> parseSign(String sign) {
        Object object;
        try {
            byte[] byArray = new Base64(true).decode(sign);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"org.apache.commons.codec\u2026Base64(true).decode(sign)");
            object = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            object = new String((byte[])object, charset2);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new MalformedSignatureException("URL signature is invalid", e);
        }
        List decoded = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"|"}, (boolean)false, (int)0, (int)6, null);
        if (decoded.size() != 4 && decoded.size() != 5) {
            throw (Throwable)new MalformedSignatureException("URL signature is invalid", null, 2, null);
        }
        return decoded;
    }

    private final <T extends XdEntity> EntitySignInfo<T> extractInfo(List<String> decoded, XdEntityType<? extends T> type) {
        XdUser xdUser = (XdUser)PersitenceExtensionsKt.tryFindById((XdEntityType)XdUser.Companion, decoded.get(1));
        if (xdUser == null) {
            EntitySigningService entitySigningService = this;
            boolean bl = false;
            boolean bl2 = false;
            EntitySigningService $this$run = entitySigningService;
            boolean bl3 = false;
            Companion.getLogger().warn("No user found with id " + decoded.get(1));
            throw (Throwable)new MalformedSignatureException("URL signature is invalid", null, 2, null);
        }
        XdUser user2 = xdUser;
        if (Intrinsics.areEqual((Object)decoded.get(2), (Object)"null")) {
            return new EntitySignInfo<Object>(user2, null);
        }
        T t2 = PersitenceExtensionsKt.tryFindById(type, decoded.get(2));
        if (t2 == null) {
            EntitySigningService entitySigningService = this;
            boolean bl = false;
            boolean bl4 = false;
            EntitySigningService $this$run = entitySigningService;
            boolean bl5 = false;
            Companion.getLogger().warn("\"No entity found with id " + decoded.get(2) + '\"');
            throw (Throwable)new MalformedSignatureException("URL signature is invalid", null, 2, null);
        }
        T entity2 = t2;
        return new EntitySignInfo<T>(user2, entity2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/security/EntitySigningService$EntitySignInfo;", "T", "Lkotlinx/dnq/XdEntity;", "", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "entity", "(Ljetbrains/youtrack/core/persistent/user/XdUser;Lkotlinx/dnq/XdEntity;)V", "getEntity", "()Lkotlinx/dnq/XdEntity;", "Lkotlinx/dnq/XdEntity;", "getUser", "()Ljetbrains/youtrack/core/persistent/user/XdUser;", "component1", "component2", "copy", "(Ljetbrains/youtrack/core/persistent/user/XdUser;Lkotlinx/dnq/XdEntity;)Ljetbrains/youtrack/security/EntitySigningService$EntitySignInfo;", "equals", "", "other", "hashCode", "", "toString", "", "youtrack-application"})
    public static final class EntitySignInfo<T extends XdEntity> {
        @NotNull
        private final XdUser user;
        @Nullable
        private final T entity;

        @NotNull
        public final XdUser getUser() {
            return this.user;
        }

        @Nullable
        public final T getEntity() {
            return this.entity;
        }

        public EntitySignInfo(@NotNull XdUser user2, @Nullable T entity2) {
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            this.user = user2;
            this.entity = entity2;
        }

        @NotNull
        public final XdUser component1() {
            return this.user;
        }

        @Nullable
        public final T component2() {
            return this.entity;
        }

        @NotNull
        public final EntitySignInfo<T> copy(@NotNull XdUser user2, @Nullable T entity2) {
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            return new EntitySignInfo<T>(user2, entity2);
        }

        public static /* synthetic */ EntitySignInfo copy$default(EntitySignInfo entitySignInfo, XdUser xdUser, XdEntity object, int n, Object object2) {
            if ((n & 1) != 0) {
                xdUser = entitySignInfo.user;
            }
            if ((n & 2) != 0) {
                object = entitySignInfo.entity;
            }
            return entitySignInfo.copy(xdUser, object);
        }

        @NotNull
        public String toString() {
            return "EntitySignInfo(user=" + this.user + ", entity=" + this.entity + ")";
        }

        public int hashCode() {
            XdUser xdUser = this.user;
            T t2 = this.entity;
            return (xdUser != null ? xdUser.hashCode() : 0) * 31 + (t2 != null ? t2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EntitySignInfo)) break block3;
                    EntitySignInfo entitySignInfo = (EntitySignInfo)object;
                    if (!Intrinsics.areEqual((Object)this.user, (Object)entitySignInfo.user) || !Intrinsics.areEqual(this.entity, entitySignInfo.entity)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/security/EntitySigningService$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

