/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.security;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.persistent.security.XdUserRole;
import jetbrains.youtrack.security.AbstractYouTrackSecurity;
import jetbrains.youtrack.security.YouTrackSecurityImpl$hasRole$1;
import jetbrains.youtrack.security.YouTrackSecurityImpl$hasRole$2;
import jetbrains.youtrack.security.YouTrackSecurityImpl$hasRole$role$1;
import jetbrains.youtrack.security.YouTrackSecurityImpl$hasRole$role$2;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component(value="youtrackSecurityInternal")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/security/YouTrackSecurityImpl;", "Ljetbrains/youtrack/security/AbstractYouTrackSecurity;", "()V", "getImplementationName", "", "localized", "", "getProjectsUnordered", "", "Ljetbrains/exodus/entitystore/Entity;", "user", "permission", "Ljetbrains/youtrack/core/security/Permission;", "includeArchived", "hasPermission", "project", "hasPermissionInGlobalProject", "hasRole", "roleName", "youtrack-application"})
public final class YouTrackSecurityImpl
extends AbstractYouTrackSecurity {
    @Override
    @NotNull
    public Set<Entity> getProjectsUnordered(@Nullable Entity user2, @NotNull Permission permission, boolean includeArchived) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Entity entity2 = user2;
        if (entity2 == null) {
            Intrinsics.throwNpe();
        }
        Map<Permission, List<Entity>> permissionToProject = this.getPermissionToProjectInMemory(entity2, includeArchived);
        List<Entity> list = permissionToProject.get(permission);
        if (list == null) {
            boolean bl = false;
            return SetsKt.emptySet();
        }
        List<Entity> projects2 = list;
        return CollectionsKt.toSet((Iterable)projects2);
    }

    public boolean hasPermission(@NotNull Entity user2, @NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        XdUser xdUser = (XdUser)XdExtensionsKt.toXd((Entity)user2);
        return xdUser.isSystem() || xdUser.isService() ? true : this.getPermissionToProject(user2).containsKey(permission);
    }

    public boolean hasPermission(@NotNull Entity user2, @NotNull Permission permission, @NotNull Entity project2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        XdUser xdUser = (XdUser)XdExtensionsKt.toXd((Entity)user2);
        if (xdUser.isSystem()) {
            return true;
        }
        List<Entity> projects2 = this.getProjects(user2, permission, false);
        Comparator comparator = ProjectImpl.COMPARATOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)comparator, (String)"ProjectImpl.COMPARATOR");
        return CollectionsKt.binarySearch$default(projects2, (Object)project2, (Comparator)comparator, (int)0, (int)0, (int)12, null) >= 0;
    }

    public boolean hasPermissionInGlobalProject(@NotNull Entity user2, @NotNull Permission permission) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
            XdUser xdUser = (XdUser)XdExtensionsKt.toXd((Entity)user2);
            if (xdUser.isSystem()) {
                return true;
            }
            Sequence $this$all$iv = XdQueryKt.asSequence((XdQuery)XdProject.Companion.all());
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                XdProject it = (XdProject)element$iv;
                boolean bl2 = false;
                if (this.hasPermission(user2, permission, it.getEntity())) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasRole(@NotNull Entity user2, @NotNull String roleName) {
        void node$iv;
        void $receiver$iv;
        NodeBase $receiver$iv2;
        NodeBase nodeBase;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)roleName, (String)"roleName");
        KProperty1 kProperty1 = (KProperty1)YouTrackSecurityImpl$hasRole$1.INSTANCE;
        KProperty1 kProperty12 = (KProperty1)YouTrackSecurityImpl$hasRole$2.INSTANCE;
        XdQuery xdQuery = (XdQuery)XdUserExtKt.getUserRoles((XdUser)XdExtensionsKt.toXd((Entity)user2));
        $receiver$iv2 = nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv2, (KClass)Reflection.getOrCreateKotlinClass(XdRole.class)), (Comparable)((Comparable)((Object)roleName)));
        nodeBase = NodeBaseOperationsKt.matches((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdUserRole.class), (NodeBase)node$iv);
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase));
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasRole(@NotNull Entity user2, @NotNull Entity project2, @NotNull String roleName) {
        void node$iv;
        void $receiver$iv;
        NodeBase $receiver$iv2;
        NodeBase nodeBase;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)roleName, (String)"roleName");
        KProperty1 kProperty1 = (KProperty1)YouTrackSecurityImpl$hasRole$role$1.INSTANCE;
        KProperty1 kProperty12 = (KProperty1)YouTrackSecurityImpl$hasRole$role$2.INSTANCE;
        XdQuery xdQuery = (XdQuery)XdUserExtKt.getUserRoles((XdUser)XdExtensionsKt.toXd((Entity)user2));
        $receiver$iv2 = nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv2, (KClass)Reflection.getOrCreateKotlinClass(XdRole.class)), (Comparable)((Comparable)((Object)roleName)));
        nodeBase = NodeBaseOperationsKt.matches((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdUserRole.class), (NodeBase)node$iv);
        XdUserRole xdUserRole = (XdUserRole)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase));
        if (xdUserRole == null) {
            return false;
        }
        XdUserRole role2 = xdUserRole;
        return XdQueryKt.isEmpty((XdQuery)((XdQuery)role2.getProjects())) || XdQueryKt.contains((XdQuery)((XdQuery)role2.getProjects()), (XdEntity)XdExtensionsKt.toXd((Entity)project2));
    }

    @NotNull
    public String getImplementationName(boolean localized) {
        String string;
        if (localized) {
            String string2 = BeansKt.getLocalizer().localizedMsg("YouTrackSecurityImpl.Local_YouTrack_permission_management", new Object[0]);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"localizer.localizedMsg(\"\u2026k_permission_management\")");
        } else {
            string = "Local YouTrack permission management";
        }
        return string;
    }
}

