grammar IssuesAndArticles;

issue
    : ISSUE_ID
    ;

article
    : ARTICLE_ID
    ;

projectId
    : PROJECT_ID
    ;

dash
    : DASH
    ;

issueNumber
    : ISSUE_NUMBER
    ;

other
    : OTHER_SYMBOL
    ;

ISSUE_ID
    : ([a-zA-Z0-9_]+)[-][0-9]+
    ;

ARTICLE_ID
    : ([a-zA-Z0-9_]+)[-][A][-][0-9]+
    ;

PROJECT_ID
    : ([a-zA-Z0-9_])+
    ;

DASH
    : ([-])
    ;

DASHADASH
    : ([-][A][-])
    ;

ISSUE_NUMBER
    : ([0-9])+
    ;

OTHER_SYMBOL
    :
    ~[a-zA-Z0-9_-]
    ;

WS : [ \n\r\t] -> skip;