/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.article.notifications.data;

import java.util.List;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.EventMerge;
import jetbrains.youtrack.api.notifications.NotificationData;
import jetbrains.youtrack.api.notifications.NotificationReason;
import jetbrains.youtrack.article.event.multiplier.AddArticleCommentEventMultiplier;
import jetbrains.youtrack.article.event.multiplier.AddArticleEventMultiplier;
import jetbrains.youtrack.article.notifications.XdUserNotificationArticleExtensionKt;
import jetbrains.youtrack.article.notifications.data.ArticleChangeAdapterFactory;
import jetbrains.youtrack.event.merge.EventMergeImpl;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.event.rollback.EventMultiplier;
import jetbrains.youtrack.notifications.analyzer.EventMergeAccumulator;
import jetbrains.youtrack.notifications.data.NotificationPropertyDeserializer;
import jetbrains.youtrack.notifications.data.change.NotificationChangeAdapter;
import jetbrains.youtrack.notifications.main.NotificationPropertiesKt;
import jetbrains.youtrack.notifications.persistence.UserNotificationExtension;
import jetbrains.youtrack.notifications.persistence.XdUserNotification;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/article/notifications/data/NotificationArticleChangeDeserializer;", "Ljetbrains/youtrack/notifications/data/NotificationPropertyDeserializer;", "()V", "multipliers", "", "Ljetbrains/youtrack/event/rollback/EventMultiplier;", "deserializeAndSet", "", "data", "Ljetbrains/youtrack/api/notifications/NotificationData;", "notification", "Ljetbrains/youtrack/notifications/persistence/XdUserNotification;", "youtrack-articles"})
public final class NotificationArticleChangeDeserializer
implements NotificationPropertyDeserializer {
    private final List<EventMultiplier> multipliers = CollectionsKt.listOf((Object[])new EventMultiplier[]{new AddArticleEventMultiplier(), (EventMultiplier)new AddArticleCommentEventMultiplier()});

    public void deserializeAndSet(@NotNull NotificationData data, @NotNull XdUserNotification notification) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        UserNotificationExtension extension = XdUserNotificationArticleExtensionKt.getArticleNotificationExtension();
        if (!extension.isApplicable(notification)) {
            return;
        }
        NotificationReason notificationReason = (NotificationReason)data.get(NotificationPropertiesKt.getReasonNotificationProperty());
        if (notificationReason == null) {
            throw (Throwable)new IllegalArgumentException('[' + notification.getXdId() + "] does not contain reason");
        }
        NotificationReason recipientReason = notificationReason;
        Boolean bl = (Boolean)data.get(NotificationPropertiesKt.getLastNotificationNotificationProperty());
        boolean recipientLostAccess = bl != null ? bl : false;
        List events = SequencesKt.toList((Sequence)extension.readEvents(notification));
        EventMergeAccumulator mergeAccumulator2 = new EventMergeAccumulator((EventMerge)new EventMergeImpl(events));
        NotificationChangeAdapter articleChange = ArticleChangeAdapterFactory.INSTANCE.createChangeAdapter(mergeAccumulator2, notification.getRecipient(), recipientReason, recipientLostAccess);
        if (articleChange == null) {
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append('[' + notification.getXdId() + "] has no notifiable events:\n");
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Event it = (Event)element$iv;
                boolean bl6 = false;
                $this$buildString.append("\t").append(DebugInfoMethodsKt.getDebugInfo((Event)it)).append("\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String noNotifiableEventsMessage = string;
            throw (Throwable)new IllegalArgumentException(noNotifiableEventsMessage);
        }
        data.set(NotificationPropertiesKt.getChangeNotificationProperty(), (Object)articleChange);
    }

    @Nullable
    public NotificationPropertyDeserializer getLaunchAfter() {
        return NotificationPropertyDeserializer.DefaultImpls.getLaunchAfter((NotificationPropertyDeserializer)this);
    }
}

