/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.article.security;

import jetbrains.youtrack.article.security.ArticleSecurityService;
import jetbrains.youtrack.article.security.ArticleSecurityService$WhenMappings;
import jetbrains.youtrack.article.security.ArticleSecurityService$getProjectSafe$1;
import jetbrains.youtrack.core.persistent.article.XdArticle;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.SecurityCompatible;
import jetbrains.youtrack.persistent.security.BasicSecurityCacheKt;
import jetbrains.youtrack.persistent.security.SecurityCache;
import jetbrains.youtrack.persistent.security.XdEntitySecurityService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J2\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/article/security/ArticleSecurityService;", "Ljetbrains/youtrack/persistent/security/XdEntitySecurityService;", "Ljetbrains/youtrack/core/persistent/article/XdArticle;", "()V", "createPermission", "Ljetbrains/youtrack/core/security/Permission;", "getCreatePermission", "()Ljetbrains/youtrack/core/security/Permission;", "xdEntityType", "Lkotlinx/dnq/XdEntityType;", "getXdEntityType", "()Lkotlinx/dnq/XdEntityType;", "filterAccessible", "Lkotlinx/dnq/query/XdQuery;", "xdEntities", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "operation", "Ljetbrains/youtrack/core/security/Operation;", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "securityCache", "Ljetbrains/youtrack/persistent/security/SecurityCache;", "getProjectSafe", "xdEntity", "hasHiddenStuffReadAccess", "", "isAccessible", "isAccessibleCompatible", "compatible", "Ljetbrains/youtrack/core/security/SecurityCompatible;", "isReporterOperationAllowedByCreate", "youtrack-articles"})
public final class ArticleSecurityService
implements XdEntitySecurityService<XdArticle> {
    @NotNull
    public XdEntityType<XdArticle> getXdEntityType() {
        return (XdEntityType)XdArticle.Companion;
    }

    @Nullable
    public Permission getCreatePermission() {
        return Permission.CREATE_ARTICLE;
    }

    public boolean isAccessible(@NotNull XdArticle xdEntity, @Nullable XdProject project, @NotNull Operation operation, @NotNull XdUser user, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        if (xdEntity.getDeleted()) {
            return false;
        }
        XdProject xdProject = project;
        if (xdProject == null) {
            xdProject = this.getProjectSafe(xdEntity);
        }
        XdProject articleProject = xdProject;
        return this.isAccessibleCompatible((SecurityCompatible)xdEntity, articleProject, operation, user, securityCache);
    }

    public final boolean isAccessibleCompatible(@NotNull SecurityCompatible compatible, @Nullable XdProject project, @NotNull Operation operation, @NotNull XdUser user, @NotNull SecurityCache securityCache) {
        Operation operation2;
        Intrinsics.checkParameterIsNotNull((Object)compatible, (String)"compatible");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        if (user.getBanned()) {
            return false;
        }
        if (user.isSystem() || user.isService()) {
            return true;
        }
        boolean own = Intrinsics.areEqual((Object)compatible.getPermittedOwner(), (Object)user);
        if (project == null) {
            return own;
        }
        if (own && this.isReporterOperationAllowedByCreate(operation) && securityCache.hasPermission(XdArticle.Companion.getEntityType(), Operation.CREATE, project, user)) {
            return true;
        }
        switch (ArticleSecurityService$WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                operation2 = Operation.UPDATE_NOT_OWN;
                break;
            }
            case 2: {
                operation2 = Operation.DELETE_NOT_OWN;
                break;
            }
            default: {
                operation2 = operation;
            }
        }
        Operation normalizedOperation = operation2;
        return securityCache.hasPermission(XdArticle.Companion.getEntityType(), normalizedOperation, project, user) && (own || this.isSecuredReadAccessible(compatible, user, project, securityCache));
    }

    public static /* synthetic */ boolean isAccessibleCompatible$default(ArticleSecurityService articleSecurityService, SecurityCompatible securityCompatible, XdProject xdProject, Operation operation, XdUser xdUser, SecurityCache securityCache, int n, Object object) {
        if ((n & 0x10) != 0) {
            securityCache = (SecurityCache)BasicSecurityCacheKt.getBasicSecurityCache();
        }
        return articleSecurityService.isAccessibleCompatible(securityCompatible, xdProject, operation, xdUser, securityCache);
    }

    private final boolean isReporterOperationAllowedByCreate(Operation operation) {
        return operation == Operation.READ || operation == Operation.UPDATE || operation == Operation.LINK || operation == Operation.DELETE;
    }

    @NotNull
    public XdQuery<XdArticle> filterAccessible(@NotNull XdQuery<XdArticle> xdEntities, @Nullable XdProject project, @NotNull Operation operation, @NotNull XdUser user, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull(xdEntities, (String)"xdEntities");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return user.getBanned() ? XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdArticle.Companion)) : (user.isSystem() ? xdEntities : XdQueryKt.asQuery((Iterable)SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence(xdEntities), (Function1)((Function1)new Function1<XdArticle, Boolean>(this, project, operation, user, securityCache){
            final /* synthetic */ ArticleSecurityService this$0;
            final /* synthetic */ XdProject $project;
            final /* synthetic */ Operation $operation;
            final /* synthetic */ XdUser $user;
            final /* synthetic */ SecurityCache $securityCache;

            public final boolean invoke(@NotNull XdArticle it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.isAccessible(it, this.$project, this.$operation, this.$user, this.$securityCache);
            }
            {
                this.this$0 = articleSecurityService;
                this.$project = xdProject;
                this.$operation = operation;
                this.$user = xdUser;
                this.$securityCache = securityCache;
                super(1);
            }
        })), (Function1)filterAccessible.2.INSTANCE)), (XdEntityType)((XdEntityType)XdArticle.Companion)));
    }

    public boolean hasHiddenStuffReadAccess(@NotNull XdUser user, @NotNull XdProject project, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return securityCache.hasPermissionInProject(Permission.READ_HIDDEN_STUFF, project, user) && securityCache.hasPermissionInProject(Permission.READ_ARTICLE, project, user);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XdProject getProjectSafe(@NotNull XdArticle xdEntity) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        XdEntity xdEntity2 = (XdEntity)xdEntity;
        KProperty1 property$iv = (KProperty1)ArticleSecurityService$getProjectSafe$1.INSTANCE;
        return (XdProject)ReflectionUtilKt.getSafe((XdEntity)$receiver$iv, XdArticle.class, (KProperty1)property$iv);
    }

    public boolean isSecuredReadAccessible(@NotNull SecurityCompatible xdEntity, @NotNull XdUser user, @Nullable XdProject project, @NotNull SecurityCache securityCache) {
        Intrinsics.checkParameterIsNotNull((Object)xdEntity, (String)"xdEntity");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)securityCache, (String)"securityCache");
        return XdEntitySecurityService.DefaultImpls.isSecuredReadAccessible((XdEntitySecurityService)this, (SecurityCompatible)xdEntity, (XdUser)user, (XdProject)project, (SecurityCache)securityCache);
    }
}

