/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jetbrains.youtrack.api.commands.ICell;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandExecutor;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.IField;
import jetbrains.youtrack.commands.impl.cell.CommandTypeCell;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.parser.api.IPrefixTreesData;
import jetbrains.youtrack.parser.api.IWord;
import jetbrains.youtrack.parser.base.SuggestItem;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u00112\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u0011H\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u001dH\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00102\u0006\u0010:\u001a\u000200H\u0016J\b\u0010;\u001a\u00020-H\u0016J\b\u0010<\u001a\u00020-H\u0016J\u0012\u0010=\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0013\u00a8\u0006>"}, d2={"Ljetbrains/youtrack/commands/impl/CommandList;", "Ljetbrains/youtrack/api/commands/ICommandList;", "text", "", "tokens", "", "Ljetbrains/youtrack/parser/api/IWord;", "prefixTrees", "Ljetbrains/youtrack/parser/api/IPrefixTreesData;", "context", "Ljetbrains/youtrack/api/context/IContext;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/youtrack/parser/api/IPrefixTreesData;Ljetbrains/youtrack/api/context/IContext;)V", "_commands", "", "Ljetbrains/youtrack/api/commands/ICommand;", "cells", "", "Ljetbrains/youtrack/api/commands/ICell;", "getCells", "()Ljava/lang/Iterable;", "commands", "getCommands", "getContext", "()Ljetbrains/youtrack/api/context/IContext;", "debugDescription", "getDebugDescription", "()Ljava/lang/String;", "fieldToCommand", "", "Ljetbrains/youtrack/api/parser/IField;", "lastCell", "getLastCell", "()Ljetbrains/youtrack/api/commands/ICell;", "getPrefixTrees", "()Ljetbrains/youtrack/parser/api/IPrefixTreesData;", "getText", "getTokens", "()Ljava/util/List;", "validCommands", "getValidCommands", "addCommand", "", "command", "execute", "flushPages", "", "findCell", "pos", "", "getCell", "index", "getCellIndex", "cell", "getCommandExecutor", "Ljetbrains/youtrack/api/commands/ICommandExecutor;", "category", "getSuggestions", "Ljetbrains/youtrack/parser/base/SuggestItem;", "cursorPos", "hasDeleteIssueCommand", "hasErrors", "removeCommand", "youtrack-commands"})
public final class CommandList
implements ICommandList {
    private final List<ICommand> _commands;
    private final Map<IField, ICommand> fieldToCommand;
    @NotNull
    private final String text;
    @NotNull
    private final List<IWord> tokens;
    @NotNull
    private final IPrefixTreesData prefixTrees;
    @NotNull
    private final IContext context;

    public void addCommand(@Nullable ICommand command) {
        if (command == null) {
            return;
        }
        this._commands.add(command);
        ICommandExecutor iCommandExecutor = command.getCommandExecutor();
        if (iCommandExecutor == null || (iCommandExecutor = iCommandExecutor.getField()) == null) {
            return;
        }
        ICommandExecutor field = iCommandExecutor;
        this.fieldToCommand.put((IField)field, command);
    }

    public void removeCommand(@Nullable ICommand command) {
        if (command == null) {
            return;
        }
        this._commands.remove(command);
        ICommandExecutor iCommandExecutor = command.getCommandExecutor();
        if (iCommandExecutor == null || (iCommandExecutor = iCommandExecutor.getField()) == null) {
            return;
        }
        ICommandExecutor field = iCommandExecutor;
        this.fieldToCommand.remove(field);
    }

    @NotNull
    public Iterable<ICommand> getCommands() {
        return this._commands;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<ICommand> getValidCommands() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this._commands;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICommand it = (ICommand)element$iv$iv;
            boolean bl = false;
            if (!(it.getCommandExecutor() != null || it.isError())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public ICommandExecutor getCommandExecutor(@NotNull IField category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        ICommand iCommand = this.fieldToCommand.get(category);
        return iCommand != null ? iCommand.getCommandExecutor() : null;
    }

    private final ICell findCell(int pos) {
        return (ICell)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this._commands), (Function1)((Function1)new Function1<ICommand, ICell>(pos){
            final /* synthetic */ int $pos;

            @Nullable
            public final ICell invoke(@NotNull ICommand it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.findCell(this.$pos);
            }
            {
                this.$pos = n;
                super(1);
            }
        })));
    }

    @Nullable
    public ICell getLastCell() {
        ICommand iCommand = (ICommand)CollectionsKt.lastOrNull(this._commands);
        return iCommand != null ? iCommand.getLastCell() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<ICell> getCells() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this._commands;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ICommand it = (ICommand)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getCells();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public int getCellIndex(@NotNull ICell cell) {
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        Iterable<ICell> cells = this.getCells();
        int idx = CollectionsKt.indexOf(cells, (Object)cell);
        if (idx < 0) {
            throw (Throwable)new IllegalArgumentException("Cell not found.");
        }
        return idx;
    }

    @NotNull
    public ICell getCell(int index) {
        List cells = CollectionsKt.toList(this.getCells());
        return (ICell)cells.get(index);
    }

    public void execute() {
        this.execute(true);
    }

    public void execute(boolean flushPages) {
        Iterable $this$mapNotNullTo$iv$iv;
        int nextPageStart = 1000;
        int current = 0;
        Iterable $this$mapNotNull$iv = this._commands;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ICommandExecutor iCommandExecutor;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ICommand it = (ICommand)element$iv$iv;
            boolean bl2 = false;
            if (it.getCommandExecutor() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ICommandExecutor it$iv$iv = iCommandExecutor;
            boolean bl5 = false;
            destination$iv$iv22.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv22;
        boolean $i$f$sortedBy = false;
        $this$mapNotNullTo$iv$iv = $this$sortedBy$iv;
        boolean destination$iv$iv22 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ICommandExecutor it = (ICommandExecutor)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(it.isTailCommand());
                it = (ICommandExecutor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = it.isTailCommand();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        };
        List executors = CollectionsKt.sortedWith((Iterable)$this$mapNotNullTo$iv$iv, (Comparator)comparator);
        for (XdIssue issue : this.getContext().getSelectedIssues()) {
            if (current++ >= nextPageStart && flushPages) {
                LegacySupportKt.flush();
                nextPageStart += 1000;
            }
            Iterable $this$forEach$iv = executors;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                ICommandExecutor executor = (ICommandExecutor)element$iv;
                boolean bl = false;
                executor.execute(issue);
            }
        }
        if (current != 0 && flushPages) {
            LegacySupportKt.flush();
        }
    }

    @NotNull
    public String getDebugDescription() {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = this._commands;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ICommand it = (ICommand)element$iv;
            boolean bl = false;
            sb.append("[").append(it.getDebugDescription()).append("]");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public Iterable<SuggestItem> getSuggestions(int cursorPos) {
        Object object = this.findCell(cursorPos);
        if (object == null || (object = object.getSuggestions(cursorPos)) == null) {
            Iterable iterable = SuggestItem.EMPTY;
            object = iterable;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"SuggestItem.EMPTY");
        }
        return object;
    }

    public boolean hasDeleteIssueCommand() {
        boolean bl;
        block3: {
            Iterable<ICell> $this$any$iv = this.getCells();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<ICell> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ICell element$iv;
                    ICell it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it instanceof CommandTypeCell && ((CommandTypeCell)it).isDeleteIssueCommandTypeCell())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this._commands;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ICommand it = (ICommand)element$iv;
                    boolean bl2 = false;
                    if (!it.isError()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public List<IWord> getTokens() {
        return this.tokens;
    }

    @NotNull
    public IPrefixTreesData getPrefixTrees() {
        return this.prefixTrees;
    }

    @NotNull
    public IContext getContext() {
        return this.context;
    }

    public CommandList(@NotNull String text2, @NotNull List<? extends IWord> tokens, @NotNull IPrefixTreesData prefixTrees, @NotNull IContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)prefixTrees, (String)"prefixTrees");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.text = text2;
        this.tokens = tokens;
        this.prefixTrees = prefixTrees;
        this.context = context2;
        this._commands = new LinkedList();
        this.fieldToCommand = new LinkedHashMap();
    }
}

