/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl.executor;

import javax.ws.rs.ForbiddenException;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.youtrack.commands.impl.executor.BaseCommandExecutor;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.persistent.XdIssueTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.jetbrains.annotations.NotNull;
import webr.framework.function.HtmlStringUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/commands/impl/executor/AddNewTagCommandExecutor;", "Ljetbrains/youtrack/commands/impl/executor/BaseCommandExecutor;", "tagName", "", "(Ljava/lang/String;)V", "debugDescription", "getDebugDescription", "()Ljava/lang/String;", "newTag", "Ljetbrains/youtrack/persistent/XdIssueTag;", "presentation", "getPresentation", "execute", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "youtrack-commands"})
public final class AddNewTagCommandExecutor
extends BaseCommandExecutor {
    private XdIssueTag newTag;
    private final String tagName;

    public void execute(@NotNull XdIssue issue) {
        XdIssueTag tag;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        if (BeansKt.getXdLoggedInUser().hasPermission(Permission.CREATE_WATCH_FOLDER)) {
            XdIssueTag xdIssueTag = this.newTag;
            if (xdIssueTag == null && (xdIssueTag = XdIssueTag.Companion.findOrCreate(BeansKt.getXdLoggedInUser(), this.tagName)) == null) {
                Intrinsics.throwNpe();
            }
            if (!(tag = xdIssueTag).isNew() && Intrinsics.areEqual((Object)jetbrains.charisma.persistent.issueFolders.BeansKt.getStarService().getStarName(), (Object)tag.getName()) ^ true) {
                throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("AddNewTagCommandExecutor.You_don_t_have_a_permission_to_add_tag_to_all_selected_issues", new Object[0]));
            }
        } else {
            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("AddNewTagCommandExecutor.You_have_no_rights_to_create_new_tag", new Object[0]));
        }
        XdIssueExtKt.getTags((XdIssue)issue).add((XdEntity)tag);
    }

    @NotNull
    public String getDebugDescription() {
        return this.tagName;
    }

    @NotNull
    public String getPresentation() {
        String string = jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("AddNewTagCommandExecutor.Add_new_tag_{0}", new Object[]{"<span class=\"bold\">" + HtmlStringUtil.html((Object)this.getDebugDescription()) + "</span>"});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026n)}</span>\"\n            )");
        return string;
    }

    public AddNewTagCommandExecutor(@NotNull String tagName) {
        Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
        this.tagName = tagName;
    }
}

