/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.impl.executor;

import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.commands.impl.executor.BaseCommandExecutor;
import jetbrains.youtrack.commands.impl.executor.LinkCommandExecutorKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import webr.framework.function.HtmlStringUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/commands/impl/executor/RemoveLinkCommandExecutor;", "Ljetbrains/youtrack/commands/impl/executor/BaseCommandExecutor;", "ctx", "Ljetbrains/youtrack/api/context/IContext;", "linkPrototype", "Ljetbrains/youtrack/persistent/XdIssueLinkPrototype;", "outward", "", "linked", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "(Ljetbrains/youtrack/api/context/IContext;Ljetbrains/youtrack/persistent/XdIssueLinkPrototype;ZLjetbrains/youtrack/core/persistent/issue/XdIssue;)V", "debugDescription", "", "getDebugDescription", "()Ljava/lang/String;", "presentation", "getPresentation", "execute", "", "issue", "youtrack-commands"})
public final class RemoveLinkCommandExecutor
extends BaseCommandExecutor {
    private final IContext ctx;
    private final XdIssueLinkPrototype linkPrototype;
    private final boolean outward;
    private final XdIssue linked;

    public void execute(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        if (this.outward) {
            this.linkPrototype.unlink(issue, this.linked);
        } else {
            this.linkPrototype.unlink(this.linked, issue);
        }
    }

    @NotNull
    public String getDebugDescription() {
        return this.linkPrototype.getRoleName(this.outward);
    }

    @NotNull
    public String getPresentation() {
        Iterable issues = this.ctx.getSelectedIssues();
        int issuesSize = CollectionUtilKt.getSize((Iterable)issues);
        String linkedIssueRef = LinkCommandExecutorKt.getReference(this.linked);
        String linkName = "<span class=\"bold\">" + HtmlStringUtil.html((Object)this.linkPrototype.getRoleName(this.outward)) + "</span>";
        if (issuesSize > 1) {
            String string = BeansKt.getLocalizer().localizedMsg("RemoveLinkCommandExecutor.Remove_{count}_issues_{relates_to}_{issue}", new Object[]{issuesSize, linkName, linkedIssueRef});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026ssueRef\n                )");
            return string;
        }
        XdIssue i = (XdIssue)CollectionsKt.first((Iterable)issues);
        if (i.isDraft()) {
            String string = BeansKt.getLocalizer().localizedMsg("RemoveLinkCommandExecutor.Remove_new_issue_{relates_to}_{issue}", new Object[]{linkName, linkedIssueRef});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026Ref\n                    )");
            return string;
        }
        String string = BeansKt.getLocalizer().localizedMsg("RemoveLinkCommandExecutor.Remove_{issue}_{relates_to}_{issue}", new Object[]{i.getIdReadable(), linkName, linkedIssueRef});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026Ref\n                    )");
        return string;
    }

    public RemoveLinkCommandExecutor(@NotNull IContext ctx, @NotNull XdIssueLinkPrototype linkPrototype, boolean outward, @NotNull XdIssue linked) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)linkPrototype, (String)"linkPrototype");
        Intrinsics.checkParameterIsNotNull((Object)linked, (String)"linked");
        this.ctx = ctx;
        this.linkPrototype = linkPrototype;
        this.outward = outward;
        this.linked = linked;
    }
}

