/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.commands.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.CompositeLocalizationObject;
import jetbrains.mps.internationalization.runtime.IdentityLocalizationObject;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.commands.ICommand;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.workflow.configuration.IssueProjectChangeListener;
import jetbrains.youtrack.context.Context;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiJsDocIgnore;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0007\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"applyCommand", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "command", "", "runAs", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "youtrack-commands"})
public final class CommandsWorkflowExtensionsKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsDocIgnore
    public static final void applyCommand(@NotNull XdIssue $this$applyCommand, @ApiDoc(value="The command that is applied to the issue") @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)$this$applyCommand, (String)"$this$applyCommand");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Entity entity = BeansKt.getCurrentUser().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
        CommandsWorkflowExtensionsKt.applyCommand($this$applyCommand, command, (XdUser)XdExtensionsKt.toXd((Entity)entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Applies a command to the issue.")
    public static final void applyCommand(@NotNull XdIssue $this$applyCommand, @ApiDoc(value="The command that is applied to the issue.") @NotNull String command, @ApiDoc(value="Specifies the user by which the command is applied. If this parameter is not set, the command is applied on behalf of the current user.") @NotNull XdUser runAs2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$applyCommand, (String)"$this$applyCommand");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)runAs2, (String)"runAs");
        XdProject project = $this$applyCommand.getProject();
        try {
            jetbrains.youtrack.core.security.BeansKt.getPrincipalManager().setTemporaryServerPrincipal((Object)runAs2.getEntity());
            Context context2 = new Context();
            context2.setSelectedIssues((Iterable)CollectionsKt.listOf((Object)$this$applyCommand));
            ICommandList commandList = jetbrains.youtrack.api.commands.BeansKt.getCommandService().parse(command, (IContext)context2);
            if (commandList.hasErrors()) {
                void $this$filterTo$iv$iv;
                CompositeLocalizationObject errors = new CompositeLocalizationObject();
                IdentityLocalizationObject newLine = new IdentityLocalizationObject("\n");
                errors.append((Localization)new LocalizationObject("WF_Commands.Command_{0}_is_invalid", new Object[]{command}));
                errors.append((Localization)newLine);
                Iterable $this$filter$iv = commandList.getCommands();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ICommand it = (ICommand)element$iv$iv;
                    boolean bl = false;
                    if (!it.isError()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ICommand it = (ICommand)element$iv;
                    boolean bl = false;
                    errors.append((Localization)new LocalizationObject("WF_Commands.Unknown_command_{0}", new Object[]{StringEscapeUtils.escapeHtml((String)it.getText())}));
                    errors.append((Localization)newLine);
                }
                throw (Throwable)new LocalizedLogicException((Localization)errors);
            }
            commandList.execute(false);
        }
        finally {
            jetbrains.youtrack.core.security.BeansKt.getPrincipalManager().unsetTemporaryServerPrincipal();
        }
        if (Intrinsics.areEqual((Object)project, (Object)$this$applyCommand.getProject()) ^ true) {
            String name$iv = "workflowIssueProjectChangeListener";
            boolean $i$f$getBean = false;
            Object object = ServiceLocator.getBean((String)name$iv);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.workflow.configuration.IssueProjectChangeListener");
            }
            ((IssueProjectChangeListener)object).projectChanged($this$applyCommand.getEntity());
        }
    }
}

