/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.dates;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0015\u0010\t\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\n\u001a\u0015\u0010\u000b\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\n\u001a%\u0010\f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"getDateFinishInTimezone", "", "time", "zone", "Lorg/joda/time/DateTimeZone;", "getDateStartInTimezone", "getSameDateStartInUTC", "isDateFinishInUTC", "", "isDateMiddleInUTC", "(Ljava/lang/Long;)Z", "isDateStartInUTC", "shiftTimeToZone", "from", "to", "(Ljava/lang/Long;Lorg/joda/time/DateTimeZone;Lorg/joda/time/DateTimeZone;)J", "youtrack-core"})
public final class DateMathKt {
    public static final long getDateStartInTimezone(long time, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        DateTime dateTime = new DateTime(time, zone).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, zone).withTimeAtStartOfDay()");
        return dateTime.getMillis();
    }

    public static final long getDateFinishInTimezone(long time, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        DateTime dateTime = new DateTime(time, zone).withTimeAtStartOfDay().plusDays(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, zone).wit\u2026tStartOfDay().plusDays(1)");
        return dateTime.getMillis() - 1L;
    }

    public static final long shiftTimeToZone(@Nullable Long time, @NotNull DateTimeZone from, @NotNull DateTimeZone to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        DateTime dateTime = new DateTime((Object)time, from).withZoneRetainFields(to);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, from).withZoneRetainFields(to)");
        return dateTime.getMillis();
    }

    public static final long getSameDateStartInUTC(long time, @NotNull DateTimeZone zone) {
        Intrinsics.checkParameterIsNotNull((Object)zone, (String)"zone");
        long dayStartInUserTimeZone = DateMathKt.getDateStartInTimezone(time, zone);
        Long l = dayStartInUserTimeZone;
        DateTimeZone dateTimeZone = DateTimeZone.UTC;
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone, (String)"DateTimeZone.UTC");
        return DateMathKt.shiftTimeToZone(l, zone, dateTimeZone);
    }

    public static final boolean isDateStartInUTC(@Nullable Long time) {
        DateTime dateTime = new DateTime((Object)time, DateTimeZone.UTC).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, DateTimeZ\u2026C).withTimeAtStartOfDay()");
        Long l = time;
        return l != null && dateTime.getMillis() == l.longValue();
    }

    public static final boolean isDateMiddleInUTC(@Nullable Long time) {
        DateTime dateTime = new DateTime((Object)time, DateTimeZone.UTC).withTime(12, 0, 0, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, DateTimeZ\u2026TC).withTime(12, 0, 0, 0)");
        Long l = time;
        return l != null && dateTime.getMillis() == l.longValue();
    }

    public static final boolean isDateFinishInUTC(long time) {
        DateTime dateTime = new DateTime(time, DateTimeZone.UTC).plusDays(1).withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(time, DateTimeZ\u20261).withTimeAtStartOfDay()");
        return dateTime.getMillis() == time - 1L;
    }
}

