/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.issue.IssueKeyImpl;
import webr.framework.controller.BaseApplication;

public class IssueImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Issue";
    private static final ThreadLocal<Boolean> DISABLE_UPDATE = new ThreadLocal();
    public static final ThreadLocal<Boolean> DISABLE_DUPLICATES_PROCESSING = new ThreadLocal();
    public static final String ISSUE_ID_REGEX = "[a-zA-Z0-9_]+\\-\\d+";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name2) {
        String linkName = name2;
        if ("reporter".equals(linkName)) {
            // empty if block
        }
        if ("updatedBy".equals(linkName)) {
            // empty if block
        }
        return new IncomingLinkViolation(linkName);
    }

    public boolean isPropertyRequired(String name2, Entity entity) {
        if (name2.equals("created")) {
            return !this.isDraft(entity);
        }
        if (name2.equals("numberInProject")) {
            return !this.isDraft(entity);
        }
        if (name2.equals("summary")) {
            return !this.isDraft(entity);
        }
        if (name2.equals("updated")) {
            return !this.isDraft(entity);
        }
        return false;
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return (String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"project"), (String)"shortName", String.class, null) + "-" + PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"numberInProject", Long.class, null);
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
    }

    public String getId(Entity entity) {
        StringBuilder builder = new StringBuilder();
        this.appendId(builder, entity);
        return builder.toString();
    }

    public long getPersistentLocalId(Entity entity) {
        return entity.getId().getLocalId();
    }

    public boolean isDraft(Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner"), null);
    }

    public boolean isReported(Entity entity) {
        return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDraft(entity) && !EntityOperations.isNew((Entity)entity) && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"deleted", Boolean.class, null) == false;
    }

    public boolean becomesReported(Entity entity) {
        return EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"draftOwner"), null) && (!EntityOperations.equals((Entity)QueryOperations.getFirst((Iterable)AssociationSemantics.getRemovedLinks((TransientEntity)((TransientEntity)entity), (String)"draftOwner")), null) || EntityOperations.isNew((Entity)entity));
    }

    public String getFirstId(Entity entity) {
        StringBuilder builder = new StringBuilder();
        Entity firstKey = QueryOperations.getFirst((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"projectTrace"));
        if (EntityOperations.equals((Entity)firstKey, null)) {
            this.appendId(builder, entity);
        } else {
            ((IssueKeyImpl)DnqUtils.getPersistentClassInstance((Entity)firstKey, (String)"IssueKey")).appendId(builder, firstKey);
        }
        return builder.toString();
    }

    public boolean isResolved(Entity entity) {
        return DateTimeOperations.isNotNull((Long)((Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"resolved", null)));
    }

    public boolean becomesResolved(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isResolved(entity) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"resolved");
    }

    public boolean becomesUnresolved(Entity entity) {
        return !((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isResolved(entity) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"resolved");
    }

    public Entity getDuplicateRoot(Entity entity) {
        long cluster = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"duplicateCluster", Long.class, null);
        if (cluster == 0L) {
            return null;
        }
        int typeId = entity.getId().getTypeId();
        try {
            return DnqUtils.getCurrentTransientSession().getEntity((EntityId)new PersistentEntityId(typeId, cluster - 1L));
        }
        catch (EntityRemovedInDatabaseException e) {
            return null;
        }
    }

    public boolean isSecured(Entity entity) {
        return !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedGroup")) || !QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"permittedUser"));
    }

    public String getUrl(Entity entity) {
        return ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getUrl(false, entity);
    }

    public String getUrl(boolean local, Entity entity) {
        String prefix = local && BaseApplication.isInsideRequestProcessing() ? BaseApplication.getRequest().getContextPath() : (String)PrimitiveAssociationSemantics.get((Entity)((Entity)ServiceLocator.getBean((String)"notificationsConfig")), (String)"baseUrl", String.class, null);
        if (((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).isDraft(entity)) {
            return prefix + "/newIssue?draftId=" + entity.getId();
        }
        return prefix + "/issue/" + ((IssueImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Issue")).getId(entity);
    }

    public void appendId(StringBuilder builder, Entity entity) {
        if (this.isDraft(entity)) {
            builder.append(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Issue.Draft", new Object[0]));
            return;
        }
        builder.append((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"project"), (String)"shortName", String.class, null));
        builder.append('-');
        long numberInProject = (Long)PrimitiveAssociationSemantics.get((Entity)entity, (String)"numberInProject", Long.class, null);
        if (numberInProject <= 0L) {
            builder.append("???");
        } else {
            builder.append(numberInProject);
        }
    }

    public static void setUpdateEnabled(boolean value) {
        if (value) {
            DISABLE_UPDATE.remove();
        } else {
            DISABLE_UPDATE.set(Boolean.TRUE);
        }
    }

    public static void setDuplicatesProcessingEnabled(boolean value) {
        if (value) {
            DISABLE_DUPLICATES_PROCESSING.remove();
        } else {
            DISABLE_DUPLICATES_PROCESSING.set(Boolean.TRUE);
        }
    }

    public static boolean isUpdateEnabled() {
        Boolean b = DISABLE_UPDATE.get();
        return b == null || b == false;
    }

    public static boolean isDuplicatesProcessingEnabled() {
        Boolean disabled = DISABLE_DUPLICATES_PROCESSING.get();
        return disabled == null || disabled == false;
    }
}

