/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.DirectedAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.IncomingLinkViolation;
import com.jetbrains.teamsys.dnq.database.MessageBuilder;
import java.util.Collection;
import java.util.Comparator;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.IssueFolderImpl;
import jetbrains.youtrack.core.persistent.ProjectShortNameResolver;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.PermissionAux;
import jetbrains.youtrack.core.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectImpl
extends IssueFolderImpl {
    private static String __ENTITY_TYPE__ = "Project";
    public static final Comparator<Entity> COMPARATOR = new Comparator<Entity>(){

        @Override
        public int compare(Entity p1, Entity p2) {
            String p2Name;
            String p1Name = EntityOperations.hasChanges((TransientEntity)((TransientEntity)p1), (String)"name") ? (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)p1), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) : (String)PrimitiveAssociationSemantics.get((Entity)p1, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            String string = p2Name = EntityOperations.hasChanges((TransientEntity)((TransientEntity)p2), (String)"name") ? (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)p2), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) : (String)PrimitiveAssociationSemantics.get((Entity)p2, (String)"name", String.class, (Object)IssueFolderImpl.getNullName());
            if (p1Name != null && p2Name != null) {
                return p1Name.compareTo(p2Name);
            }
            if (p1Name == null) {
                if (p2Name == null) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    };
    private static final Log securityLog = LogFactory.getLog((String)"security");
    public static final String PROJECT_SHORT_NAME_REGEX = "[a-zA-Z0-9_]+";

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name2, String shortName, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name2), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"shortName", (Comparable)((Object)shortName), String.class);
        securityLog.info((Object)("project " + name2 + " created"));
        return entity;
    }

    public IncomingLinkViolation createIncomingLinkViolation(String name2) {
        String linkName = name2;
        if ("leader".equals(linkName)) {
            return new IncomingLinkViolation(linkName){

                public Collection<String> getDescription() {
                    return this.createPerInstanceErrorMessage(new MessageBuilder(){

                        public String build(Iterable<Entity> linkedEntities, Entity entity, boolean hasMore) {
                            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ConstraintsErrorMessageUtil.leader_of_project_{project_name}_{project_short_name}", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null), PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null)});
                        }
                    });
                }
            };
        }
        return new IncomingLinkViolation(linkName);
    }

    public void destructor(final Entity entity) {
        Sequence.fromIterable((Iterable)QueryOperations.query(null, (String)"UserRole", (NodeBase)new LinkEqual("projects", entity))).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>(){

            public void visit(Entity it) {
                DirectedAssociationSemantics.removeToMany((Entity)it, (String)"projects", (Entity)entity);
                if (Sequence.fromIterable((Iterable)AssociationSemantics.getToMany((Entity)it, (String)"projects")).isEmpty()) {
                    DirectedAssociationSemantics.setToOne((Entity)it, (String)"role", null);
                    EntityOperations.remove((Entity)it);
                }
            }
        });
        securityLog.info((Object)("project " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + " deleted"));
        super.destructor(entity);
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"name", String.class, (Object)IssueFolderImpl.getNullName()) + " (" + (String)PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"shortName", String.class, null) + ")";
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)ProjectImpl.trim_60mee4_a2a1a5((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, (Object)IssueFolderImpl.getNullName()))), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"shortName", (Comparable)((Object)ProjectImpl.trim_60mee4_a2a2a5((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null))), String.class);
    }

    public long currentIssueNumber(Entity entity) {
        return PrimitiveAssociationSemantics.getSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
    }

    public void setNextIssueNumber(long next, Entity entity) {
        PrimitiveAssociationSemantics.setSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator", (long)next);
    }

    public long getNextIssueNumber(Entity entity) {
        return PrimitiveAssociationSemantics.getSequenceValue((TransientStoreSession)DnqUtils.getCurrentTransientSession(), (Entity)entity, (String)"nextNumberGenerator");
    }

    public Entity getUser(String login, Entity entity) {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)login))));
    }

    public boolean isArchived(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"archived", Boolean.class, null);
    }

    public boolean isAccessible(Operation operation, Entity user, Entity entity) {
        Permission permission;
        if (EntityOperations.isNew((Entity)entity)) {
            return true;
        }
        boolean result2 = operation == Operation.READ ? ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, Permission.READ_PROJECT_BASIC, entity) || ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, Permission.READ_PROJECT, entity) : (operation == Operation.SHARE ? false : ((permission = ((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission("Project", operation)) != null ? ((Security)ServiceLocator.getBean((String)"security")).hasPermission(user, permission, entity) : false));
        return result2;
    }

    public String getKey(Entity entity) {
        return (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"shortName", String.class, null);
    }

    public static Entity constructor(String name2, String shortName) {
        return ((ProjectImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name2, shortName, __ENTITY_TYPE__);
    }

    public static Entity findProject(String shortName) {
        if (shortName == null) {
            return null;
        }
        return ((ProjectShortNameResolver)ServiceLocator.getBean((String)"projectShortNameResolver")).resolveByShortName(shortName);
    }

    public static Entity findByName(String name2) {
        if (name2 == null) {
            return null;
        }
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"Project", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name2))));
    }

    @Nullable
    public static Entity findReadableProject(@Nullable String shortName, @NotNull Entity forUser) {
        if (shortName == null) {
            return null;
        }
        Entity project2 = ProjectImpl.findProject(shortName);
        if (EntityOperations.equals((Entity)project2, null)) {
            return null;
        }
        if (!((Security)ServiceLocator.getBean((String)"security")).hasPermission(forUser, Permission.READ_PROJECT_BASIC, project2)) {
            throw new SecurityException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("Project.Project_with_key_{0}_is_not_found", new Object[]{shortName}));
        }
        return project2;
    }

    public static String trim_60mee4_a2a1a5(String str) {
        return str == null ? null : str.trim();
    }

    public static String trim_60mee4_a2a2a5(String str) {
        return str == null ? null : str.trim();
    }
}

