/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.persistent;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.Set;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.SortByProperty;
import jetbrains.exodus.query.UnaryNot;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.userManagement.runtime.user.BaseUserImpl;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.UserGroupImpl;
import jetbrains.youtrack.core.persistent.UserGroupRootImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.PermissionAux;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.core.user.UserRegistrationHandlers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;

public class UserImpl
extends BaseUserImpl {
    private static String __ENTITY_TYPE__ = "User";
    public static final String GUEST_LOGIN = "guest";
    public static final String VOTED_ISSUES_VIEW_NAME = "Voted Issues";
    private static final Log securityLog = LogFactory.getLog((String)"security");

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        this.register(entity);
        return entity;
    }

    protected Entity _constructor(String login, String _entityType_) {
        Entity entity = this._constructor(login, false, _entityType_);
        return entity;
    }

    protected Entity _constructor(String login, boolean allowBanned, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)login), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)"");
        this.register(entity);
        return entity;
    }

    protected Entity _constructor(boolean fake, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        return entity;
    }

    protected Entity _constructor(String login, String email, String password, String name2, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)login), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"email", (Comparable)((Object)email), String.class);
        PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)password);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", name2 != null && name2.length() > 0 ? name2 : null, String.class);
        return entity;
    }

    public void destructor(Entity entity) {
        if (!EntityOperations.isNew((Entity)entity)) {
            securityLog.info((Object)("user " + this.getVisibleNameWithLogin(entity) + " deleted"));
        }
        super.destructor(entity);
    }

    public String getDisplayName(Entity entity) {
        super.getDisplayName(entity);
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.user_{user_name}", new Object[]{PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"login", String.class, (Object)"<no user>")});
    }

    public void register(Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"registered", (Comparable)Long.valueOf(System.currentTimeMillis()));
        ((UserRegistrationHandlers)ServiceLocator.getBean((String)"userRegistrationHandlers")).register(entity);
        securityLog.info((Object)("user " + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") + " created"));
    }

    public void executeBeforeFlushTrigger(Entity entity) {
        super.executeBeforeFlushTrigger(entity);
        if (!EntityOperations.isNew((Entity)entity) && UserImpl.eq_xudj6d_a0a0b0j(PrimitiveAssociationSemantics.getOldValue((TransientEntity)((TransientEntity)entity), (String)"login", String.class, (Object)"<no user>"), GUEST_LOGIN) && EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login")) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.The_operation_is_prohibited_for_guest", new Object[0]))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.The_operation_is_prohibited_for_guest", new Object[0]), (Entity)((TransientEntity)entity)));
        }
        if (!(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).isSystem(entity) || ((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).isService(entity) || LoginUtils.isValidLogin((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null))) || !EntityOperations.isNew((Entity)entity) && !EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login"))) {
            throw EntityOperations.isRemoved((Entity)entity) ? new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_user_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}))) : new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("User.{0}_is_not_a_valid_user_login", new Object[]{PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")}), (Entity)((TransientEntity)entity)));
        }
        if (EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"login") && UserImpl.isEmpty_xudj6d_a0a3a9((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>")), String.class);
        }
    }

    public long getPersistentLocalId(Entity entity) {
        return entity.getId().getLocalId();
    }

    public String getVisibleName(Entity entity) {
        return UserImpl.isEmpty_xudj6d_a0a0a11((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null)) ? (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") : (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null);
    }

    public String getVisibleNameWithLogin(Entity entity) {
        return UserImpl.isEmpty_xudj6d_a0a0a21((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null)) ? (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") : (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"fullName", String.class, null) + " (" + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, (Object)"<no user>") + ")";
    }

    public String getVisibleNameWithLoginAndEmail(Entity entity) {
        String result2 = this.getVisibleNameWithLogin(entity);
        if (UserImpl.isNotEmpty_xudj6d_a0b0n((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"email", String.class, null))) {
            result2 = result2 + ' ' + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"email", String.class, null);
        }
        return result2;
    }

    public boolean isBanned(Entity entity) {
        return (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"banned", Boolean.class, null);
    }

    public boolean bannedHasChanges(Entity entity) {
        return EntityOperations.hasChanges((TransientEntity)((TransientEntity)entity), (String)"banned");
    }

    public Iterable<Entity> getUserGroups(Entity entity) {
        return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"groups"));
    }

    public boolean hasPermission(Permission permission, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).hasPermission(entity, permission);
    }

    public boolean hasPermission(String persistentClass, Operation operation, Entity entity) {
        return this.hasPermission(((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission(persistentClass, operation), entity);
    }

    public boolean hasPermission(Permission permission, Entity project2, Entity entity) {
        return ((Security)ServiceLocator.getBean((String)"security")).hasPermission(entity, permission, project2);
    }

    public boolean hasPermission(String persistentClass, Operation operation, Entity project2, Entity entity) {
        return this.hasPermission(((PermissionAux)ServiceLocator.getBean((String)"permissionAux")).findPermission(persistentClass, operation), project2, entity);
    }

    public boolean isInGroup(String groupName, Entity entity) {
        Entity group = QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"UserGroup", (NodeBase)new PropertyEqual("name", (Comparable)((Object)groupName))));
        if (EntityOperations.equals((Entity)group, null)) {
            return false;
        }
        return this.isInGroup(group, entity);
    }

    public boolean isInGroup(Entity group, Entity entity) {
        if (EntityOperations.equals((Entity)group, null) || ((Boolean)PrimitiveAssociationSemantics.get((Entity)group, (String)"allUsersGroup", Boolean.class, null)).booleanValue()) {
            return true;
        }
        return QueryOperations.contains(((UserImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"User")).getUserGroups(entity), (Entity)group);
    }

    public Iterable<Entity> getUserGroupsExcludingAllUsersGroup(Entity entity) {
        return AssociationSemantics.getToMany((Entity)entity, (String)"groups");
    }

    public Iterable<Entity> getVisibleUserGroupsSorted(final Entity entity) {
        if (this.hasPermission(Permission.READ_USERGROUP, entity)) {
            return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)QueryOperations.query((Iterable)Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"UserGroup")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"allUsersGroup", Boolean.class, null) == false && ((UserGroupImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"UserGroup")).isAccessible(Operation.READ, entity, it);
                }
            }), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true)));
        }
        return QueryOperations.concat(UserGroupRootImpl.getAllUsersGroupSequence(), (Iterable)QueryOperations.query(this.getUserGroupsExcludingAllUsersGroup(entity), (String)"UserGroup", (NodeBase)new SortByProperty(null, "name", true)));
    }

    public boolean isGuest(Entity entity) {
        return ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"login", String.class, null)).equals(GUEST_LOGIN);
    }

    public boolean isAccessible(Operation operation, Entity forUser, Entity entity) {
        return !(!EntityOperations.equals((Entity)forUser, (Object)entity) && !((UserImpl)DnqUtils.getPersistentClassInstance((Entity)forUser, (String)"User")).hasPermission("User", operation, forUser) || operation == Operation.DELETE && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"root", Boolean.class, null) != false);
    }

    public boolean hasAccessToCommands(Entity entity) {
        return this.hasPermission(Permission.UPDATE_ISSUE, entity) || this.hasPermission(Permission.PRIVATE_UPDATE_ISSUE, entity) || this.hasPermission(Permission.CREATE_COMMENT, entity) || this.hasPermission(Permission.LINK_ISSUE, entity);
    }

    public boolean isSystem(Entity entity) {
        return false;
    }

    public boolean isService(Entity entity) {
        return false;
    }

    public static Entity constructor() {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    public static Entity constructor(String login) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, __ENTITY_TYPE__);
    }

    public static Entity constructor(String login, boolean allowBanned) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, allowBanned, __ENTITY_TYPE__);
    }

    protected static Entity constructor(boolean fake) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(fake, __ENTITY_TYPE__);
    }

    private static Entity constructor(String login, String email, String password, String name2) {
        return ((UserImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(login, email, password, name2, __ENTITY_TYPE__);
    }

    public static Entity findUser(String login) {
        if (login == null) {
            return null;
        }
        return QueryOperations.getFirst((Iterable)DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper(DnqUtils.getCurrentPersistentSession().find("User", "login", (Comparable)((Object)login))));
    }

    public static Entity findRoot() {
        return QueryOperations.getFirst((Iterable)QueryOperations.query(null, (String)"User", (NodeBase)new PropertyEqual("root", (Comparable)Boolean.TRUE)));
    }

    public static Iterable<Entity> filterBanned(Iterable<Entity> users2, boolean banned) {
        return banned ? QueryOperations.query(users2, (String)"User", (NodeBase)new PropertyEqual("banned", (Comparable)Boolean.TRUE)) : QueryOperations.query(users2, (String)"User", (NodeBase)new UnaryNot((NodeBase)new PropertyEqual("banned", (Comparable)Boolean.TRUE)));
    }

    public static Iterable<Entity> all() {
        return DnqUtils.getCurrentTransientSession().createPersistentEntityIterableWrapper(DnqUtils.getCurrentPersistentSession().getAll("User"));
    }

    protected static DnqUtils.QueryingEntityCreator getEntityCreator(String entityType, String login, String email, String password, String name2, final Set<String> queriedParams) {
        final DnqUtils.QueryingEntityCreator parent = DnqUtils.getEntityCreator((String)entityType, queriedParams);
        final String __var__login = login;
        final String __var__email = email;
        final String __var__password = password;
        final String __var__fullName = name2 != null && name2.length() > 0 ? name2 : null;
        return new DnqUtils.QueryingEntityCreator(entityType){

            public Iterable<Entity> query() {
                Iterable result2 = parent.query();
                if (queriedParams.contains("login")) {
                    result2 = QueryOperations.query((Iterable)result2, (String)"User", (NodeBase)new PropertyEqual("login", (Comparable)((Object)__var__login)));
                }
                if (queriedParams.contains("email")) {
                    result2 = QueryOperations.query((Iterable)result2, (String)"User", (NodeBase)new PropertyEqual("email", (Comparable)((Object)__var__email)));
                }
                if (queriedParams.contains("password")) {
                    result2 = QueryOperations.query((Iterable)result2, (String)"User", (NodeBase)new PropertyEqual("password", (Comparable)((Object)__var__password)));
                }
                if (queriedParams.contains("fullName")) {
                    result2 = QueryOperations.query((Iterable)result2, (String)"User", (NodeBase)new PropertyEqual("fullName", (Comparable)((Object)__var__fullName)));
                }
                return result2;
            }

            public void created(@NotNull Entity entity) {
                parent.created(entity);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"login", (Comparable)((Object)__var__login), String.class);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"email", (Comparable)((Object)__var__email), String.class);
                PrimitiveAssociationSemantics.setHashed((Entity)entity, (String)"password", (String)__var__password);
                PrimitiveAssociationSemantics.set((Entity)entity, (String)"fullName", (Comparable)((Object)__var__fullName), String.class);
            }
        };
    }

    public static Entity findOrCreate(String login, String email, String password, String name2, String[] queriedParams) {
        return UserImpl.getEntityCreator(__ENTITY_TYPE__, login, email, password, name2, BasePersistentClassImpl.buildSet((Object[])queriedParams)).create((TransientEntityStore)ServiceLocator.getBean((String)"transientEntityStore"));
    }

    private static boolean eq_xudj6d_a0a0b0j(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public static boolean isEmpty_xudj6d_a0a3a9(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_xudj6d_a0a0a11(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty_xudj6d_a0a0a21(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty_xudj6d_a0b0n(String str) {
        return str != null && str.length() > 0;
    }
}

