/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.scheduling;

import jetbrains.mps.baseLanguage.dates.runtime.CompareType;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeFieldType;

public class SchedulingOptions {
    private static final String MIN_INTERVAL_BETWEEN_CRON_JOBS_FOR_HOSTED_YOUTRACK_PROPERTY = "jetbrains.youtrack.minIntervalBetweenCronJobsForHosted";
    private static final int MIN_INTERVAL_BETWEEN_CRON_JOBS_FOR_HOSTED_YOUTRACK_DEFAULT = 600;
    private static final String MIN_INTERVAL_BETWEEN_SCHEDULE_RULES_FOR_HOSTED_YOUTRACK_PROPERTY = "jetbrains.youtrack.minIntervalBetweenScheduleRulesForHosted";
    private static final int MIN_INTERVAL_BETWEEN_SCHEDULE_RULES_FOR_HOSTED_YOUTRACK_DEFAULT = 60;
    protected static Log log = LogFactory.getLog(SchedulingOptions.class);

    public static int getMinIntervalBetweenScheduledJobsForHostedYouTrack() {
        return SchedulingOptions.getMinIntervalForHostedYouTrack(MIN_INTERVAL_BETWEEN_SCHEDULE_RULES_FOR_HOSTED_YOUTRACK_PROPERTY, 60);
    }

    public static int getMinIntervalBetweenCronJobsForHostedYouTrack() {
        return SchedulingOptions.getMinIntervalForHostedYouTrack(MIN_INTERVAL_BETWEEN_CRON_JOBS_FOR_HOSTED_YOUTRACK_PROPERTY, 600);
    }

    private static int getMinIntervalForHostedYouTrack(String parameter, int def) {
        int result2;
        block3: {
            result2 = def;
            String value = System.getProperty(parameter);
            if (value != null && value.length() > 0) {
                try {
                    result2 = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Couldn't parse parameter " + parameter + " from " + value + ", falling back to " + def), (Throwable)e);
                }
            }
        }
        return result2;
    }

    public static boolean isCronJobTooLong(Long startTime) {
        if (!SchedulingOptions.isYoutrackHosted() || DateTimeOperations.isNull((Long)startTime)) {
            return false;
        }
        long dur = (System.currentTimeMillis() - startTime) / 1000L;
        return dur > (long)SchedulingOptions.getMinIntervalBetweenCronJobsForHostedYouTrack();
    }

    public static boolean isNextCronJobAllowed(Long prevTime, int minInterval) {
        boolean allowed;
        if (!SchedulingOptions.isYoutrackHosted() || DateTimeOperations.isNull((Long)prevTime) || DateTimeOperations.compare((Long)prevTime, (CompareType)CompareType.GT, (Long)System.currentTimeMillis(), (DateTimeFieldType)DateTimeFieldType.millisOfSecond())) {
            return true;
        }
        long delta = 10L;
        long diff = (System.currentTimeMillis() - prevTime) / 1000L;
        boolean bl = allowed = diff >= (long)minInterval - delta;
        if (!allowed && log.isTraceEnabled()) {
            log.trace((Object)("The interval between two cron jobs is less than minimal accepted value: " + diff));
        }
        return allowed;
    }

    private static boolean isYoutrackHosted() {
        return Boolean.getBoolean("jetbrains.youtrack.hosted");
    }
}

