/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.security;

import java.util.HashMap;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.youtrack.core.security.DefaultRole;
import jetbrains.youtrack.core.security.Permission;

public class DefaultPermissionScheme {
    private Map<String, PermissionGroupInfo> permissionGroups = MapSequence.fromMap(new HashMap());
    private Map<String, UserInfo> users = MapSequence.fromMap(new HashMap());
    private Map<String, UserGroupInfo> userGroups = MapSequence.fromMap(new HashMap());
    private String allUsersGroupPermissionGroup;

    public void addPermissionGroup(String name2, String description, Iterable<Permission> permission) {
        MapSequence.fromMap(this.permissionGroups).put((Object)name2, (Object)new PermissionGroupInfo(description, permission));
    }

    public void addPermissionGroup(DefaultRole role) {
        MapSequence.fromMap(this.permissionGroups).put((Object)role.getName(), (Object)new PermissionGroupInfo(role.getDescription(), role.getPermissions()));
    }

    public Map<String, PermissionGroupInfo> getPermissionGroups() {
        return this.permissionGroups;
    }

    public void addUser(String login, String password, String fullName, String permissionGroup, boolean banned) {
        MapSequence.fromMap(this.users).put((Object)login, (Object)new UserInfo(password, fullName, permissionGroup, banned));
    }

    public Map<String, UserInfo> getUsers() {
        return this.users;
    }

    public void addUserGroup(String name2, String description, String permissionGroup, boolean addNewUsers) {
        MapSequence.fromMap(this.userGroups).put((Object)name2, (Object)new UserGroupInfo(description, permissionGroup, addNewUsers));
    }

    public Map<String, UserGroupInfo> getUserGroups() {
        return this.userGroups;
    }

    public void setAllUsersGroupPermissionGroup(String allUsersGroupPermissionGroup) {
        this.allUsersGroupPermissionGroup = allUsersGroupPermissionGroup;
    }

    public String getAllUsersGroupPermissionGroup() {
        return this.allUsersGroupPermissionGroup;
    }

    public class UserGroupInfo {
        private String myDescription;
        private String myPermissionGroup;
        private boolean myAddNewUsers;

        public UserGroupInfo(String description, String permissionGroup, boolean addNewUsers) {
            this.setDescription(description);
            this.setPermissionGroup(permissionGroup);
            this.setAddNewUsers(addNewUsers);
        }

        public String getDescription() {
            return this.myDescription;
        }

        private void setDescription(String value) {
            this.myDescription = value;
        }

        public String getPermissionGroup() {
            return this.myPermissionGroup;
        }

        private void setPermissionGroup(String value) {
            this.myPermissionGroup = value;
        }

        public boolean getAddNewUsers() {
            return this.myAddNewUsers;
        }

        private void setAddNewUsers(boolean value) {
            this.myAddNewUsers = value;
        }
    }

    public class UserInfo {
        private String myFullName;
        private String myPassword;
        private String myPermissionGroup;
        private boolean myBanned;

        public UserInfo(String password, String fullName, String permissionGroup, boolean banned) {
            this.setPassword(password);
            this.setPermissionGroup(permissionGroup);
            this.setFullName(fullName);
            this.setBanned(banned);
        }

        public String getFullName() {
            return this.myFullName;
        }

        private void setFullName(String value) {
            this.myFullName = value;
        }

        public String getPassword() {
            return this.myPassword;
        }

        private void setPassword(String value) {
            this.myPassword = value;
        }

        public String getPermissionGroup() {
            return this.myPermissionGroup;
        }

        private void setPermissionGroup(String value) {
            this.myPermissionGroup = value;
        }

        public boolean getBanned() {
            return this.myBanned;
        }

        private void setBanned(boolean value) {
            this.myBanned = value;
        }
    }

    public class PermissionGroupInfo {
        private String myDescription;
        private Iterable<Permission> myPermissions;

        public PermissionGroupInfo(String description, Iterable<Permission> permissions) {
            this.setDescription(description);
            this.setPermissions(permissions);
        }

        public String getDescription() {
            return this.myDescription;
        }

        private void setDescription(String value) {
            this.myDescription = value;
        }

        public Iterable<Permission> getPermissions() {
            return this.myPermissions;
        }

        private void setPermissions(Iterable<Permission> value) {
            this.myPermissions = value;
        }
    }
}

