/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.security;

import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.security.Permission;

public enum DefaultRole {
    ISSUE_READER(new Permission[]{Permission.READ_ISSUE, Permission.READ_COMMENT, Permission.READ_PROJECT_BASIC, Permission.READ_REPORT}){

        @Override
        public String getName() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.issue_reader", new Object[0]);
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.issue_reader.description", new Object[0]);
        }

        @Override
        public String getHubRoleKey() {
            return "youtrack-issue-reader";
        }
    }
    ,
    REPORTER(new Permission[]{Permission.READ_ISSUE, Permission.CREATE_ISSUE, Permission.LINK_ISSUE, Permission.CREATE_ATTACHMENT_ISSUE, Permission.CREATE_COMMENT, Permission.READ_COMMENT, Permission.UPDATE_COMMENT, Permission.DELETE_COMMENT, Permission.READ_PROFILE, Permission.UPDATE_PROFILE, Permission.READ_PROJECT_BASIC, Permission.READ_REPORT}){

        @Override
        public String getName() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.reporter", new Object[0]);
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.reporter.description", new Object[0]);
        }

        @Override
        public String getHubRoleKey() {
            return "youtrack-reporter";
        }
    }
    ,
    DEVELOPER(new Permission[]{Permission.CREATE_ATTACHMENT_ISSUE, Permission.UPDATE_ATTACHMENT_ISSUE, Permission.DELETE_ATTACHMENT_ISSUE, Permission.CREATE_COMMENT, Permission.READ_COMMENT, Permission.UPDATE_COMMENT, Permission.DELETE_COMMENT, Permission.CREATE_WATCH_FOLDER, Permission.DELETE_WATCH_FOLDER, Permission.SHARE_WATCH_FOLDER, Permission.UPDATE_WATCH_FOLDER, Permission.READ_PROFILE, Permission.UPDATE_PROFILE, Permission.READ_WORK_ITEM, Permission.UPDATE_WORK_ITEM, Permission.CREATE_WORK_ITEM, Permission.CREATE_ISSUE, Permission.UPDATE_ISSUE, Permission.DELETE_ISSUE, Permission.READ_ISSUE, Permission.PRIVATE_READ_ISSUE, Permission.PRIVATE_UPDATE_ISSUE, Permission.LINK_ISSUE, Permission.VIEW_VOTERS, Permission.VIEW_WATCHERS, Permission.UPDATE_WATCHERS, Permission.READ_USER_BASIC, Permission.READ_PROJECT_BASIC, Permission.READ_REPORT, Permission.CREATE_REPORT, Permission.SHARE_REPORT, Permission.READ_ARTICLE, Permission.CREATE_ARTICLE, Permission.READ_ARTICLE_COMMENT, Permission.CREATE_ARTICLE_COMMENT}){

        @Override
        public String getName() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.developer", new Object[0]);
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.developer.description", new Object[0]);
        }

        @Override
        public String getHubRoleKey() {
            return "developer";
        }
    }
    ,
    PROJECT_ADMIN(new Permission[]{Permission.CREATE_ATTACHMENT_ISSUE, Permission.UPDATE_ATTACHMENT_ISSUE, Permission.DELETE_ATTACHMENT_ISSUE, Permission.CREATE_COMMENT, Permission.READ_COMMENT, Permission.UPDATE_COMMENT, Permission.DELETE_COMMENT, Permission.CREATE_WATCH_FOLDER, Permission.DELETE_WATCH_FOLDER, Permission.SHARE_WATCH_FOLDER, Permission.UPDATE_WATCH_FOLDER, Permission.READ_PROFILE, Permission.UPDATE_PROFILE, Permission.READ_WORK_ITEM, Permission.UPDATE_WORK_ITEM, Permission.UPDATE_NOT_OWN_WORK_ITEM, Permission.CREATE_NOT_OWN_WORK_ITEM, Permission.CREATE_WORK_ITEM, Permission.READ_USERGROUP, Permission.READ_PROJECT, Permission.UPDATE_PROJECT, Permission.UPDATE_NOT_OWN_COMMENT, Permission.DELETE_NOT_OWN_COMMENT, Permission.CREATE_ISSUE, Permission.UPDATE_ISSUE, Permission.DELETE_ISSUE, Permission.READ_ISSUE, Permission.PRIVATE_READ_ISSUE, Permission.PRIVATE_UPDATE_ISSUE, Permission.LINK_ISSUE, Permission.VIEW_VOTERS, Permission.VIEW_WATCHERS, Permission.UPDATE_WATCHERS, Permission.READ_USER_BASIC, Permission.READ_USER, Permission.READ_PROJECT_BASIC, Permission.READ_REPORT, Permission.CREATE_REPORT, Permission.SHARE_REPORT, Permission.READ_ARTICLE, Permission.CREATE_ARTICLE, Permission.UPDATE_ARTICLE, Permission.DELETE_ARTICLE, Permission.READ_ARTICLE_COMMENT, Permission.CREATE_ARTICLE_COMMENT, Permission.UPDATE_ARTICLE_COMMENT, Permission.DELETE_ARTICLE_COMMENT, Permission.APPLY_COMMANDS_SILENTLY}){

        @Override
        public String getName() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.project_admin", new Object[0]);
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.project_admin.description", new Object[0]);
        }

        @Override
        public String getHubRoleKey() {
            return "project-admin";
        }
    }
    ,
    SYSTEM_ADMIN(Permission.values()){

        @Override
        public String getName() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.admin", new Object[0]);
        }

        @Override
        public String getDescription() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("youtrack.role.admin.description", new Object[0]);
        }

        @Override
        public String getHubRoleKey() {
            return "system-admin";
        }
    };

    private Iterable<Permission> permissions;

    private DefaultRole(Permission ... permissions) {
        this.permissions = Sequence.fromArray((Object[])permissions);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getHubRoleKey();

    public Iterable<Permission> getPermissions() {
        return this.permissions;
    }
}

