/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.security;

import java.util.Arrays;
import java.util.List;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.security.Operation;

public enum Permission {
    READ_PROJECT_BASIC("Project", Operation.READ, "youtrack.permission.read_project_basic", "youtrack.permission.read_project_basic_lowercased", "youtrack.permission.View_project_basics", "jetbrains.jetpass.project-read-basic", false, new Permission[0]),
    READ_ISSUE("Issue", Operation.READ, "youtrack.permission.read_issue", "youtrack.permission.read_issue_lowercased", "youtrack.permission.View_issues_public_fields_only", false, READ_PROJECT_BASIC),
    PRIVATE_READ_ISSUE("Issue", Operation.PRIVATE_READ, "youtrack.permission.private_read_issue", "youtrack.permission.private_read_issue_lowercased", "youtrack.permission.View_issue_private_fields", false, READ_PROJECT_BASIC),
    UPDATE_ISSUE("Issue", Operation.UPDATE, "youtrack.permission.update_issue", "youtrack.permission.update_issue_lowercased", "youtrack.permission.Update_issue_s_public_fields", false, new Permission[0]),
    CREATE_ISSUE("Issue", Operation.CREATE, "youtrack.permission.create_issue", "youtrack.permission.create_issue_lowercased", "youtrack.permission.Create_new_issue", false, READ_PROJECT_BASIC),
    DELETE_ISSUE("Issue", Operation.DELETE, "youtrack.permission.delete_issue", "youtrack.permission.delete_issue_lowercased", "youtrack.permission.Delete_issues", false, new Permission[0]),
    LINK_ISSUE("Issue", Operation.LINK, "youtrack.permission.link_issue", "youtrack.permission.link_issue_lowercased", "youtrack.permission.Set_relationships_between_issues", false, new Permission[0]),
    CREATE_ATTACHMENT_ISSUE("IssueAttachment", Operation.CREATE, "youtrack.permission.create_attachment_issue", "youtrack.permission.create_attachment_issue", "youtrack.permission.Attach_files_or_screenshots_to_issues", false, new Permission[0]),
    UPDATE_ATTACHMENT_ISSUE("IssueAttachment", Operation.UPDATE, "youtrack.permission.update_attachment_issue", "youtrack.permission.update_attachment_issue_lowercased", "youtrack.permission.Modify_files_attached_to_issue_and_modify_attachment_visibility", false, new Permission[0]),
    DELETE_ATTACHMENT_ISSUE("IssueAttachment", Operation.DELETE, "youtrack.permission.delete_attachment_issue", "youtrack.permission.delete_attachment_issue_lowercased", "youtrack.permission.Delete_files_attached_to_issues", false, new Permission[0]),
    PRIVATE_UPDATE_ISSUE("Issue", Operation.PRIVATE_UPDATE, "youtrack.permission.private_update_issue", "youtrack.permission.private_update_issue_lowercased", "youtrack.permission.Update_issue_private_fields", false, PRIVATE_READ_ISSUE),
    APPLY_COMMANDS_SILENTLY("Issue", Operation.UPDATE_SILENTLY, "youtrack.permisssion.apply_commands_silently", "youtrack.permisssion.apply_commands_silently_lowercased", "youtrack.permisssion.apply_commands_silently_description", false, new Permission[0]),
    CREATE_COMMENT("IssueComment", Operation.CREATE, "youtrack.permission.create_comment", "youtrack.permission.create_comment_lowercased", "youtrack.permission.Comment_issues", false, new Permission[0]),
    READ_COMMENT("IssueComment", Operation.READ, "youtrack.permission.read_comment", "youtrack.permission.read_comment_lowercased", "youtrack.permission.View_issues_comments", false, new Permission[0]),
    UPDATE_COMMENT("IssueComment", Operation.UPDATE, "youtrack.permission.update_comment", "youtrack.permission.update_comment_lowercased", "youtrack.permission.Edit_own_comments", false, new Permission[0]),
    DELETE_COMMENT("IssueComment", Operation.DELETE, "youtrack.permission.delete_comment", "youtrack.permission.delete_comment_lowercased", "youtrack.permission.Delete_own_comments", false, new Permission[0]),
    UPDATE_NOT_OWN_COMMENT("IssueComment", Operation.UPDATE_NOT_OWN, "youtrack.permission.update_not_own_comment", "youtrack.permission.update_not_own_comment_lowercased", "youtrack.permission.Edit_comments_posted_by_other_users", false, READ_COMMENT),
    DELETE_NOT_OWN_COMMENT("IssueComment", Operation.DELETE_NOT_OWN, "youtrack.permission.delete_not_own_comment", "youtrack.permission.delete_not_own_comment_lowercased", "youtrack.permission.Delete_comments_posted_by_other_users", false, READ_COMMENT),
    READ_HIDDEN_STUFF("Visibility", Operation.READ_HIDDEN, "youtrack.permission.read_hidden", "youtrack.permission.read_hidden_lowercased", "youtrack.permission.read_hidden_description", false, PRIVATE_READ_ISSUE),
    READ_USER_BASIC("User", Operation.READ_BASIC, "youtrack.permission.read_user_basic", "youtrack.permission.read_user_basic_lowercased", "youtrack.permission.Read_user_login_name_and_email", "jetbrains.jetpass.user-read-basic", true, new Permission[0]),
    READ_USER("User", Operation.READ, "youtrack.permission.read_user", "youtrack.permission.read_user_lowercased", "youtrack.permission.View_the_list_of_registered_user_accounts_and_their_access_rights", "jetbrains.jetpass.user-read", true, new Permission[0]),
    UPDATE_USER("User", Operation.UPDATE, "youtrack.permission.update_user", "youtrack.permission.update_user_lowercased", "youtrack.permission.Modify_roles_and_group_memberships_for_user_accounts_ban_and_merge_user_accounts", "jetbrains.jetpass.user-update", true, new Permission[0]),
    CREATE_USER("User", Operation.CREATE, "youtrack.permission.create_user", "youtrack.permission.create_user_lowercased", "youtrack.permission.Create_new_user", "jetbrains.jetpass.user-create", true, new Permission[0]),
    DELETE_USER("User", Operation.DELETE, "youtrack.permission.delete_user", "youtrack.permission.delete_user_lowercased", "youtrack.permission.Delete_user_accounts", "jetbrains.jetpass.user-delete", true, new Permission[0]),
    READ_ROLE("Role", Operation.READ, "youtrack.permission.read_role", "youtrack.permission.read_role_lowercased", "youtrack.permission._View_the_list_of_roles", "jetbrains.jetpass.role-read", true, new Permission[0]),
    UPDATE_ROLE("Role", Operation.UPDATE, "youtrack.permission.update_role", "youtrack.permission.update_role_lowercased", "youtrack.permission.Modify_role_properties", "jetbrains.jetpass.role-update", true, new Permission[0]),
    CREATE_ROLE("Role", Operation.CREATE, "youtrack.permission.create_role", "youtrack.permission.create_role_lowercased", "youtrack.permission._Create_new_role", "jetbrains.jetpass.role-create", true, new Permission[0]),
    DELETE_ROLE("Role", Operation.DELETE, "youtrack.permission.delete_role", "youtrack.permission.delete_role_lowercased", "youtrack.permission.Delete_role", "jetbrains.jetpass.role-delete", true, new Permission[0]),
    CREATE_PROJECT("Project", Operation.CREATE, "youtrack.permission.create_project", "youtrack.permission.create_project_lowercased", "youtrack.permission.Create_new_project", "jetbrains.jetpass.project-create", true, new Permission[0]),
    READ_PROJECT("Project", Operation.READ, "youtrack.permission.read_project", "youtrack.permission.read_project_lowercased", "youtrack.permission.View_project_properties", "jetbrains.jetpass.project-read", false, new Permission[0]),
    UPDATE_PROJECT("Project", Operation.UPDATE, "youtrack.permission.update_project", "youtrack.permission.update_project_lowercased", "youtrack.permission.Edit_project_properties_Unlocks_Silent_Apply_button_in_command_dialog", "jetbrains.jetpass.project-update", false, new Permission[0]),
    DELETE_PROJECT("Project", Operation.DELETE, "youtrack.permission.delete_project", "youtrack.permission.delete_project_lowercased", "youtrack.permission.Delete_project", "jetbrains.jetpass.project-delete", false, new Permission[0]),
    ADMIN_READ_APP("ApplicationMetaData", Operation.ADMIN, "youtrack.permission.admin_read_app", "youtrack.permission.admin_read_app_lowercased", "youtrack.permission.admin_read_app", "jetbrains.jetpass.low-level-read", true, new Permission[0]),
    ADMIN_UPDATE_APP("ApplicationMetaData", Operation.ADMIN, "youtrack.permission.admin_app", "youtrack.permission.admin_app_lowercased", "youtrack.permission.Manage_low-level_administrative_actions_like_integrations_with_third-party_services_and_database_backup", "jetbrains.jetpass.low-level", true, new Permission[0]),
    READ_PROFILE("UserProfile", Operation.READ, "youtrack.permission.read_profile", "youtrack.permission.read_profile_lowercased", "youtrack.permission.View_own_profile", "jetbrains.jetpass.profile-readSelf", true, new Permission[0]),
    UPDATE_PROFILE("UserProfile", Operation.UPDATE, "youtrack.permission.update_profile", "youtrack.permission.update_profile_lowercased", "youtrack.permission.Update_own_profile", "jetbrains.jetpass.profile-updateSelf", true, new Permission[0]),
    CREATE_WATCH_FOLDER("WatchFolder", Operation.CREATE, "youtrack.permission.create_watch_folder", "youtrack.permission.create_watch_folder_lowercased", "youtrack.permission.Create_tag_or_saved_search", false, new Permission[0]),
    UPDATE_WATCH_FOLDER("WatchFolder", Operation.UPDATE, "youtrack.permission.update_watch_folder", "youtrack.permission.update_watch_folder_lowercased", "youtrack.permission.Allows_editing_shared_tag_or_saved_search_if_user_belongs_to_shared_group", false, new Permission[0]),
    DELETE_WATCH_FOLDER("WatchFolder", Operation.DELETE, "youtrack.permission.delete_watch_folder", "youtrack.permission.delete_watch_folder_lowercased", "youtrack.permission.Delete_own_tag_or_saved_search", false, new Permission[0]),
    SHARE_WATCH_FOLDER("WatchFolder", Operation.SHARE, "youtrack.permission.share_watch_folder", "youtrack.permission.share_watch_folder_lowercased", "youtrack.permission.Share_own_tag_or_saved_search_for_other_users", false, new Permission[0]),
    READ_USERGROUP("UserGroup", Operation.READ, "youtrack.permission.read_usergroup", "youtrack.permission.read_usergroup_lowercased", "youtrack.permission._View_the_list_of_user_groups", "jetbrains.jetpass.group-read", false, new Permission[0]),
    CREATE_USERGROUP("UserGroup", Operation.CREATE, "youtrack.permission.create_usergroup", "youtrack.permission.create_usergroup_lowercased", "youtrack.permission._Create_new_user_groups", "jetbrains.jetpass.group-create", false, new Permission[0]),
    UPDATE_USERGROUP("UserGroup", Operation.UPDATE, "youtrack.permission.update_usergroup", "youtrack.permission.update_usergroup_lowercased", "youtrack.permission.Modify_properties_of_user_groups", "jetbrains.jetpass.group-update", false, new Permission[0]),
    DELETE_USERGROUP("UserGroup", Operation.DELETE, "youtrack.permission.delete_usergroup", "youtrack.permission.delete_usergroup_lowercased", "youtrack.permission.Delete_user_groups", "jetbrains.jetpass.group-delete", false, new Permission[0]),
    VIEW_WATCHERS("Issue", Operation.VIEW_WATCHERS, "youtrack.permission.view_watchers", "youtrack.permission.view_watchers_lowercased", "youtrack.permission.View_the_list_of_users_who_are_watching_an_issue_available_in_full_issue_view", false, READ_PROJECT_BASIC),
    UPDATE_WATCHERS("Issue", Operation.UPDATE_WATCHES, "youtrack.permission.update_watchers", "youtrack.permission.update_watchers_lowercased", "youtrack.permission.Set_another_user_as_a_watcher_for_an_issue", false, new Permission[0]),
    VIEW_VOTERS("Issue", Operation.VIEW_VOTERS, "youtrack.permission.view_voters", "youtrack.permission.view_voters_lowercased", "youtrack.permission.View_the_list_of_users_who_have_voted_for_an_issue_available_in_full_issue_view", false, READ_PROJECT_BASIC),
    READ_WORK_ITEM("IssueWorkItem", Operation.READ, "youtrack.permission.read_work_item", "youtrack.permission.read_work_item_lowercased", "youtrack.permission.View_issue_work_items", false, new Permission[0]),
    UPDATE_WORK_ITEM("IssueWorkItem", Operation.UPDATE, "youtrack.permission.update_work_item", "youtrack.permission.update_work_item_lowercased", "youtrack.permission.Add_and_edit_work_items", false, new Permission[0]),
    UPDATE_NOT_OWN_WORK_ITEM("IssueWorkItem", Operation.UPDATE_NOT_OWN, "youtrack.permission.update_not_own_work_item", "youtrack.permission.update_not_own_work_item_lowercased", "youtrack.permission.Edit_work_items_created_by_other_users", false, READ_WORK_ITEM, UPDATE_WORK_ITEM),
    CREATE_WORK_ITEM("IssueWorkItem", Operation.CREATE, "youtrack.permission.create_work_item", "youtrack.permission.create_work_item_lowercased", "youtrack.permission.Create_work_items", false, new Permission[0]),
    CREATE_NOT_OWN_WORK_ITEM("IssueWorkItem", Operation.CREATE_NOT_OWN, "youtrack.permission.create_not_own_work_item", "youtrack.permission.create_not_own_work_item_lowercased", "youtrack.permission.Create_work_items_for_other_users", false, CREATE_WORK_ITEM),
    READ_REPORT("Report", Operation.READ, "youtrack.permission.read_report", "youtrack.permission.read_report_lowercased", "youtrack.permission.read_report_description", false, new Permission[0]),
    CREATE_REPORT("Report", Operation.CREATE, "youtrack.permission.create_report", "youtrack.permission.create_report_lowercased", "youtrack.permission.create_report_description", false, READ_REPORT),
    SHARE_REPORT("Report", Operation.SHARE, "youtrack.permission.share_report", "youtrack.permission.share_report_lowercased", "youtrack.permission.share_report_description", false, READ_REPORT),
    READ_ARTICLE("Article", Operation.READ, "youtrack.permission.read_article", "youtrack.permission.read_article_lowercase", "youtrack.permission.read_article_description", false, new Permission[0]),
    CREATE_ARTICLE("Article", Operation.CREATE, "youtrack.permission.create_article", "youtrack.permission.create_article_lowercase", "youtrack.permission.create_article_description", false, READ_ARTICLE),
    UPDATE_ARTICLE("Article", Operation.UPDATE_NOT_OWN, "youtrack.permission.update_article", "youtrack.permission.update_article_lowercase", "youtrack.permission.update_article_description", false, READ_ARTICLE),
    DELETE_ARTICLE("Article", Operation.DELETE_NOT_OWN, "youtrack.permission.delete_article", "youtrack.permission.delete_article_lowercase", "youtrack.permission.delete_article_description", false, READ_ARTICLE),
    READ_ARTICLE_COMMENT("ArticleComment", Operation.READ, "youtrack.permission.read_article_comment", "youtrack.permission.read_article_comment_lowercase", "youtrack.permission.read_article_comment_description", false, READ_ARTICLE),
    CREATE_ARTICLE_COMMENT("ArticleComment", Operation.CREATE, "youtrack.permission.create_article_comment", "youtrack.permission.create_article_comment_lowercase", "youtrack.permission.create_article_comment_description", false, READ_ARTICLE_COMMENT),
    UPDATE_ARTICLE_COMMENT("ArticleComment", Operation.UPDATE_NOT_OWN, "youtrack.permission.update_article_comment", "youtrack.permission.update_article_comment_lowercase", "youtrack.permission.update_article_comment_description", false, READ_ARTICLE_COMMENT),
    DELETE_ARTICLE_COMMENT("ArticleComment", Operation.DELETE_NOT_OWN, "youtrack.permission.delete_article_comment", "youtrack.permission.delete_article_comment_lowercase", "youtrack.permission.delete_article_comment_description", false, READ_ARTICLE_COMMENT),
    READ_SERVICE("Service", Operation.READ, "youtrack.permission.read_service", "youtrack.permission.read_service_lowercased", "youtrack.permission.View_the_list_of_services", "jetbrains.jetpass.service-read", true, new Permission[0]),
    UPDATE_SERVICE("Service", Operation.UPDATE, "youtrack.permission.update_service", "youtrack.permission.update_service_lowercased", "youtrack.permission.Edit_service_properties", "jetbrains.jetpass.service-update", true, new Permission[0]),
    CREATE_SERVICE("Service", Operation.CREATE, "youtrack.permission.create_service", "youtrack.permission.create_service_lowercased", "youtrack.permission.Register_new_services", "jetbrains.jetpass.service-create", true, new Permission[0]),
    DELETE_SERVICE("Service", Operation.DELETE, "youtrack.permission.delete_service", "youtrack.permission.delete_service_lowercased", "youtrack.permission.Delete_services", "jetbrains.jetpass.service-delete", true, new Permission[0]);

    private static final String KEY_PREFIX = "JetBrains.YouTrack.";
    private Operation operation;
    private final String persistentClass;
    private String localizationId;
    private String localizationIdForLowercased;
    private String localizationIdForDescription;
    private String permissionKey;
    private boolean global;
    private List<Permission> impliedPermissions;

    private Permission(String klass, Operation operation, String l10nId, String l10nIdForLowercased, String l10nIdForDescription, boolean global, Permission ... impliedPermissions) {
        this(klass, operation, l10nId, l10nIdForLowercased, l10nIdForDescription, null, global, impliedPermissions);
        this.permissionKey = KEY_PREFIX + this.name();
    }

    private Permission(String klass, Operation operation, String l10nId, String l10nIdForLowercased, String l10nIdForDescription, String permissionKey, boolean global, Permission ... impliedPermissions) {
        this.operation = operation;
        this.persistentClass = klass;
        this.localizationId = l10nId;
        this.localizationIdForLowercased = l10nIdForLowercased;
        this.localizationIdForDescription = l10nIdForDescription;
        this.permissionKey = permissionKey;
        this.global = global;
        this.impliedPermissions = Arrays.asList(impliedPermissions);
    }

    public String getVisibleName() {
        return this.getHumanizedName();
    }

    public String getHumanizedName() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.localizationId, new Object[0]);
    }

    public String getLowercasedHumanizedName() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.localizationIdForLowercased, new Object[0]);
    }

    public String getHumanizedDescription() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.localizationIdForDescription, new Object[0]);
    }

    public String getPersistentClass() {
        return this.persistentClass;
    }

    public String getName() {
        return this.getHumanizedName();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getKey() {
        return this.permissionKey;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public List<Permission> getImpliedPermissions() {
        return this.impliedPermissions;
    }
}

