/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.ssl;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.ssl.StorageEntryImpl;
import jetbrains.youtrack.core.ssl.StorageImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStorageImpl
extends StorageImpl {
    private static String __ENTITY_TYPE__ = "KeyStorage";
    private static final List<String> STORE_TYPES = ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"JKS", "PKCS12"});
    protected static Log log = LogFactory.getLog(KeyStorageImpl.class);

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor("Key Storage", _entityType_);
        return entity;
    }

    public Set<Entity> importKeyStore(KeyStore src, String password, Entity entry, Entity entity) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting to import key store of type " + src.getType()));
            }
            KeyStore dest = ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).loadStore(entity);
            Enumeration<String> aliases = src.aliases();
            if (!aliases.hasMoreElements()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Attempted to import empty key store");
                }
                return SetSequence.fromSet(new HashSet());
            }
            ISetSequence imported = SetSequence.fromSet(new HashSet());
            while (aliases.hasMoreElements()) {
                String loadedAlias = aliases.nextElement();
                if (!src.isKeyEntry(loadedAlias)) continue;
                Entity newEntry = EntityOperations.equals((Entity)entry, null) ? StorageEntryImpl.constructor(loadedAlias) : entry;
                String alias = (String)PrimitiveAssociationSemantics.get((Entity)newEntry, (String)"keystoreAlias", String.class, null);
                dest.setEntry(alias, src.getEntry(loadedAlias, new KeyStore.PasswordProtection(password.toCharArray())), new KeyStore.PasswordProtection(StorageImpl.DEFAULT_PASSWORD_CHARS));
                if (log.isInfoEnabled()) {
                    log.info((Object)("'" + loadedAlias + "' key imported successfully" + (KeyStorageImpl.neq_679dj2_a0a0a0a0a0a4a1a6a0a2(alias, loadedAlias) ? " under alias " + alias : "")));
                }
                if (EntityOperations.equals((Entity)entry, null)) {
                    AggregationAssociationSemantics.createOneToMany((Entity)entity, (String)"entries", (String)"storage", (Entity)newEntry);
                } else if (!QueryOperations.isEmpty((Iterable)imported)) {
                    StorageImpl.reportException(null, (Localization)new LocalizationObject("KeyStorage.Source_keystore_contains_more_than_one_entry", new Object[0]));
                }
                SetSequence.fromSet((Set)imported).addElement((Object)newEntry);
            }
            if (!QueryOperations.isEmpty((Iterable)imported)) {
                ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).persistStore(dest, entity);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Imported " + src.getType() + " key store. Number of imported private/secret keys: " + QueryOperations.getSize((Iterable)imported)));
                }
                return imported;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Imported " + src.getType() + " key store did not contain any private/secret key."));
            }
            StorageImpl.reportException(null, (Localization)new LocalizationObject("KeyStorage.The_key_store_did_not_contain_any_private_key", new Object[0]));
            return null;
        }
        catch (Exception e) {
            StorageImpl.reportException(e, (Localization)new LocalizationObject("KeyStorage.Failed_to_import_key_store_of_type_{0}", new Object[]{src.getType()}));
            return null;
        }
    }

    public Set<Entity> importKeyStore(InputStream content, String password, Entity entry, Entity entity) {
        KeyStore src = ((KeyStorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"KeyStorage")).guessTypeAndLoad(content, password, entity);
        return ((KeyStorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"KeyStorage")).importKeyStore(src, password, entry, entity);
    }

    @Override
    public String entryDisplayName(Entity entity) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("KeyStorage.Key", new Object[0]);
    }

    private KeyStore guessTypeAndLoad(InputStream importStoreStream, String password, Entity entity) {
        importStoreStream.mark(0xA00000);
        for (String type : ListSequence.fromList(STORE_TYPES)) {
            try {
                return StorageImpl.loadFromStream(importStoreStream, type, password);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Falied to import key store of type " + type), (Throwable)e);
                }
                try {
                    importStoreStream.reset();
                }
                catch (IOException ioe) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Fail", (Throwable)ioe);
                }
            }
        }
        throw new LocalizedLogicException((Localization)new LocalizationObject("KeyStorage.Failed_to_import_key_store_unknown_type_or_other_error_See_log_files_for_more_details", new Object[0]));
    }

    public static Entity constructor() {
        return ((KeyStorageImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }

    private static boolean neq_679dj2_a0a0a0a0a0a4a1a6a0a2(Object a, Object b) {
        return !(a == null ? a == b : a.equals(b));
    }
}

