/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.ssl;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.mps.internationalization.runtime.CompositeLocalizationObject;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "Storage";
    public static final String DEFAULT_PASSWORD = "123456";
    public static final char[] DEFAULT_PASSWORD_CHARS = "123456".toCharArray();
    protected static Log log = LogFactory.getLog(StorageImpl.class);

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String name2, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"storageBytes", (InputStream)entity.getClass().getClassLoader().getResourceAsStream("jetbrains/youtrack/keystore/empty.store"));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)name2), String.class);
        return entity;
    }

    public KeyStore getStore(Entity entity) {
        return ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).loadStore(entity);
    }

    protected KeyStore loadStore(Entity entity) {
        try {
            return StorageImpl.loadFromStream(PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"storageBytes"), "JKS", DEFAULT_PASSWORD);
        }
        catch (Exception e) {
            StorageImpl.reportException(e, (Localization)new LocalizationObject("Storage.Error_initializing_a_store", new Object[0]));
            return null;
        }
    }

    public boolean isNameInUse(String name2, Entity entity) {
        return !QueryOperations.isEmpty((Iterable)QueryOperations.query((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"entries"), (String)"StorageEntry", (NodeBase)new PropertyEqual("name", (Comparable)((Object)name2))));
    }

    void removeEntry(String alias, Entity entity) {
        try {
            KeyStore store = ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).loadStore(entity);
            store.deleteEntry(alias);
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).persistStore(store, entity);
        }
        catch (KeyStoreException e) {
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).reportFailedToRemove(e, alias, entity);
        }
        catch (NoSuchAlgorithmException e) {
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).reportFailedToRemove(e, alias, entity);
        }
        catch (CertificateException e) {
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).reportFailedToRemove(e, alias, entity);
        }
        catch (IOException e) {
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).reportFailedToRemove(e, alias, entity);
        }
    }

    private void reportFailedToRemove(Exception e, String alias, Entity entity) {
        StorageImpl.reportException(e, (Localization)new LocalizationObject("Storage.Failed_to_remove_entry_under_name_{0}", new Object[]{alias}));
    }

    public String entryDisplayName(Entity entity) {
        return "";
    }

    protected void persistStore(KeyStore store, Entity entity) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        store.store(out, DEFAULT_PASSWORD_CHARS);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"storageBytes", (InputStream)in);
        in.close();
    }

    Certificate getCertificate(String alias, Entity entity) {
        KeyStore ks = ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).loadStore(entity);
        try {
            return ks.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"The keystore has not been loaded", (Throwable)e);
            }
            return null;
        }
    }

    public Iterable<Entity> getEntries(Entity entity) {
        return AssociationSemantics.getToMany((Entity)entity, (String)"entries");
    }

    protected static Entity constructor(String name2) {
        return ((StorageImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(name2, __ENTITY_TYPE__);
    }

    protected static void reportException(Exception e, Localization messagePart) {
        if (log.isErrorEnabled()) {
            log.error((Object)messagePart.getDefaultMessage(), (Throwable)e);
        }
        CompositeLocalizationObject message = new CompositeLocalizationObject();
        message.append(messagePart);
        if (e != null) {
            if (StorageImpl.isNotEmpty_9fy5xp_a0a0d0b(e.getMessage())) {
                message.append((Localization)new LocalizationObject("Storage._Reason_{0}", new Object[]{e.getMessage()}));
            }
            message.append((Localization)new LocalizationObject("Storage.See_log_files_for_more_details", new Object[0]));
        }
        throw new LocalizedLogicException((Localization)message);
    }

    protected static KeyStore loadFromStream(InputStream stream, String type, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore store = KeyStore.getInstance(type);
        store.load(stream, password.toCharArray());
        return store;
    }

    public static boolean isNotEmpty_9fy5xp_a0a0d0b(String str) {
        return str != null && str.length() > 0;
    }
}

