/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.core.ssl;

import com.jetbrains.teamsys.dnq.association.AggregationAssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.ssl.StorageEntryImpl;
import jetbrains.youtrack.core.ssl.StorageImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrustStorageImpl
extends StorageImpl {
    private static String __ENTITY_TYPE__ = "TrustStorage";
    protected static Log log = LogFactory.getLog(TrustStorageImpl.class);

    @Override
    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor("Trust Storage", _entityType_);
        return entity;
    }

    public Entity addTrustedCert(String cert, String alias, Entity storageEntry, Entity entity) {
        return this.addTrustedCert(new ByteArrayInputStream(cert.getBytes()), alias, storageEntry, entity);
    }

    @Override
    public String entryDisplayName(Entity entity) {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TrustStorage.Certificate", new Object[0]);
    }

    public Entity addTrustedCert(InputStream cert, String alias, Entity storageEntry, Entity entity) {
        try {
            KeyStore store = ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).loadStore(entity);
            if (EntityOperations.equals((Entity)storageEntry, null) && store.containsAlias(alias)) {
                throw new IllegalArgumentException(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TrustStorage.Alias_{0}_is_already_in_use", new Object[]{alias}));
            }
            Entity newEntry = EntityOperations.equals((Entity)storageEntry, null) ? StorageEntryImpl.constructor(alias) : storageEntry;
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(cert);
            store.setCertificateEntry((String)PrimitiveAssociationSemantics.get((Entity)newEntry, (String)"keystoreAlias", String.class, null), certificate);
            ((StorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"Storage")).persistStore(store, entity);
            AggregationAssociationSemantics.createOneToMany((Entity)entity, (String)"entries", (String)"storage", (Entity)newEntry);
            return newEntry;
        }
        catch (GeneralSecurityException e) {
            ((TrustStorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TrustStorage")).reportFailedToAdd(e, entity);
        }
        catch (IOException e) {
            ((TrustStorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TrustStorage")).reportFailedToAdd(e, entity);
        }
        return null;
    }

    public void addTrustedCerts(@NotNull File trustStore, @Nullable String storePassword, Entity entity) throws GeneralSecurityException, IOException {
        if (trustStore.exists()) {
            FileInputStream trustStoreStream = new FileInputStream(trustStore);
            KeyStore keystore = StorageImpl.loadFromStream(trustStoreStream, KeyStore.getDefaultType(), storePassword);
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keystore.getCertificate(alias);
                ((TrustStorageImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"TrustStorage")).addTrustedCert(new ByteArrayInputStream(certificate.getEncoded()), alias, null, entity);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Trusted certificate " + alias + " imported from auxiliary truststore " + trustStore.getAbsolutePath()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Auxiliary truststore " + trustStore.getAbsolutePath() + " does not exist, skipping"));
        }
    }

    private void reportFailedToAdd(Exception e, Entity entity) {
        StorageImpl.reportException(e, (Localization)new LocalizationObject("TrustStorage.Failed_to_add_trusted_certificate", new Object[0]));
    }

    public static Entity constructor() {
        return ((TrustStorageImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

