/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.customfields.persistence.XdCustomFieldCondition;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField$canUseSameValue$1;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField$condition$2;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField$project$2;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField$prototype$2;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.customfields.persistence.fields.XdBundle;
import jetbrains.charisma.customfields.plugin.BeansKt;
import jetbrains.charisma.customfields.plugin.XdCustomFieldType;
import jetbrains.charisma.persistence.customfields.ProjectCustomFieldImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.api.customfields.DetalizationLevel;
import jetbrains.youtrack.api.customfields.FieldColor;
import jetbrains.youtrack.api.customfields.FieldValueRenderer;
import jetbrains.youtrack.core.annotations.Access;
import jetbrains.youtrack.core.annotations.ApiClass;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiProperty;
import jetbrains.youtrack.core.annotations.ApiPropertyAccess;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.annotations.ApiSince;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.legacy.XdLegacyEntityType;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.security.Security;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.persistent.XdIssueExtKt;
import jetbrains.youtrack.refactoring.XdRefactoringKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.LinkDelegatesKt;
import kotlinx.dnq.PropertyDelegatesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.link.OnDeletePolicy;
import kotlinx.dnq.link.XdManyChildrenToParentLink;
import kotlinx.dnq.link.XdManyToOneRequiredLink;
import kotlinx.dnq.link.XdParentToOneOptionalChildLink;
import kotlinx.dnq.link.XdToOneOptionalLink;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.simple.XdMutableConstrainedProperty;
import kotlinx.dnq.simple.XdProperty;
import kotlinx.dnq.util.ReflectionUtilKt;
import kotlinx.dnq.util.XdPropertyCachedProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiClass
@ApiDoc(value="Represents a custom field that is available in a project.")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u0000 \u009a\u00012\u00020\u0001:\u0002\u009a\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010r\u001a\u00020sH\u0016J\u0012\u0010t\u001a\u00020\r2\b\b\u0001\u0010u\u001a\u000200H\u0007J\u0012\u0010v\u001a\u00020\r2\b\b\u0001\u0010u\u001a\u000200H\u0007J\b\u0010w\u001a\u00020sH\u0016J\u0012\u0010x\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u000103H\u0016J\u0018\u0010y\u001a\u00020\r2\u0006\u0010u\u001a\u0002002\u0006\u0010z\u001a\u00020@H\u0014J\b\u0010{\u001a\u00020sH\u0016J\b\u0010|\u001a\u00020sH\u0016J\u0010\u0010}\u001a\u00020\u00002\u0006\u0010J\u001a\u00020IH\u0016J\u000e\u0010~\u001a\u0002032\u0006\u0010)\u001a\u00020\u007fJ\u000f\u0010\u0080\u0001\u001a\u0002032\u0006\u0010)\u001a\u00020\u007fJ\u0013\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u007f2\u0006\u0010)\u001a\u000203H\u0016J\u0007\u0010\u0082\u0001\u001a\u00020sJ\u0007\u0010\u0083\u0001\u001a\u00020sJ\u0010\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010u\u001a\u000200J\u0010\u0010\u0086\u0001\u001a\t\u0012\u0004\u0012\u00020\u007f0\u0087\u0001H\u0016J\u000f\u0010\u0088\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0016J\u0007\u0010\u0089\u0001\u001a\u00020\u0003J\u0007\u0010\u008a\u0001\u001a\u00020\u0003J\u000f\u0010\u008b\u0001\u001a\u0002032\u0006\u0010u\u001a\u000200J\u0016\u0010\u008c\u0001\u001a\t\u0012\u0004\u0012\u0002030\u008d\u00012\u0006\u0010u\u001a\u000200J\u0019\u0010\u008e\u0001\u001a\u00020s2\u0006\u0010J\u001a\u00020I2\u0006\u0010A\u001a\u00020@H\u0004J\u001c\u0010\u008f\u0001\u001a\u00020\r2\u0007\u0010\u0090\u0001\u001a\u00020S2\n\b\u0002\u0010\u0091\u0001\u001a\u00030\u0092\u0001J$\u0010\u0093\u0001\u001a\u00020\r2\u0007\u0010\u0090\u0001\u001a\u00020S2\u0006\u0010u\u001a\u0002002\n\b\u0002\u0010\u0091\u0001\u001a\u00030\u0092\u0001J$\u0010\u0094\u0001\u001a\u00020\r2\u0007\u0010\u0090\u0001\u001a\u00020S2\u0006\u0010u\u001a\u0002002\n\b\u0002\u0010\u0091\u0001\u001a\u00030\u0092\u0001J\u0013\u0010\u0095\u0001\u001a\u00020\r2\b\b\u0001\u0010u\u001a\u000200H\u0007J\u0019\u0010\u0096\u0001\u001a\u00020s2\u0006\u0010u\u001a\u0002002\u0006\u0010z\u001a\u00020@H\u0016J\u0019\u0010\u0097\u0001\u001a\u00020\u007f2\u0006\u0010u\u001a\u0002002\b\u0010)\u001a\u0004\u0018\u000103J\u001f\u0010\u0098\u0001\u001a\u00020\u007f2\u0006\u0010u\u001a\u0002002\u000e\u0010\u0099\u0001\u001a\t\u0012\u0004\u0012\u0002030\u0087\u0001R\u001a\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR1\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b\u0015\u0010\u0016\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R/\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R+\u0010\"\u001a\u00020!2\u0006\u0010\f\u001a\u00020!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u0016\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010(\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0012R$\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u0012\"\u0004\b+\u0010\u0014R\u0012\u0010,\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0012R\u0014\u0010-\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0012R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u0002000/8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R5\u00104\u001a\u0004\u0018\u0001032\b\u0010\f\u001a\u0004\u0018\u0001038F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\b:\u0010;\u0012\u0004\b5\u0010\u0010\u001a\u0004\b6\u00107\"\u0004\b8\u00109R+\u0010<\u001a\u00020!2\u0006\u0010\f\u001a\u00020!8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b?\u0010\u0016\u001a\u0004\b=\u0010$\"\u0004\b>\u0010&R1\u0010A\u001a\u00020@2\u0006\u0010\f\u001a\u00020@8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bG\u0010H\u0012\u0004\bB\u0010\u0010\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR1\u0010J\u001a\u00020I2\u0006\u0010\f\u001a\u00020I8F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\n\u0004\bP\u0010Q\u0012\u0004\bK\u0010\u0010\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0014\u0010R\u001a\u00020S8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR+\u0010V\u001a\u0002032\u0006\u0010\f\u001a\u0002038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bY\u0010;\u001a\u0004\bW\u00107\"\u0004\bX\u00109R\u0014\u0010Z\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0012R/\u0010]\u001a\u0004\u0018\u00010\\2\b\u0010\f\u001a\u0004\u0018\u00010\\8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bb\u0010c\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u0011\u0010d\u001a\u00020e8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010gR/\u0010h\u001a\u0004\u0018\u00010\\2\b\u0010\f\u001a\u0004\u0018\u00010\\8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bk\u0010c\u001a\u0004\bi\u0010_\"\u0004\bj\u0010aR\u0014\u0010l\u001a\u00020S8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bm\u0010UR+\u0010n\u001a\u0002032\u0006\u0010\f\u001a\u0002038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bq\u0010;\u001a\u0004\bo\u00107\"\u0004\bp\u00109\u00a8\u0006\u009b\u0001"}, d2={"Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "Lkotlinx/dnq/XdEntity;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "bundle", "Ljetbrains/charisma/customfields/persistence/fields/XdBundle;", "getBundle", "()Ljetbrains/charisma/customfields/persistence/fields/XdBundle;", "bundleEntity", "getBundleEntity", "()Ljetbrains/exodus/entitystore/Entity;", "<set-?>", "", "canBeEmpty", "canBeEmpty$annotations", "()V", "getCanBeEmpty", "()Z", "setCanBeEmpty", "(Z)V", "canBeEmpty$delegate", "Lkotlinx/dnq/simple/XdProperty;", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldCondition;", "condition", "getCondition", "()Ljetbrains/charisma/customfields/persistence/XdCustomFieldCondition;", "setCondition", "(Ljetbrains/charisma/customfields/persistence/XdCustomFieldCondition;)V", "condition$delegate", "Lkotlinx/dnq/link/XdParentToOneOptionalChildLink;", "hasRunningJobs", "getHasRunningJobs", "", "int", "getInt", "()I", "setInt", "(I)V", "int$delegate", "isMulti", "value", "isPrivate", "setPrivate", "isSimple", "isUpdatable", "issuesWithValues", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getIssuesWithValues", "()Lkotlinx/dnq/query/XdQuery;", "", "nullValueText", "nullValueText$annotations", "getNullValueText", "()Ljava/lang/String;", "setNullValueText", "(Ljava/lang/String;)V", "nullValueText$delegate", "Lkotlinx/dnq/simple/XdMutableConstrainedProperty;", "ordinal", "getOrdinal", "setOrdinal", "ordinal$delegate", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "project", "project$annotations", "getProject", "()Ljetbrains/youtrack/core/persistent/issue/XdProject;", "setProject", "(Ljetbrains/youtrack/core/persistent/issue/XdProject;)V", "project$delegate", "Lkotlinx/dnq/link/XdManyChildrenToParentLink;", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "prototype", "prototype$annotations", "getPrototype", "()Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "setPrototype", "(Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;)V", "prototype$delegate", "Lkotlinx/dnq/link/XdManyToOneRequiredLink;", "readOperation", "Ljetbrains/youtrack/core/security/Operation;", "getReadOperation", "()Ljetbrains/youtrack/core/security/Operation;", "readPermissionName", "getReadPermissionName", "setReadPermissionName", "readPermissionName$delegate", "shouldSetDefaultValuesForDrafts", "getShouldSetDefaultValuesForDrafts", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "updatableBy", "getUpdatableBy", "()Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "setUpdatableBy", "(Ljetbrains/youtrack/core/persistent/user/XdUserGroup;)V", "updatableBy$delegate", "Lkotlinx/dnq/link/XdToOneOptionalLink;", "valueRenderer", "Ljetbrains/youtrack/api/customfields/FieldValueRenderer;", "getValueRenderer", "()Ljetbrains/youtrack/api/customfields/FieldValueRenderer;", "visibleTo", "getVisibleTo", "setVisibleTo", "visibleTo$delegate", "writeOperation", "getWriteOperation", "writePermissionName", "getWritePermissionName", "setWritePermissionName", "writePermissionName$delegate", "assertCanBeEdited", "", "becomesInvisibleInIssue", "issue", "becomesVisibleInIssue", "beforeFlush", "canSetValueString", "canUseSameValue", "toProject", "clearDefaults", "clearValuesSafe", "clone", "createStringFromSingleValue", "", "createStringFromValue", "createValueFromString", "deleteField", "doDelete", "getColor", "Ljetbrains/youtrack/api/customfields/FieldColor;", "getDefaultValues", "", "getOldBundle", "getProjectAsEntity", "getPrototypeAsEntity", "getValueString", "getValuesString", "", "init", "isAccessible", "operation", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "isAccessibleInIssue", "isAccessibleInIssueIgnoreCondition", "isVisibleInIssue", "moveValue", "setValueString", "setValuesString", "values", "Companion", "youtrack-custom-fields"})
public abstract class XdProjectCustomField
extends XdEntity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final XdProperty int$delegate;
    @Nullable
    private final XdMutableConstrainedProperty nullValueText$delegate;
    @NotNull
    private final XdProperty ordinal$delegate;
    @NotNull
    private final XdProperty canBeEmpty$delegate;
    @NotNull
    private final XdManyToOneRequiredLink prototype$delegate;
    @NotNull
    private final XdManyChildrenToParentLink project$delegate;
    @Nullable
    private final XdParentToOneOptionalChildLink condition$delegate;
    @NotNull
    private final XdMutableConstrainedProperty readPermissionName$delegate;
    @NotNull
    private final XdMutableConstrainedProperty writePermissionName$delegate;
    @Nullable
    private final XdToOneOptionalLink visibleTo$delegate;
    @Nullable
    private final XdToOneOptionalLink updatableBy$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "int", "getInt()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "nullValueText", "getNullValueText()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "ordinal", "getOrdinal()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "canBeEmpty", "getCanBeEmpty()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "prototype", "getPrototype()Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "project", "getProject()Ljetbrains/youtrack/core/persistent/issue/XdProject;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "condition", "getCondition()Ljetbrains/charisma/customfields/persistence/XdCustomFieldCondition;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "readPermissionName", "getReadPermissionName()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "writePermissionName", "getWritePermissionName()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "visibleTo", "getVisibleTo()Ljetbrains/youtrack/core/persistent/user/XdUserGroup;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), "updatableBy", "getUpdatableBy()Ljetbrains/youtrack/core/persistent/user/XdUserGroup;"))};
        Companion = new Companion(null);
    }

    public final int getInt() {
        return ((Number)((Object)this.int$delegate.getValue((XdEntity)this, $$delegatedProperties[0]))).intValue();
    }

    public final void setInt(int n) {
        this.int$delegate.setValue((XdEntity)this, $$delegatedProperties[0], (Comparable)Integer.valueOf(n));
    }

    @ApiProperty(access={@ApiPropertyAccess(scope=ApiScope.WORKFLOW), @ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The text that is displayed for this field when it is empty.")
    public static /* synthetic */ void nullValueText$annotations() {
    }

    @Nullable
    public final String getNullValueText() {
        return (String)this.nullValueText$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setNullValueText(@Nullable String string) {
        this.nullValueText$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    public final int getOrdinal() {
        return ((Number)((Object)this.ordinal$delegate.getValue((XdEntity)this, $$delegatedProperties[2]))).intValue();
    }

    public final void setOrdinal(int n) {
        this.ordinal$delegate.setValue((XdEntity)this, $$delegatedProperties[2], (Comparable)Integer.valueOf(n));
    }

    @ApiProperty(access={@ApiPropertyAccess(access=Access.RW, scope=ApiScope.PLUGIN)})
    @ApiDoc(value="When the field can store an empty value, this property is `true`.")
    public static /* synthetic */ void canBeEmpty$annotations() {
    }

    public final boolean getCanBeEmpty() {
        return (Boolean)this.canBeEmpty$delegate.getValue((XdEntity)this, $$delegatedProperties[3]);
    }

    public final void setCanBeEmpty(boolean bl) {
        this.canBeEmpty$delegate.setValue((XdEntity)this, $$delegatedProperties[3], (Comparable)Boolean.valueOf(bl));
    }

    @ApiProperty(access={@ApiPropertyAccess(scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The field's prototype.")
    public static /* synthetic */ void prototype$annotations() {
    }

    @NotNull
    public final XdCustomFieldPrototype getPrototype() {
        return (XdCustomFieldPrototype)this.prototype$delegate.getValue((XdEntity)this, $$delegatedProperties[4]);
    }

    public final void setPrototype(@NotNull XdCustomFieldPrototype xdCustomFieldPrototype) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdCustomFieldPrototype), (String)"<set-?>");
        this.prototype$delegate.setValue((XdEntity)this, $$delegatedProperties[4], (XdEntity)xdCustomFieldPrototype);
    }

    @ApiProperty(access={@ApiPropertyAccess(scope=ApiScope.PLUGIN)})
    @ApiDoc(value="The project that this field has been added to.")
    public static /* synthetic */ void project$annotations() {
    }

    @NotNull
    public final XdProject getProject() {
        return (XdProject)this.project$delegate.getValue((XdEntity)this, $$delegatedProperties[5]);
    }

    public final void setProject(@NotNull XdProject xdProject) {
        Intrinsics.checkParameterIsNotNull((Object)xdProject, (String)"<set-?>");
        this.project$delegate.setValue((XdEntity)this, $$delegatedProperties[5], (XdEntity)xdProject);
    }

    @Nullable
    public XdBundle<?> getBundle() {
        return null;
    }

    @Nullable
    public final XdCustomFieldCondition getCondition() {
        return (XdCustomFieldCondition)this.condition$delegate.getValue((XdEntity)this, $$delegatedProperties[6]);
    }

    public final void setCondition(@Nullable XdCustomFieldCondition xdCustomFieldCondition) {
        this.condition$delegate.setValue((XdEntity)this, $$delegatedProperties[6], (XdEntity)xdCustomFieldCondition);
    }

    @NotNull
    public final String getReadPermissionName() {
        return (String)this.readPermissionName$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    public final void setReadPermissionName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.readPermissionName$delegate.setValue((Object)this, $$delegatedProperties[7], (Object)string);
    }

    @NotNull
    public final String getWritePermissionName() {
        return (String)this.writePermissionName$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    public final void setWritePermissionName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.writePermissionName$delegate.setValue((Object)this, $$delegatedProperties[8], (Object)string);
    }

    @Nullable
    public final XdUserGroup getVisibleTo() {
        return (XdUserGroup)this.visibleTo$delegate.getValue((XdEntity)this, $$delegatedProperties[9]);
    }

    public final void setVisibleTo(@Nullable XdUserGroup xdUserGroup) {
        this.visibleTo$delegate.setValue((XdEntity)this, $$delegatedProperties[9], (XdEntity)xdUserGroup);
    }

    @Nullable
    public final XdUserGroup getUpdatableBy() {
        return (XdUserGroup)this.updatableBy$delegate.getValue((XdEntity)this, $$delegatedProperties[10]);
    }

    public final void setUpdatableBy(@Nullable XdUserGroup xdUserGroup) {
        this.updatableBy$delegate.setValue((XdEntity)this, $$delegatedProperties[10], (XdEntity)xdUserGroup);
    }

    public void beforeFlush() {
        super.beforeFlush();
        XdUserGroup xdUserGroup = this.getVisibleTo();
        if (xdUserGroup != null) {
            if (xdUserGroup.getAllUsersGroup()) {
                this.setVisibleTo(null);
            }
        }
        XdUserGroup xdUserGroup2 = this.getUpdatableBy();
        if (xdUserGroup2 != null) {
            if (xdUserGroup2.getAllUsersGroup()) {
                this.setUpdatableBy(null);
            }
        }
    }

    @NotNull
    public final Object setValueString(@NotNull XdIssue issue, @Nullable String value2) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        XdCustomFieldPrototype xdCustomFieldPrototype = this.getPrototype();
        XdIssue xdIssue = issue;
        XdProjectCustomField xdProjectCustomField = this;
        String string = value2;
        if (string == null) {
            String string2 = this.getNullValueText();
            XdProjectCustomField xdProjectCustomField2 = xdProjectCustomField;
            XdIssue xdIssue2 = xdIssue;
            XdCustomFieldPrototype xdCustomFieldPrototype2 = xdCustomFieldPrototype;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            xdCustomFieldPrototype = xdCustomFieldPrototype2;
            xdIssue = xdIssue2;
            xdProjectCustomField = xdProjectCustomField2;
            string = string4;
        }
        return xdCustomFieldPrototype.setValues(xdIssue, CollectionsKt.listOfNotNull((Object)xdProjectCustomField.createValueFromString(string)));
    }

    @NotNull
    public final String getValueString(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        String string = ((ProjectCustomFieldImpl)Companion.getMpsType(this)).getValueString(issue.getEntity(), this.getEntity());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mpsType.getValueString(issue.entity, entity)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object setValuesString(@NotNull XdIssue issue, @NotNull Iterable<String> values2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        Iterable<String> iterable = values2;
        XdIssue xdIssue = issue;
        XdCustomFieldPrototype xdCustomFieldPrototype = this.getPrototype();
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.createValueFromString(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Object it$iv$iv = object;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return xdCustomFieldPrototype.setValues(xdIssue, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getValuesString(@NotNull XdIssue issue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Iterable<Object> $this$map$iv = this.getPrototype().getValues(issue);
        boolean $i$f$map = false;
        Iterable<Object> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void value2;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = this.getValueRenderer().render((Object)value2, DetalizationLevel.PRIMITIVE);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public boolean canSetValueString(@Nullable String value2) {
        return this.getCanBeEmpty() && (value2 == null || Intrinsics.areEqual((Object)value2, (Object)this.getNullValueText()));
    }

    @Nullable
    public Object createValueFromString(@NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Object object = ((ProjectCustomFieldImpl)Companion.getMpsType(this)).createValueFromString(value2, this.getEntity());
        return object != null ? HelpersKt.toXdEntity((Object)object) : null;
    }

    @NotNull
    public final String createStringFromValue(@NotNull Object value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String string = this.getValueRenderer().render(value2, DetalizationLevel.PRIMITIVE);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"valueRenderer.render(val\u2026alizationLevel.PRIMITIVE)");
        return string;
    }

    @NotNull
    public final String createStringFromSingleValue(@NotNull Object value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        String string = this.getValueRenderer().render(value2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"valueRenderer.render(value)");
        return string;
    }

    @NotNull
    public final FieldColor getColor(@NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        FieldColor fieldColor = this.getValueRenderer().getColor(this.getPrototype().getValue(issue));
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldColor, (String)"this.valueRenderer.getCo\u2026rototype.getValue(issue))");
        return fieldColor;
    }

    public final void deleteField() {
        XdRefactoringKt.applySilently((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ XdProjectCustomField this$0;

            public final void invoke() {
                this.this$0.doDelete();
            }
            {
                this.this$0 = xdProjectCustomField;
                super(0);
            }
        }));
    }

    public void clearValuesSafe() {
        this.setCanBeEmpty(true);
        this.setNullValueText("Undefined");
        this.clearDefaults();
        LegacySupportKt.flush();
        String description = "Set null values for the field " + this.getPrototype().getName() + " in project " + this.getProject().getShortName();
        XdRefactoringKt.processInBatches$default((XdQuery)((XdQuery)this.getProject().getIssues()), (String)description, (int)0, (Function1)((Function1)new Function1<XdIssue, Unit>(this){
            final /* synthetic */ XdProjectCustomField this$0;

            public final void invoke(@NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getPrototype().setValues(it, CollectionsKt.emptyList());
            }
            {
                this.this$0 = xdProjectCustomField;
                super(1);
            }
        }), (int)2, null);
    }

    public final void doDelete() {
        this.clearValuesSafe();
        this.delete();
    }

    public void clearDefaults() {
    }

    public final boolean isAccessibleInIssue(@NotNull Operation operation, @NotNull XdIssue issue, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (!this.isVisibleInIssue(issue)) {
            return false;
        }
        return this.isAccessibleInIssueIgnoreCondition(operation, issue, user);
    }

    public static /* synthetic */ boolean isAccessibleInIssue$default(XdProjectCustomField xdProjectCustomField, Operation operation, XdIssue xdIssue, XdUser xdUser, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isAccessibleInIssue");
        }
        if ((n & 4) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return xdProjectCustomField.isAccessibleInIssue(operation, xdIssue, xdUser);
    }

    public final boolean isAccessibleInIssueIgnoreCondition(@NotNull Operation operation, @NotNull XdIssue issue, @NotNull XdUser user) {
        boolean read;
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (operation != Operation.READ && this.getHasRunningJobs()) {
            return false;
        }
        if (user.isSystem() || user.isService()) {
            return true;
        }
        boolean bl = read = operation == Operation.READ;
        if (issue.isSecured() && !XdIssueExtKt.isAccessible((XdIssue)issue, (Operation)Operation.READ, (XdUser)user)) {
            return false;
        }
        if (read) {
            return BeansKt.getCustomFieldsSecurity().getPermittedProjectCustomFieldSet(user.getEntity(), Security.CustomFieldsAccess.UNSORTED_READ_WITH_REMOVED).contains(this.getEntity());
        }
        if (Intrinsics.areEqual((Object)issue.getReporter(), (Object)user) && this.getUpdatableBy() == null) {
            return XdIssueExtKt.isAccessible((XdIssue)issue, (Operation)this.getWriteOperation(), (XdUser)user);
        }
        return BeansKt.getCustomFieldsSecurity().getPermittedProjectCustomFieldSet(user.getEntity(), Security.CustomFieldsAccess.UNSORTED_WRITE_WITH_REMOVED).contains(this.getEntity());
    }

    public static /* synthetic */ boolean isAccessibleInIssueIgnoreCondition$default(XdProjectCustomField xdProjectCustomField, Operation operation, XdIssue xdIssue, XdUser xdUser, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isAccessibleInIssueIgnoreCondition");
        }
        if ((n & 4) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return xdProjectCustomField.isAccessibleInIssueIgnoreCondition(operation, xdIssue, xdUser);
    }

    @NotNull
    public final Entity getPrototypeAsEntity() {
        Entity entity2 = this.getEntity().getLink("prototype");
        if (entity2 == null) {
            throw (Throwable)new EntityStoreException("Prototype can't be null");
        }
        return entity2;
    }

    @NotNull
    public final Entity getProjectAsEntity() {
        Entity entity2 = this.getEntity().getLink("project");
        if (entity2 == null) {
            throw (Throwable)new EntityStoreException("Project can't be null");
        }
        return entity2;
    }

    private final Operation getReadOperation() {
        Operation operation = Permission.valueOf((String)this.getReadPermissionName()).getOperation();
        Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"Permission.valueOf(readPermissionName).operation");
        return operation;
    }

    private final Operation getWriteOperation() {
        Operation operation = Permission.valueOf((String)this.getWritePermissionName()).getOperation();
        Intrinsics.checkExpressionValueIsNotNull((Object)operation, (String)"Permission.valueOf(writePermissionName).operation");
        return operation;
    }

    private final boolean getHasRunningJobs() {
        return jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobContainer().hasNotFinishedJobForEntity(this.getEntity()) || jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobContainer().hasNotFinishedJobForEntity(this.getPrototype().getEntity());
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2018.2.42312")
    @ApiDoc(value="Checks if a field is visible in the issue.\n        |\n        |@example\n        |// The following example checks the issue to see whether a conditional field with the name \"Related Activity\"\n        |// is currently visible, meaning that the conditions for showing the field have been met.\n        |// If so, the value for the field is set to \"Attendance\"\n        |\n        |action: function (ctx) {\n        |  if (ctx.RelatedActivity.isVisibleInIssue(ctx.issue)) {\n        |    ctx.issue.fields.RelatedActivity.add(ctx.RelatedActivity.Attendance);\n        |  }\n        |},\n        |requirements: {\n        |  RelatedActivity: {\n        |    name: 'Related Activity',\n        |    type: entities.EnumField.fieldType,\n        |    multi: true,\n        |    Attendance: {}\n        |  }\n        |}\n    ")
    @ApiDocReturns(value="When `true`, the condition for showing the custom field in the issue has been met. It can also mean that the field is not shown on a conditional basis and is always visible.")
    public final boolean isVisibleInIssue(@ApiDoc(value="The issue for which the condition for showing the field is checked.") @NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        XdCustomFieldCondition xdCustomFieldCondition = this.getCondition();
        return xdCustomFieldCondition != null ? xdCustomFieldCondition.isVisibleInIssue(issue) : true;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2018.2.42312")
    @ApiDoc(value="Checks if the changes that are applied in the current transaction satisfy the condition to show the custom field.")
    @ApiDocReturns(value="When `true`, the condition for showing the field is met in the current transaction.")
    public final boolean becomesVisibleInIssue(@ApiDoc(value="The issue for which the condition for showing the field is checked.") @NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        XdCustomFieldCondition xdCustomFieldCondition = this.getCondition();
        return xdCustomFieldCondition != null ? xdCustomFieldCondition.becomesVisibleInIssue(issue) : false;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2018.2.42312")
    @ApiDoc(value="Checks if the changes that are applied in the current transaction remove the condition to show the custom field.")
    @ApiDocReturns(value="When `true`, the condition for showing the field is removed in the current transaction.")
    public final boolean becomesInvisibleInIssue(@ApiDoc(value="The issue for which the condition for showing the field is checked.") @NotNull XdIssue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        XdCustomFieldCondition xdCustomFieldCondition = this.getCondition();
        return xdCustomFieldCondition != null ? xdCustomFieldCondition.becomesInvisibleInIssue(issue) : false;
    }

    public final boolean isAccessible(@NotNull Operation operation, @NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (operation != Operation.READ && !this.isUpdatable()) {
            return false;
        }
        Security.CustomFieldsAccess access = operation == Operation.READ ? Security.CustomFieldsAccess.UNSORTED_READ_WITH_REMOVED : Security.CustomFieldsAccess.UNSORTED_WRITE_WITH_REMOVED;
        return user.isSystem() || user.isService() || BeansKt.getCustomFieldsSecurity().getPermittedProjectCustomFieldSet(user.getEntity(), access).contains(this.getEntity());
    }

    public static /* synthetic */ boolean isAccessible$default(XdProjectCustomField xdProjectCustomField, Operation operation, XdUser xdUser, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isAccessible");
        }
        if ((n & 2) != 0) {
            xdUser = jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser();
        }
        return xdProjectCustomField.isAccessible(operation, xdUser);
    }

    protected boolean isUpdatable() {
        return !this.getHasRunningJobs();
    }

    public void assertCanBeEdited() {
        if (this.getHasRunningJobs()) {
            throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("ProjectCustomField.Can_t_set_value_to_field_{0}_at_this_moment_Please_try_later", new Object[]{this.getPrototype().getName()}));
        }
    }

    @NotNull
    public Iterable<Object> getDefaultValues() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public Entity getBundleEntity() {
        return null;
    }

    @NotNull
    public final FieldValueRenderer getValueRenderer() {
        String string = this.getNullValueText();
        XdCustomFieldType<?> xdCustomFieldType = this.getPrototype().getType();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        FieldValueRenderer fieldValueRenderer = xdCustomFieldType.getValueRenderer(string3);
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldValueRenderer, (String)"prototype.type.getValueR\u2026(nullValueText.orEmpty())");
        return fieldValueRenderer;
    }

    public final boolean isMulti() {
        return this.getPrototype().getType().isMultiValue();
    }

    public abstract boolean isSimple();

    public boolean getShouldSetDefaultValuesForDrafts() {
        return false;
    }

    @NotNull
    public XdProjectCustomField clone(@NotNull XdCustomFieldPrototype prototype2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        XdProjectCustomField xdProjectCustomField = prototype2.getType().getProjectCustomField(this.getProject(), prototype2);
        boolean bl = false;
        boolean bl2 = false;
        XdProjectCustomField it = xdProjectCustomField;
        boolean bl3 = false;
        it.setCanBeEmpty(this.getCanBeEmpty());
        it.setNullValueText(this.getNullValueText());
        it.setOrdinal(this.getOrdinal());
        it.setCondition(this.getCondition());
        it.setPrivate(this.isPrivate());
        it.setReadPermissionName(this.getReadPermissionName());
        it.setWritePermissionName(this.getWritePermissionName());
        it.setVisibleTo(this.getVisibleTo());
        it.setUpdatableBy(this.getUpdatableBy());
        return xdProjectCustomField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveValue(@NotNull XdIssue issue, @NotNull XdProject toProject) {
        XdProjectCustomField newProjectCustomField;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)toProject, (String)"toProject");
        if (this.canUseSameValue(issue, toProject)) return;
        XdProjectCustomField xdProjectCustomField = newProjectCustomField = XdProjectCustomFieldKt.getProjectCustomField(toProject, this.getPrototype());
        if (xdProjectCustomField != null) {
            if (!xdProjectCustomField.getCanBeEmpty()) {
                this.getPrototype().setValues(issue, newProjectCustomField.getDefaultValues());
                return;
            }
        }
        this.getPrototype().setValues(issue, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean canUseSameValue(@NotNull XdIssue issue, @NotNull XdProject toProject) {
        void value$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)toProject, (String)"toProject");
        if (Intrinsics.areEqual((Object)this.getProject(), (Object)toProject)) {
            return true;
        }
        KProperty1 kProperty1 = (KProperty1)XdProjectCustomField$canUseSameValue$1.INSTANCE;
        XdEntity xdEntity = this.getPrototype();
        XdQuery xdQuery = (XdQuery)XdProjectCustomFieldKt.getFields(toProject);
        NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProjectCustomField.class), (XdEntity)value$iv);
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase));
    }

    @Nullable
    public XdBundle<?> getOldBundle() {
        return null;
    }

    protected final void init(@NotNull XdCustomFieldPrototype prototype2, @NotNull XdProject project2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.setProject(project2);
        this.setPrototype(prototype2);
        this.setNullValueText(ProjectCustomFieldImpl.generateEmptyFieldText((Entity)prototype2.getEntity()));
        this.setCanBeEmpty(true);
        this.setPrivate(false);
        if (project2.getFieldsSorted()) {
            this.setOrdinal(XdQueryKt.size((XdQuery)((XdQuery)XdProjectCustomFieldKt.getFields(project2))));
        }
    }

    public final boolean isPrivate() {
        return Intrinsics.areEqual((Object)Permission.PRIVATE_READ_ISSUE.name(), (Object)this.getReadPermissionName()) || Intrinsics.areEqual((Object)Permission.PRIVATE_UPDATE_ISSUE.name(), (Object)this.getWritePermissionName());
    }

    public final void setPrivate(boolean value2) {
        if (value2) {
            this.setReadPermissionName(Permission.PRIVATE_READ_ISSUE.name());
            this.setWritePermissionName(Permission.PRIVATE_UPDATE_ISSUE.name());
        } else {
            this.setReadPermissionName(Permission.READ_ISSUE.name());
            this.setWritePermissionName(Permission.UPDATE_ISSUE.name());
        }
    }

    @NotNull
    public final XdQuery<XdIssue> getIssuesWithValues() {
        XdMutableQuery issues = this.getProject().getIssues();
        return XdQueryKt.exclude((XdQuery)((XdQuery)issues), this.getPrototype().getType().filterIssues((XdQuery<XdIssue>)((XdQuery)issues), this.getPrototype(), null));
    }

    /*
     * WARNING - void declaration
     */
    public XdProjectCustomField(@NotNull Entity entity2) {
        void onTargetDelete$iv;
        void onDelete$iv;
        KProperty1 oppositeLink$iv;
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        super(entity2);
        this.int$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[0]);
        this.nullValueText$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdStringProp$default((boolean)false, null, null, (int)7, null).provideDelegate((XdEntity)this, $$delegatedProperties[1]);
        this.ordinal$delegate = (XdProperty)PropertyDelegatesKt.xdIntProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[2]);
        this.canBeEmpty$delegate = (XdProperty)PropertyDelegatesKt.xdBooleanProp$default(null, null, (int)3, null).provideDelegate((XdEntity)this, $$delegatedProperties[3]);
        KProperty1 kProperty1 = XdProjectCustomField$prototype$2.INSTANCE;
        OnDeletePolicy onDeletePolicy = (OnDeletePolicy)OnDeletePolicy.CASCADE.INSTANCE;
        OnDeletePolicy onDeletePolicy2 = (OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE;
        XdProjectCustomField xdProjectCustomField = this;
        String dbPropertyName$iv = null;
        String dbOppositePropertyName$iv = null;
        XdPropertyCachedProvider xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdManyToOneRequiredLink<XdProjectCustomField, XdCustomFieldPrototype>>(oppositeLink$iv, dbPropertyName$iv, dbOppositePropertyName$iv, (OnDeletePolicy)onDelete$iv, (OnDeletePolicy)onTargetDelete$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            final /* synthetic */ String $dbOppositePropertyName;
            final /* synthetic */ OnDeletePolicy $onDelete;
            final /* synthetic */ OnDeletePolicy $onTargetDelete;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                this.$dbOppositePropertyName = string2;
                this.$onDelete = onDeletePolicy;
                this.$onTargetDelete = onDeletePolicy2;
                super(0);
            }

            @NotNull
            public final XdManyToOneRequiredLink<XdProjectCustomField, XdCustomFieldPrototype> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdCustomFieldPrototype.class));
                OnDeletePolicy onDeletePolicy = this.$onTargetDelete;
                OnDeletePolicy onDeletePolicy2 = this.$onDelete;
                String string = this.$dbOppositePropertyName;
                String string2 = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdManyToOneRequiredLink(xdEntityType2, kProperty1, string2, string, onDeletePolicy2, onDeletePolicy);
            }
        });
        xdProjectCustomField.prototype$delegate = (XdManyToOneRequiredLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[4]);
        oppositeLink$iv = XdProjectCustomField$project$2.INSTANCE;
        xdProjectCustomField = this;
        dbPropertyName$iv = null;
        xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdManyChildrenToParentLink<XdProjectCustomField, XdProject>>(oppositeLink$iv, dbPropertyName$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                super(0);
            }

            @NotNull
            public final XdManyChildrenToParentLink<XdProjectCustomField, XdProject> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdProject.class));
                String string = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdManyChildrenToParentLink(xdEntityType2, kProperty1, string);
            }
        });
        xdProjectCustomField.project$delegate = (XdManyChildrenToParentLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[5]);
        oppositeLink$iv = (KProperty1)XdProjectCustomField$condition$2.INSTANCE;
        xdProjectCustomField = this;
        dbPropertyName$iv = null;
        xdPropertyCachedProvider = new XdPropertyCachedProvider((Function0)new Function0<XdParentToOneOptionalChildLink<XdProjectCustomField, XdCustomFieldCondition>>(oppositeLink$iv, dbPropertyName$iv){
            final /* synthetic */ KProperty1 $oppositeLink;
            final /* synthetic */ String $dbPropertyName;
            {
                this.$oppositeLink = kProperty1;
                this.$dbPropertyName = string;
                super(0);
            }

            @NotNull
            public final XdParentToOneOptionalChildLink<XdProjectCustomField, XdCustomFieldCondition> invoke() {
                XdEntityType xdEntityType = ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdCustomFieldCondition.class));
                String string = this.$dbPropertyName;
                KProperty1 kProperty1 = this.$oppositeLink;
                XdEntityType xdEntityType2 = xdEntityType;
                return new XdParentToOneOptionalChildLink(xdEntityType2, kProperty1, string);
            }
        });
        xdProjectCustomField.condition$delegate = (XdParentToOneOptionalChildLink)xdPropertyCachedProvider.provideDelegate((XdEntity)this, $$delegatedProperties[6]);
        this.readPermissionName$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[7]);
        this.writePermissionName$delegate = (XdMutableConstrainedProperty)PropertyDelegatesKt.xdRequiredStringProp$default((boolean)false, (boolean)false, null, null, null, (int)31, null).provideDelegate((XdEntity)this, $$delegatedProperties[8]);
        this.visibleTo$delegate = (XdToOneOptionalLink)LinkDelegatesKt.xdLink0_1$default((XdEntityType)((XdEntityType)XdUserGroup.Companion), null, null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE), (int)6, null).provideDelegate((XdEntity)this, $$delegatedProperties[9]);
        this.updatableBy$delegate = (XdToOneOptionalLink)LinkDelegatesKt.xdLink0_1$default((XdEntityType)((XdEntityType)XdUserGroup.Companion), null, null, (OnDeletePolicy)((OnDeletePolicy)OnDeletePolicy.CLEAR.INSTANCE), (int)6, null).provideDelegate((XdEntity)this, $$delegatedProperties[10]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/charisma/customfields/persistence/XdProjectCustomField$Companion;", "Ljetbrains/youtrack/core/legacy/XdLegacyEntityType;", "Ljetbrains/charisma/persistence/customfields/ProjectCustomFieldImpl;", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "()V", "youtrack-custom-fields"})
    public static final class Companion
    extends XdLegacyEntityType<ProjectCustomFieldImpl, XdProjectCustomField> {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

