/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.simple.date;

import javax.annotation.PostConstruct;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.simple.date.AbstractDateFieldType;
import jetbrains.charisma.customfields.simple.date.DateValueRenderer;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Service;

@Service(value="dateFieldType")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0014H\u0016J'\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ljetbrains/charisma/customfields/simple/date/DateFieldType;", "Ljetbrains/charisma/customfields/simple/date/AbstractDateFieldType;", "()V", "valueType", "", "getValueType", "()Ljava/lang/String;", "getValueRenderer", "Ljetbrains/charisma/customfields/simple/date/DateValueRenderer;", "nullValueText", "normalize", "", "value", "(Ljava/lang/Long;)Ljava/lang/Long;", "setDateValue", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "prototype", "Ljetbrains/charisma/customfields/persistence/XdCustomFieldPrototype;", "Lorg/joda/time/DateTime;", "setValue", "e", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;Ljetbrains/exodus/entitystore/Entity;Ljava/lang/Long;)V", "setup", "youtrack-custom-fields"})
public class DateFieldType
extends AbstractDateFieldType {
    @PostConstruct
    public final void setup() {
        this.setName("date");
        this.setLocalizationId("youtrack.customfieldtype.date");
    }

    @Override
    @NotNull
    public String getValueType() {
        return "instant";
    }

    @Override
    @NotNull
    public DateValueRenderer getValueRenderer(@NotNull String nullValueText) {
        Intrinsics.checkParameterIsNotNull((Object)nullValueText, (String)"nullValueText");
        return new DateValueRenderer(nullValueText, this.getDateFormatters());
    }

    @Override
    public void setValue(@NotNull Entity e, @NotNull Entity prototype2, @Nullable Long value2) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)prototype2, (String)"prototype");
        super.setValue(e, prototype2, (Comparable)this.normalize(value2));
    }

    private final Long normalize(Long value2) {
        Long l = value2;
        if (l == null) {
            return null;
        }
        l.longValue();
        DateTime dateTime = new DateTime(value2.longValue()).withTime(12, 0, 0, 0).withZoneRetainFields(DateTimeZone.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(value).withTime\u2026nFields(DateTimeZone.UTC)");
        return dateTime.getMillis();
    }

    @Override
    public void setDateValue(@NotNull XdIssue issue, @NotNull XdCustomFieldPrototype prototype2, @Nullable DateTime value2) {
        DateTime dateTime;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)((Object)prototype2), (String)"prototype");
        this.setValue(issue.getEntity(), prototype2.getEntity(), (dateTime = value2) != null && (dateTime = dateTime.withZoneRetainFields(DateTimeZone.UTC)) != null && (dateTime = dateTime.withTime(12, 0, 0, 0)) != null ? Long.valueOf(dateTime.getMillis()) : null);
    }
}

