/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.customfields.simple.date;

import jetbrains.charisma.customfields.Localization;
import jetbrains.charisma.customfields.simple.common.ValueParseException;
import jetbrains.charisma.customfields.simple.date.AbstractDateValueRenderer;
import jetbrains.charisma.date.DateTimeFormatters;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0014J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/charisma/customfields/simple/date/DateTimeValueRenderer;", "Ljetbrains/charisma/customfields/simple/date/AbstractDateValueRenderer;", "nullValueText", "", "formatters", "Ljetbrains/charisma/date/DateTimeFormatters;", "(Ljava/lang/String;Ljetbrains/charisma/date/DateTimeFormatters;)V", "getFormatterForName", "Lorg/joda/time/format/DateTimeFormatter;", "formatName", "parseValue", "", "value", "youtrack-custom-fields"})
public class DateTimeValueRenderer
extends AbstractDateValueRenderer {
    private final DateTimeFormatters formatters;

    @Override
    @NotNull
    protected DateTimeFormatter getFormatterForName(@Nullable String formatName) {
        DateTimeFormatter dateTimeFormatter = this.formatters.getFormatterForName(formatName);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"formatters.getFormatterForName(formatName)");
        return dateTimeFormatter;
    }

    public final long parseValue(@NotNull String value2) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        DateTime dateTime = DateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now()");
        int year = dateTime.getYear();
        try {
            l = this.getUserFormatter().withDefaultYear(year).parseMillis(value2);
        }
        catch (IllegalArgumentException e) {
            long l2;
            try {
                l2 = this.getUserFormatter().withDefaultYear(year).withLocale(LocaleUtil.DEFAULT_LOCALE).parseMillis(value2);
            }
            catch (IllegalArgumentException e2) {
                throw (Throwable)((Object)new ValueParseException(new LocalizationObject(Localization.INSTANCE.getWrongFormat(), new Object[0]), this.formatters.getPatternForName(this.getUserFormatName())));
            }
            l = l2;
        }
        return l;
    }

    public DateTimeValueRenderer(@NotNull String nullValueText, @NotNull DateTimeFormatters formatters) {
        Intrinsics.checkParameterIsNotNull((Object)nullValueText, (String)"nullValueText");
        Intrinsics.checkParameterIsNotNull((Object)formatters, (String)"formatters");
        super(nullValueText);
        this.formatters = formatters;
    }
}

