/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.compress;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jetbrains.exodus.util.IOUtil;
import jetbrains.youtrack.event.compress.VcDiffConfig;
import jetbrains.youtrack.event.compress.VlqEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/event/compress/DiffWindowEncoder;", "Ljava/io/Closeable;", "config", "Ljetbrains/youtrack/event/compress/VcDiffConfig;", "(Ljetbrains/youtrack/event/compress/VcDiffConfig;)V", "compressedBytes", "", "compressor", "Ljava/util/zip/Deflater;", "getConfig", "()Ljetbrains/youtrack/event/compress/VcDiffConfig;", "decompressor", "Ljava/util/zip/Inflater;", "dictionaryBytes", "sourceBytes", "close", "", "decodeDiffWindow", "", "previousSource", "Ljava/io/InputStream;", "delta", "output", "Ljava/io/OutputStream;", "encodeDiffWindow", "", "source", "youtrack-events"})
public final class DiffWindowEncoder
implements Closeable {
    private final byte[] dictionaryBytes;
    private final Deflater compressor;
    private final Inflater decompressor;
    private final byte[] sourceBytes;
    private final byte[] compressedBytes;
    @NotNull
    private final VcDiffConfig config;

    public final int encodeDiffWindow(@NotNull InputStream source, @Nullable InputStream previousSource, @NotNull OutputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        int dictionarySize = previousSource == null ? 0 : IOUtil.readFully((InputStream)previousSource, (byte[])this.dictionaryBytes);
        this.compressor.reset();
        int windowSize = this.config.getWindowSize();
        int actuallyRead = IOUtil.readFully((InputStream)source, (byte[])this.sourceBytes, (int)(windowSize - dictionarySize));
        if (actuallyRead <= 0) {
            VlqEncoder.INSTANCE.writeInt(0, delta);
        } else {
            if (dictionarySize > 0) {
                this.compressor.setDictionary(this.dictionaryBytes, 0, dictionarySize);
            }
            this.compressor.setInput(this.sourceBytes, 0, actuallyRead);
            this.compressor.finish();
            int compressedSize = this.compressor.deflate(this.compressedBytes);
            VlqEncoder.INSTANCE.writeInt(compressedSize, delta);
            delta.write(this.compressedBytes, 0, compressedSize);
        }
        return actuallyRead;
    }

    public final boolean decodeDiffWindow(@Nullable InputStream previousSource, @NotNull InputStream delta, @NotNull OutputStream output) {
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        int compressedSize = VlqEncoder.INSTANCE.readInt(delta);
        if (compressedSize > 0) {
            int dictionarySize = previousSource == null ? 0 : IOUtil.readFully((InputStream)previousSource, (byte[])this.dictionaryBytes);
            this.decompressor.reset();
            try {
                if (IOUtil.readFully((InputStream)delta, (byte[])this.compressedBytes, (int)compressedSize) != compressedSize) {
                    throw (Throwable)new DataFormatException();
                }
                this.decompressor.setInput(this.compressedBytes);
                int sourceSize = this.decompressor.inflate(this.sourceBytes);
                if (dictionarySize > 0 && this.decompressor.needsDictionary()) {
                    this.decompressor.getAdler();
                    this.decompressor.setDictionary(this.dictionaryBytes, 0, dictionarySize);
                    sourceSize = this.decompressor.inflate(this.sourceBytes);
                }
                output.write(this.sourceBytes, 0, sourceSize);
            }
            catch (DataFormatException e) {
                throw (Throwable)new RuntimeException(e);
            }
        }
        return compressedSize == 0;
    }

    @Override
    public void close() {
        this.compressor.end();
        this.decompressor.end();
    }

    @NotNull
    public final VcDiffConfig getConfig() {
        return this.config;
    }

    public DiffWindowEncoder(@NotNull VcDiffConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.dictionaryBytes = new byte[this.config.getWindowSize() / 2];
        this.compressor = new Deflater(9);
        this.decompressor = new Inflater();
        this.sourceBytes = new byte[this.config.getWindowSize()];
        this.compressedBytes = new byte[this.config.getWindowSize() * 2];
    }
}

