/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.compress;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.youtrack.event.compress.DiffWindowEncoder;
import jetbrains.youtrack.event.compress.VlqEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/youtrack/event/compress/VcDiffInputStream;", "Ljava/io/InputStream;", "vcDiff", "Ljetbrains/youtrack/event/compress/DiffWindowEncoder;", "previousSource", "delta", "(Ljetbrains/youtrack/event/compress/DiffWindowEncoder;Ljava/io/InputStream;Ljava/io/InputStream;)V", "eof", "", "tempStream", "windowSize", "", "read", "b", "", "off", "len", "readHeader", "youtrack-events"})
public final class VcDiffInputStream
extends InputStream {
    private int windowSize;
    private InputStream tempStream;
    private boolean eof;
    private final DiffWindowEncoder vcDiff;
    private final InputStream previousSource;
    private final InputStream delta;

    @Override
    public int read() {
        if (this.readHeader()) {
            while (true) {
                if (this.tempStream != null) {
                    int result2;
                    InputStream inputStream = this.tempStream;
                    if (inputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((result2 = inputStream.read()) >= 0) {
                        return result2;
                    }
                }
                if (this.eof) break;
                LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
                this.eof = this.vcDiff.decodeDiffWindow(this.previousSource, this.delta, (OutputStream)tempOutput);
                this.tempStream = this.eof ? null : (InputStream)new ByteArrayInputStream(tempOutput.toByteArray(), 0, tempOutput.size());
            }
        }
        return this.windowSize == 0 ? this.delta.read() : -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (this.readHeader()) {
            while (true) {
                if (this.tempStream != null) {
                    int result2;
                    InputStream inputStream = this.tempStream;
                    if (inputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((result2 = inputStream.read(b, off, len)) > 0) {
                        return result2;
                    }
                }
                if (this.eof) break;
                LightByteArrayOutputStream tempOutput = new LightByteArrayOutputStream();
                this.eof = this.vcDiff.decodeDiffWindow(this.previousSource, this.delta, (OutputStream)tempOutput);
                this.tempStream = this.eof ? null : (InputStream)new ByteArrayInputStream(tempOutput.toByteArray(), 0, tempOutput.size());
            }
        }
        return this.windowSize == 0 ? this.delta.read(b, off, len) : -1;
    }

    private final boolean readHeader() {
        if (this.windowSize == -1) {
            try {
                this.windowSize = VlqEncoder.INSTANCE.readInt(this.delta);
            }
            catch (EOFException e) {
                return false;
            }
        }
        return this.windowSize > 0;
    }

    public VcDiffInputStream(@NotNull DiffWindowEncoder vcDiff, @Nullable InputStream previousSource, @NotNull InputStream delta) {
        Intrinsics.checkParameterIsNotNull((Object)vcDiff, (String)"vcDiff");
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        this.vcDiff = vcDiff;
        this.previousSource = previousSource;
        this.delta = delta;
        this.windowSize = -1;
    }
}

