/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.issue.liveupdate;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.youtrack.api.context.IContext;
import jetbrains.youtrack.api.parser.IParseResult;
import jetbrains.youtrack.context.Context;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.event.liveupdate.IssuesListSubscription;
import jetbrains.youtrack.event.liveupdate.Subscription;
import jetbrains.youtrack.event.liveupdate.SubscriptionsQueue;
import jetbrains.youtrack.eventSource.EventOutputContainer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/event/issue/liveupdate/IssueListSubscriptionImpl;", "Ljetbrains/youtrack/event/liveupdate/IssuesListSubscription;", "output", "Ljetbrains/youtrack/eventSource/EventOutputContainer;", "snapshotIssues", "", "Ljetbrains/exodus/entitystore/EntityId;", "", "projects", "", "Ljetbrains/exodus/entitystore/Entity;", "parseResult", "Ljetbrains/youtrack/api/parser/IParseResult;", "(Ljetbrains/youtrack/eventSource/EventOutputContainer;Ljava/util/Map;Ljava/util/Set;Ljetbrains/youtrack/api/parser/IParseResult;)V", "description", "", "getDescription", "()Ljava/lang/String;", "getOutput", "()Ljetbrains/youtrack/eventSource/EventOutputContainer;", "getParseResult", "()Ljetbrains/youtrack/api/parser/IParseResult;", "getProjects", "()Ljava/util/Set;", "getSnapshotIssues", "()Ljava/util/Map;", "handlePing", "", "matchesIssue", "issue", "Ljetbrains/exodus/database/TransientEntity;", "youtrack-events"})
public class IssueListSubscriptionImpl
implements IssuesListSubscription {
    @NotNull
    private final String description = "Issue list subscription";
    @NotNull
    private final EventOutputContainer output;
    @NotNull
    private final Map<EntityId, Boolean> snapshotIssues;
    @NotNull
    private final Set<Entity> projects;
    @NotNull
    private final IParseResult parseResult;

    @Override
    public boolean matchesIssue(@NotNull TransientEntity issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.parseResult.matchesIssue(new XdIssue((Entity)issue), (IContext)new Context(), new XdUser((Entity)this.getOutput().getOwner()));
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePing() {
        Closeable closeable = new SubscriptionsQueue(null, new ReentrantLock());
        boolean bl = false;
        Throwable throwable = null;
        try {
            SubscriptionsQueue queue = (SubscriptionsQueue)closeable;
            boolean bl2 = false;
            queue.doHandlePing(this.getDescription(), (Subscription)this, this.getOutput().getOwner());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public EventOutputContainer getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public Map<EntityId, Boolean> getSnapshotIssues() {
        return this.snapshotIssues;
    }

    @Override
    @NotNull
    public Set<Entity> getProjects() {
        return this.projects;
    }

    @NotNull
    public final IParseResult getParseResult() {
        return this.parseResult;
    }

    public IssueListSubscriptionImpl(@NotNull EventOutputContainer output, @NotNull Map<EntityId, Boolean> snapshotIssues, @NotNull Set<Entity> projects, @NotNull IParseResult parseResult) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(snapshotIssues, (String)"snapshotIssues");
        Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
        Intrinsics.checkParameterIsNotNull((Object)parseResult, (String)"parseResult");
        this.output = output;
        this.snapshotIssues = snapshotIssues;
        this.projects = projects;
        this.parseResult = parseResult;
        this.description = "Issue list subscription";
    }
}

