/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.persistent;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.event.ChangeHandler;
import jetbrains.charisma.event.EventMarker;
import jetbrains.charisma.event.InMemoryEventType;
import jetbrains.charisma.event.InMemoryTransactionEventsData;
import jetbrains.exodus.database.LinkChange;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityChange;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.events.XdEventType;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.event.persistent.AbstractPersistentEventFactory;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.rollback.DebugInfoMethodsKt;
import jetbrains.youtrack.persistent.XdUndefinedUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u001b\b&\u0018\u0000 H*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00052\u00020\u0006:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016JI\u0010'\u001a\u00020 2\u0006\u0010\u001d\u001a\u00028\u00022\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$H\u0014\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00102J\u0015\u00104\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00102J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\nH\u0016J\u0015\u00107\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00102J\u000e\u00108\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\nJ\u0015\u00109\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00102J\u000e\u0010:\u001a\u00020\u00142\u0006\u00106\u001a\u00020\nJ\u0010\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\nH\u0016J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\nH\u0014J\u0010\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\u0002H\u0016J%\u0010@\u001a\u00020 2\u0006\u0010\u001d\u001a\u00028\u00022\u0006\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010CJ%\u0010D\u001a\u00020 2\u0006\u0010\u001d\u001a\u00028\u00022\u0006\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010CJ\u000e\u0010G\u001a\u00020)*\u0004\u0018\u00010)H\u0002R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u001a\u0010\u0018\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u001b\u00a8\u0006I"}, d2={"Ljetbrains/youtrack/event/persistent/AbstractChangeHandler;", "RE", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "IM", "V", "Lkotlinx/dnq/XdEntity;", "Ljetbrains/charisma/event/ChangeHandler;", "()V", "ignoredLinks", "", "", "getIgnoredLinks", "()Ljava/util/Set;", "ignoredProps", "getIgnoredProps", "importedEventFactory", "Ljetbrains/youtrack/event/persistent/AbstractPersistentEventFactory;", "getImportedEventFactory", "()Ljetbrains/youtrack/event/persistent/AbstractPersistentEventFactory;", "isTarget", "", "()Z", "realEventFactory", "getRealEventFactory", "strictMode", "getStrictMode", "setStrictMode", "(Z)V", "getEventContainer", "target", "(Lkotlinx/dnq/XdEntity;)Lkotlinx/dnq/XdEntity;", "handle", "", "change", "Ljetbrains/exodus/database/TransientEntityChange;", "data", "Ljetbrains/charisma/event/InMemoryTransactionEventsData;", "marker", "Ljetbrains/charisma/event/EventMarker;", "handleLinkChange", "author", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "linkName", "linkChange", "Ljetbrains/exodus/database/LinkChange;", "timestamp", "", "(Lkotlinx/dnq/XdEntity;Ljetbrains/youtrack/core/persistent/user/XdUser;Ljava/lang/String;Ljetbrains/exodus/database/LinkChange;JLjetbrains/charisma/event/EventMarker;Ljetbrains/charisma/event/InMemoryTransactionEventsData;)V", "hasNoRemoveEvent", "v", "(Lkotlinx/dnq/XdEntity;)Z", "isAlive", "isDeleted", "isFixedNewLinesProps", "propertyName", "isIgnored", "isLinkIgnored", "isNew", "isPropertyIgnored", "isStubChange", "memberName", "isUpdatingChange", "onUndefinedAuthorEvent", "event", "setCreationTime", "createdBy", "created", "(Lkotlinx/dnq/XdEntity;Ljetbrains/youtrack/core/persistent/user/XdUser;J)V", "setUpdatingTime", "updatedBy", "updated", "orUndefinedUser", "Companion", "youtrack-events"})
public abstract class AbstractChangeHandler<RE extends XdAbstractEvent, IM extends XdAbstractEvent, V extends XdEntity>
implements ChangeHandler {
    private boolean strictMode;
    public static final Companion Companion = new Companion(null);

    public final boolean getStrictMode() {
        return this.strictMode;
    }

    public final void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    @NotNull
    public abstract AbstractPersistentEventFactory<RE, V> getRealEventFactory();

    @NotNull
    public abstract AbstractPersistentEventFactory<IM, V> getImportedEventFactory();

    @NotNull
    protected abstract Set<String> getIgnoredProps();

    @NotNull
    protected abstract Set<String> getIgnoredLinks();

    private final XdUser orUndefinedUser(@Nullable XdUser $this$orUndefinedUser) {
        XdUser xdUser = $this$orUndefinedUser;
        if (xdUser == null) {
            xdUser = (XdUser)XdUndefinedUser.Companion.get();
        }
        return xdUser;
    }

    public boolean isTarget() {
        return true;
    }

    public void handle(@NotNull TransientEntityChange change, @NotNull InMemoryTransactionEventsData data, @Nullable EventMarker marker) {
        XdUser author;
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        XdEntity v = XdExtensionsKt.toXd((Entity)((Entity)change.getTransientEntity()));
        if (v.isRemoved() || this.isIgnored(v)) {
            return;
        }
        long timestamp = data.getTimestamp();
        Entity entity = data.getAuthor();
        Object object = author = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (this.isNew(v)) {
            this.getRealEventFactory().newEvent(v, author, InMemoryEventType.ADD, timestamp, null, marker, data);
            this.setCreationTime(v, this.orUndefinedUser(author), timestamp);
        } else if (this.isAlive(v)) {
            Map changedLinksDetailed;
            TransientEntity oldVersion = change.getSnapshotEntity();
            TransientEntity newVersion = change.getTransientEntity();
            Set changedProperties = change.getChangedProperties();
            boolean wasUpdated = false;
            if (changedProperties != null) {
                List blobNames = null;
                for (String propName2 : changedProperties) {
                    if (this.isPropertyIgnored(propName2)) continue;
                    if (this.isStubChange(propName2)) {
                        this.getRealEventFactory().newEvent(v, author, InMemoryEventType.MODIFY_STUB, timestamp, propName2, marker, data);
                    } else {
                        boolean isBlob;
                        if (blobNames == null) {
                            blobNames = oldVersion.getBlobNames();
                        }
                        Comparable oldValue = (isBlob = blobNames.contains(propName2)) ? (Comparable)((Object)oldVersion.getBlobString(propName2)) : oldVersion.getProperty(propName2);
                        Comparable newValue = isBlob ? (Comparable)((Object)newVersion.getBlobString(propName2)) : newVersion.getProperty(propName2);
                        this.getRealEventFactory().newPropEvent(v, author, propName2, oldValue, newValue, timestamp, marker, data);
                    }
                    wasUpdated = wasUpdated || this.isUpdatingChange(propName2);
                }
            }
            if ((changedLinksDetailed = change.getChangedLinksDetailed()) != null) {
                for (LinkChange linkChange : changedLinksDetailed.values()) {
                    String linkName = linkChange.getLinkName();
                    if (this.isLinkIgnored(linkName)) continue;
                    if (this.isStubChange(linkName)) {
                        this.getRealEventFactory().newEvent(v, author, InMemoryEventType.MODIFY_STUB, timestamp, linkName, marker, data);
                    } else {
                        if (linkChange.getRemovedEntitiesSize() == 0 && linkChange.getAddedEntitiesSize() == 0) continue;
                        this.handleLinkChange(v, author, linkName, linkChange, timestamp, marker, data);
                    }
                    wasUpdated = wasUpdated || this.isUpdatingChange(linkName);
                }
            }
            if (wasUpdated) {
                this.setUpdatingTime(v, this.orUndefinedUser(author), timestamp);
            }
        } else if (this.isDeleted(v) && this.hasNoRemoveEvent(v)) {
            this.getRealEventFactory().newEvent(v, author, InMemoryEventType.REMOVE, timestamp, null, marker, data);
        }
    }

    private final boolean hasNoRemoveEvent(V v) {
        XdAbstractEvent lastEvent = (XdAbstractEvent)XdQueryKt.lastOrNull((XdQuery)EventQueryKt.getRealEventsDirect$default(v, null, 1, null));
        return lastEvent == null || Intrinsics.areEqual((Object)lastEvent.getType(), (Object)XdEventType.Companion.getREMOVE()) ^ true;
    }

    public final boolean isPropertyIgnored(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return this.getIgnoredProps().contains(propertyName) || StringsKt.startsWith$default((String)propertyName, (String)"__PARENT_TO_CHILD_LINK_NAME__", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)propertyName, (String)"__CHILD_TO_PARENT_LINK_NAME__", (boolean)false, (int)2, null);
    }

    public final boolean isLinkIgnored(@NotNull String linkName) {
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        return this.getIgnoredLinks().contains(linkName);
    }

    protected void handleLinkChange(@NotNull V target, @Nullable XdUser author, @NotNull String linkName, @NotNull LinkChange linkChange, long timestamp, @Nullable EventMarker marker, @NotNull InMemoryTransactionEventsData data) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull((Object)linkChange, (String)"linkChange");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.getRealEventFactory().newLinkEvent(target, author, linkName, linkChange.getRemovedEntities(), linkChange.getAddedEntities(), timestamp, marker, data);
    }

    @Nullable
    public abstract XdEntity getEventContainer(@NotNull V var1);

    protected abstract boolean isNew(@NotNull V var1);

    protected void setCreationTime(@NotNull V target, @NotNull XdUser createdBy, long created) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)createdBy, (String)"createdBy");
    }

    protected void setUpdatingTime(@NotNull V target, @NotNull XdUser updatedBy, long updated) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)updatedBy, (String)"updatedBy");
    }

    protected boolean isUpdatingChange(@NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        return true;
    }

    public boolean isStubChange(@NotNull String memberName) {
        Intrinsics.checkParameterIsNotNull((Object)memberName, (String)"memberName");
        return false;
    }

    public boolean isFixedNewLinesProps(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        return false;
    }

    protected abstract boolean isAlive(@NotNull V var1);

    protected abstract boolean isDeleted(@NotNull V var1);

    protected abstract boolean isIgnored(@NotNull V var1);

    public void onUndefinedAuthorEvent(@NotNull XdAbstractEvent event2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)event2), (String)"event");
        String msg = "Created " + this.getTargetEntityType() + " event " + DebugInfoMethodsKt.getEventDebugInfo(event2) + " with undefined author";
        if (this.strictMode) {
            throw (Throwable)new RuntimeException(msg);
        }
        Companion.getLogger().warn(msg);
        Companion.getLogger().debug(msg, (Throwable)new RuntimeException("Trace event source"));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/event/persistent/AbstractChangeHandler$Companion;", "Lmu/KLogging;", "()V", "youtrack-events"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

