/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.refactoring;

import java.util.List;
import java.util.Set;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.event.persistent.EventQueryKt;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.refactoring.RefactoringRestoreIssueFieldUpdated;
import jetbrains.youtrack.refactoring.DslKt;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.refactoring.XdRefactoringKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/event/refactoring/RefactoringRestoreIssueFieldUpdated;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "name", "", "getName", "()Ljava/lang/String;", "affectsIssueFieldUpdated", "", "event", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "apply", "", "restoreUpdatedFromHistory", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "shouldApply", "toWarnString", "created", "", "updated", "Companion", "youtrack-events"})
public final class RefactoringRestoreIssueFieldUpdated
extends XdRefactoring {
    private static final String OPTION_KEY = "jetbrains.youtrack.event.RefactoringRestoreIssueFieldUpdated";
    private static final String C_LINK;
    private static final String A_LINK;
    private static final String W_LINK;
    private static final Set<String> IGNORED_ISSUE_MEMBER_NAMES;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return "Renew issue property updated according to the last event";
    }

    public boolean shouldApply() {
        return Intrinsics.areEqual((Object)"true", (Object)ConfigurationParameter.getParameter((String)OPTION_KEY));
    }

    public void apply() {
        String message = "Verified timestamp \"updated\" in %d issue";
        XdRefactoringKt.processInBatches$default((List)XdQueryKt.toList((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssue.Companion), (Function2)apply.1.INSTANCE)), (String)message, (int)0, (Function1)((Function1)new Function1<XdIssue, Unit>(this){
            final /* synthetic */ RefactoringRestoreIssueFieldUpdated this$0;

            public final void invoke(@NotNull XdIssue issue) {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                DslKt.refactor((XdIssue)issue, (Function1)((Function1)new Function1<XdIssue, Unit>(this, issue){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ XdIssue $issue;

                    public final void invoke(@NotNull XdIssue $this$refactor) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$refactor, (String)"$receiver");
                        RefactoringRestoreIssueFieldUpdated.access$restoreUpdatedFromHistory(this.this$0.this$0, this.$issue);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$issue = xdIssue;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = refactoringRestoreIssueFieldUpdated;
                super(1);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreUpdatedFromHistory(XdIssue issue) {
        void issueWithoutHistory;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        XdAbstractEvent lastEventUpdatedIssue2 = (XdAbstractEvent)((Object)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)EventQueryKt.getEventsReversed$default((XdEntity)issue, null, 1, null)), (Function1)((Function1)new Function1<XdAbstractEvent, Boolean>(this, (Ref.BooleanRef)issueWithoutHistory){
            final /* synthetic */ RefactoringRestoreIssueFieldUpdated this$0;
            final /* synthetic */ Ref.BooleanRef $issueWithoutHistory;

            public final boolean invoke(@NotNull XdAbstractEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                this.$issueWithoutHistory.element = false;
                return RefactoringRestoreIssueFieldUpdated.access$affectsIssueFieldUpdated(this.this$0, it);
            }
            {
                this.this$0 = refactoringRestoreIssueFieldUpdated;
                this.$issueWithoutHistory = booleanRef;
                super(1);
            }
        }))));
        long created = issue.getCreated();
        long updated = issue.getUpdated();
        if (issueWithoutHistory.element) {
            if (created != updated) {
                Companion.getLogger().warn((Function0)new Function0<String>(this, issue, created, updated){
                    final /* synthetic */ RefactoringRestoreIssueFieldUpdated this$0;
                    final /* synthetic */ XdIssue $issue;
                    final /* synthetic */ long $created;
                    final /* synthetic */ long $updated;

                    @NotNull
                    public final String invoke() {
                        return "Issue " + this.$issue.getIdReadable() + " has no history, " + RefactoringRestoreIssueFieldUpdated.access$toWarnString(this.this$0, this.$created, this.$updated);
                    }
                    {
                        this.this$0 = refactoringRestoreIssueFieldUpdated;
                        this.$issue = xdIssue;
                        this.$created = l;
                        this.$updated = l2;
                        super(0);
                    }
                });
            }
        } else if (lastEventUpdatedIssue2 == null) {
            if (created != updated) {
                Companion.getLogger().warn((Function0)new Function0<String>(this, issue, created, updated){
                    final /* synthetic */ RefactoringRestoreIssueFieldUpdated this$0;
                    final /* synthetic */ XdIssue $issue;
                    final /* synthetic */ long $created;
                    final /* synthetic */ long $updated;

                    @NotNull
                    public final String invoke() {
                        return "Issue " + this.$issue.getIdReadable() + " has no events affecting property \"updated\", " + RefactoringRestoreIssueFieldUpdated.access$toWarnString(this.this$0, this.$created, this.$updated);
                    }
                    {
                        this.this$0 = refactoringRestoreIssueFieldUpdated;
                        this.$issue = xdIssue;
                        this.$created = l;
                        this.$updated = l2;
                        super(0);
                    }
                });
            }
        } else {
            long timestamp = lastEventUpdatedIssue2.getTimestamp();
            if (timestamp != updated) {
                if (timestamp < updated) {
                    Companion.getLogger().debug((Function0)new Function0<String>(this, issue, created, updated){
                        final /* synthetic */ RefactoringRestoreIssueFieldUpdated this$0;
                        final /* synthetic */ XdIssue $issue;
                        final /* synthetic */ long $created;
                        final /* synthetic */ long $updated;

                        @NotNull
                        public final String invoke() {
                            return "Issue " + this.$issue.getIdReadable() + ", but issue was updated later " + RefactoringRestoreIssueFieldUpdated.access$toWarnString(this.this$0, this.$created, this.$updated) + ", " + "this information will be lost.";
                        }
                        {
                            this.this$0 = refactoringRestoreIssueFieldUpdated;
                            this.$issue = xdIssue;
                            this.$created = l;
                            this.$updated = l2;
                            super(0);
                        }
                    });
                }
                issue.setUpdated(timestamp);
            }
        }
    }

    private final String toWarnString(long created, long updated) {
        return "{created: " + created + ", updated: " + updated + '}';
    }

    private final boolean affectsIssueFieldUpdated(XdAbstractEvent event2) {
        String string = event2.getMemberName();
        if (string == null) {
            return true;
        }
        String memberName = string;
        List list = event2.getEntity().getLinkNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"event.entity.linkNames");
        Set linkNames = CollectionsKt.toSet((Iterable)list);
        return !linkNames.contains(C_LINK) && !linkNames.contains(A_LINK) && !linkNames.contains(W_LINK) && !IGNORED_ISSUE_MEMBER_NAMES.contains(memberName);
    }

    static {
        Companion = new Companion(null);
        C_LINK = XdAbstractEvent.Companion.linkToTarget("IssueComment");
        A_LINK = XdAbstractEvent.Companion.linkToTarget("IssueAttachment");
        W_LINK = XdAbstractEvent.Companion.linkToTarget("IssueWorkItem");
        IGNORED_ISSUE_MEMBER_NAMES = SetsKt.setOf((Object[])new String[]{"voters", "votes", "tags"});
    }

    public static final /* synthetic */ void access$restoreUpdatedFromHistory(RefactoringRestoreIssueFieldUpdated $this, XdIssue issue) {
        $this.restoreUpdatedFromHistory(issue);
    }

    public static final /* synthetic */ boolean access$affectsIssueFieldUpdated(RefactoringRestoreIssueFieldUpdated $this, XdAbstractEvent event2) {
        return $this.affectsIssueFieldUpdated(event2);
    }

    public static final /* synthetic */ String access$toWarnString(RefactoringRestoreIssueFieldUpdated $this, long created, long updated) {
        return $this.toWarnString(created, updated);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/event/refactoring/RefactoringRestoreIssueFieldUpdated$Companion;", "Lmu/KLogging;", "()V", "A_LINK", "", "C_LINK", "IGNORED_ISSUE_MEMBER_NAMES", "", "OPTION_KEY", "W_LINK", "youtrack-events"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

