/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.event.rollback.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.youtrack.api.events.Event;
import jetbrains.youtrack.api.events.XdEventType;
import jetbrains.youtrack.event.persistent.AbstractChangeHandler;
import jetbrains.youtrack.event.persistent.XdAbstractEvent;
import jetbrains.youtrack.event.rollback.BlobSnapshot;
import jetbrains.youtrack.event.rollback.CorruptedEvent;
import jetbrains.youtrack.event.rollback.LinkSnapshot;
import jetbrains.youtrack.event.rollback.PropSnapshot;
import jetbrains.youtrack.event.rollback.Snapshot;
import jetbrains.youtrack.event.rollback.snapshot.EntityExistenceSnapshot;
import jetbrains.youtrack.gaprest.BeansKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/event/rollback/snapshot/EntitySnapshot;", "Ljetbrains/youtrack/event/rollback/Snapshot;", "entity", "Ljetbrains/exodus/entitystore/Entity;", "(Ljetbrains/exodus/entitystore/Entity;)V", "blobsSnapshots", "", "", "Ljetbrains/youtrack/event/rollback/BlobSnapshot;", "getEntity", "()Ljetbrains/exodus/entitystore/Entity;", "existenceSnapshot", "Ljetbrains/youtrack/event/rollback/snapshot/EntityExistenceSnapshot;", "linksSnapshots", "Ljetbrains/youtrack/event/rollback/LinkSnapshot;", "propsSnapshots", "Ljetbrains/youtrack/event/rollback/PropSnapshot;", "secondaryEntitiesSnapshots", "getLink", "Lkotlinx/dnq/query/XdQuery;", "T", "Lkotlinx/dnq/XdEntity;", "linkName", "entityType", "Lkotlinx/dnq/XdEntityType;", "getProp", "", "propName", "rollback", "Ljetbrains/youtrack/api/events/Event;", "event", "Ljetbrains/youtrack/event/persistent/XdAbstractEvent;", "youtrack-events"})
public final class EntitySnapshot
implements Snapshot {
    private EntityExistenceSnapshot existenceSnapshot;
    private final Map<String, PropSnapshot> propsSnapshots;
    private final Map<String, BlobSnapshot> blobsSnapshots;
    private final Map<String, LinkSnapshot> linksSnapshots;
    private final Map<Entity, Snapshot> secondaryEntitiesSnapshots;
    @NotNull
    private final Entity entity;

    @Override
    @NotNull
    public Event rollback(@NotNull XdAbstractEvent event2) {
        Snapshot snapshot;
        Snapshot snapshot2;
        Snapshot snapshot3;
        Intrinsics.checkParameterIsNotNull((Object)((Object)event2), (String)"event");
        Entity target = event2.getTarget();
        if (Intrinsics.areEqual((Object)target, (Object)this.entity) ^ true) {
            Snapshot snapshot4;
            Map<Entity, Snapshot> $this$getOrPut$iv = this.secondaryEntitiesSnapshots;
            boolean $i$f$getOrPut = false;
            Snapshot value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl = false;
                EntitySnapshot answer$iv = new EntitySnapshot(target);
                $this$getOrPut$iv.put(target, answer$iv);
                snapshot4 = answer$iv;
            } else {
                snapshot4 = value$iv;
            }
            snapshot3 = snapshot4;
        } else {
            Map<String, Snapshot> $this$getOrPut$iv;
            String memberName = event2.getMemberName();
            XdEventType xdEventType = event2.getType();
            if (Intrinsics.areEqual((Object)xdEventType, (Object)XdEventType.Companion.getADD()) || Intrinsics.areEqual((Object)xdEventType, (Object)XdEventType.Companion.getREMOVE())) {
                snapshot3 = this.existenceSnapshot;
            } else if (Intrinsics.areEqual((Object)xdEventType, (Object)XdEventType.Companion.getMODIFY_PROPERTY())) {
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                BlobSnapshot blobSnapshot = this.blobsSnapshots.get(string);
                if (blobSnapshot != null) {
                    snapshot3 = blobSnapshot;
                } else {
                    Snapshot snapshot5;
                    $this$getOrPut$iv = this.propsSnapshots;
                    boolean $i$f$getOrPut = false;
                    Snapshot value$iv = $this$getOrPut$iv.get(memberName);
                    if (value$iv == null) {
                        boolean bl = false;
                        PropSnapshot propSnapshot = new PropSnapshot(target, memberName);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        PropSnapshot $this$apply = propSnapshot;
                        boolean bl4 = false;
                        $this$apply.setValue(null);
                        PropSnapshot answer$iv = propSnapshot;
                        $this$getOrPut$iv.put(memberName, answer$iv);
                        snapshot5 = answer$iv;
                    } else {
                        snapshot5 = value$iv;
                    }
                    snapshot3 = snapshot5;
                }
            } else if (Intrinsics.areEqual((Object)xdEventType, (Object)XdEventType.Companion.getMODIFY_LINK())) {
                Snapshot snapshot6;
                $this$getOrPut$iv = this.linksSnapshots;
                String string = memberName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String key$iv = string;
                boolean $i$f$getOrPut = false;
                Snapshot value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    LinkSnapshot answer$iv = new LinkSnapshot(target, memberName);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    snapshot6 = answer$iv;
                } else {
                    snapshot6 = value$iv;
                }
                snapshot3 = snapshot6;
            } else {
                snapshot3 = null;
            }
        }
        if ((snapshot2 = (snapshot = snapshot3)) == null || (snapshot2 = snapshot2.rollback(event2)) == null) {
            snapshot2 = new CorruptedEvent(event2);
        }
        return snapshot2;
    }

    @Nullable
    public final Comparable<?> getProp(@NotNull String propName2) {
        Comparable<Object> comparable;
        Intrinsics.checkParameterIsNotNull((Object)propName2, (String)"propName");
        PropSnapshot propSnapshot = this.propsSnapshots.get(propName2);
        if (propSnapshot != null) {
            comparable = propSnapshot.getPropertyValue();
        } else {
            BlobSnapshot blobSnapshot = this.blobsSnapshots.get(propName2);
            comparable = blobSnapshot != null ? blobSnapshot.getBlobStringValue() : null;
        }
        return comparable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends XdEntity> XdQuery<T> getLink(@NotNull String linkName, @NotNull XdEntityType<? extends T> entityType) {
        LinkSnapshot linkSnapshot;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
                Intrinsics.checkParameterIsNotNull(entityType, (String)"entityType");
                TransientStoreSession session = XdExtensionsKt.getSession((TransientEntityStore)((TransientEntityStore)BeansKt.getTransientEntityStore()));
                linkSnapshot = this.linksSnapshots.get(linkName);
                if (linkSnapshot == null || (linkSnapshot = linkSnapshot.getLinkValue()) == null) break block3;
                Iterable $this$map$iv = (Iterable)((Object)linkSnapshot);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EntityId entityId = (EntityId)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Entity entity = session.getEntity((EntityId)it);
                    collection.add(entity);
                }
                linkSnapshot = XdQueryKt.asQuery((Iterable)((List)destination$iv$iv), entityType);
                if (linkSnapshot != null) break block4;
            }
            linkSnapshot = XdQueryKt.emptyQuery(entityType);
        }
        return linkSnapshot;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    public EntitySnapshot(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.entity = entity;
        this.existenceSnapshot = new EntityExistenceSnapshot();
        this.propsSnapshots = new HashMap();
        this.blobsSnapshots = new HashMap();
        this.linksSnapshots = new HashMap();
        this.secondaryEntitiesSnapshots = new HashMap();
        AbstractChangeHandler<?, ?, ?> abstractChangeHandler = jetbrains.youtrack.event.persistent.BeansKt.changeHandler(this.entity);
        if (abstractChangeHandler == null) {
            throw (Throwable)new IllegalStateException("can't find change handler for " + this.entity.getType());
        }
        AbstractChangeHandler<?, ?, ?> handler = abstractChangeHandler;
        List list = this.entity.getPropertyNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entity.propertyNames");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String propName2 = (String)element$iv;
            boolean bl = false;
            String string = propName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"propName");
            if (handler.isPropertyIgnored(string) || handler.isStubChange(propName2)) continue;
            this.propsSnapshots.put(propName2, new PropSnapshot(this.entity, propName2));
        }
        List list2 = this.entity.getBlobNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"entity.blobNames");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String blobName = (String)element$iv;
            boolean bl = false;
            String string = blobName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"blobName");
            if (handler.isPropertyIgnored(string) || handler.isStubChange(blobName)) continue;
            this.blobsSnapshots.put(blobName, new BlobSnapshot(this.entity, blobName));
        }
    }
}

