/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.gaprest.filters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.gaprest.filters.ReadWriteTransactional;
import jetbrains.youtrack.gaprest.filters.ReadonlyTransactional;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Provider
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\r8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/gaprest/filters/ReadonlyTransactionUpdaterFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "()V", "readonlyHttpMethods", "", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "getRequest", "()Ljavax/servlet/http/HttpServletRequest;", "setRequest", "(Ljavax/servlet/http/HttpServletRequest;)V", "requestInfo", "Ljavax/ws/rs/container/ResourceInfo;", "getRequestInfo", "()Ljavax/ws/rs/container/ResourceInfo;", "setRequestInfo", "(Ljavax/ws/rs/container/ResourceInfo;)V", "filter", "", "requestContext", "Ljavax/ws/rs/container/ContainerRequestContext;", "isAnnotated", "", "annotation", "Ljava/lang/Class;", "", "methodIsReadOnly", "Companion", "youtrack-gap-rest"})
public class ReadonlyTransactionUpdaterFilter
implements ContainerRequestFilter {
    @Context
    @NotNull
    public ResourceInfo requestInfo;
    @Context
    @NotNull
    public HttpServletRequest request;
    private final Set<String> readonlyHttpMethods = SetsKt.setOf((Object[])new String[]{"GET", "OPTIONS", "HEAD"});
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ResourceInfo getRequestInfo() {
        ResourceInfo resourceInfo = this.requestInfo;
        if (resourceInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestInfo");
        }
        return resourceInfo;
    }

    public void setRequestInfo(@NotNull ResourceInfo resourceInfo) {
        Intrinsics.checkParameterIsNotNull((Object)resourceInfo, (String)"<set-?>");
        this.requestInfo = resourceInfo;
    }

    @NotNull
    public HttpServletRequest getRequest() {
        HttpServletRequest httpServletRequest = this.request;
        if (httpServletRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
        }
        return httpServletRequest;
    }

    public void setRequest(@NotNull HttpServletRequest httpServletRequest) {
        Intrinsics.checkParameterIsNotNull((Object)httpServletRequest, (String)"<set-?>");
        this.request = httpServletRequest;
    }

    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkParameterIsNotNull((Object)requestContext, (String)"requestContext");
        if (this.methodIsReadOnly(requestContext)) {
            DnqUtils.getCurrentTransientSession().setUpgradeHook(new Runnable(this){
                final /* synthetic */ ReadonlyTransactionUpdaterFilter this$0;

                public final void run() {
                    StringBuilder stringBuilder = new StringBuilder().append("Request ").append(this.this$0.getRequest().getMethod()).append(' ').append(this.this$0.getRequest().getRequestURL()).append(" mapped to").append(' ');
                    Class clazz = this.this$0.getRequestInfo().getResourceClass();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"requestInfo.resourceClass");
                    StringBuilder stringBuilder2 = stringBuilder.append(clazz.getName()).append('.');
                    Method method = this.this$0.getRequestInfo().getResourceMethod();
                    Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"requestInfo.resourceMethod");
                    String message = stringBuilder2.append(method.getName()).append(" must not modify database, but it has tried").toString();
                    ReadonlyTransactionException exception = new ReadonlyTransactionException(message);
                    ReadonlyTransactionUpdaterFilter.Companion.getLogger().error(message, (Throwable)exception);
                    throw (Throwable)exception;
                }
                {
                    this.this$0 = readonlyTransactionUpdaterFilter;
                }
            });
        } else {
            DnqUtils.getCurrentTransientSession().setUpgradeHook(null);
        }
    }

    private final boolean methodIsReadOnly(ContainerRequestContext requestContext) {
        return this.readonlyHttpMethods.contains(requestContext.getMethod()) ? !this.isAnnotated(ReadWriteTransactional.class) : this.isAnnotated(ReadonlyTransactional.class);
    }

    private final boolean isAnnotated(Class<? extends Annotation> annotation) {
        Method method = this.getRequestInfo().getResourceMethod();
        return method != null ? method.isAnnotationPresent(annotation) : true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/gaprest/filters/ReadonlyTransactionUpdaterFilter$Companion;", "Lmu/KLogging;", "()V", "youtrack-gap-rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

