const http = require('@jetbrains/youtrack-scripting-api/http');

function makeBasicConnection(context) {
    const params = context.parameters;

    const url = params.loadValue('url');
    const sslKeyName = params.loadValue('sslKeyName');
    const login = params.loadValue('login');
    const tokenOrPassword = params.loadValue('password');

    return new http.Connection(url, sslKeyName)
        .basicAuth(login, tokenOrPassword);
}

function makeHttpConnection(context) {
    return makeBasicConnection(context)
        .addHeader('Accept', 'application/json, */*')
        .addHeader('Content-Type', 'application/json');
}

function loadJsonFactory(connection) {
    return function loadJson(uri, queryParams) {
        const result = connection.getSync(uri, queryParams);
        if (!result.isSuccess) {
            throw 'Failed to load data from ' + uri + ' code ' + result.code;
        } else {
            return JSON.parse(result.response);
        }
    }
}

function postJsonFactory(connection) {
    return function postJson(uri, queryParams, payload) {
        const result = connection.postSync(uri, queryParams, payload);
        if (!result.isSuccess) {
            throw 'Failed to load data from ' + uri + ' code ' + result.code;
        } else {
            return JSON.parse(result.response);
        }
    }
}

module.exports = {
    makeHttpConnection: makeHttpConnection,
    loadJsonFactory: loadJsonFactory,
    postJsonFactory: postJsonFactory
}